/*
 * @maskSymbolsListStruct.java Version 1.1 07/20/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package mask;

import mask.maskColorsStruct;
import mask.maskGroupsStruct;
import mask.maskSymbolsStruct;

/** Class maskSymbolsListStruct
 *  <p> This Class holds the Mask Symbol Plot Data.
 *
 *  @version 1.1 07/20/2009
 *  @author  John R. Victorine
 */

public class maskSymbolsListStruct
{
  public static final int _SYMBOLS   = 0;
  public static final int _MODIFIERS = 1;

  // Mask Colors

  public maskColorsStruct  stForeground = null; // foreground colors
  public maskColorsStruct  stBackground = null; // background colors

  // Mask Groups

  public maskGroupsStruct  stGroups     = null; // Mask Groups

  // Mask Modifiers

  public int               iModifiers    = 0;    // Total Number of Records
  public maskSymbolsStruct stModifiers[] = null; // Mask Symbols Structure

  // Mask Symbols

  public int               iCount       = 0;    // Total Number of Records
  public maskSymbolsStruct stItem[]     = null; // Mask Symbols Structure

  // Keywords

  public int               iKeywords    = 0;    // Total Number of Keywords
  public String            sKeywords[]  = null; // Keyword List

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    if (stForeground != null)
      stForeground.delete();
    stForeground = null; // foreground colors

    if (stBackground != null)
      stBackground.delete();
    stBackground = null; // background colors

    if (stGroups != null)
      stGroups.delete();
    stGroups = null;     // Mask Groups

    for (int i=0; i<iModifiers; i++)
    {
      if (stModifiers[i] != null)
        stModifiers[i].delete();
      stModifiers[i] = null;
    }

    iModifiers = 0;

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;

    iKeywords = 0;
    sKeywords = null;
  }
}
