/*
 * @textureStruct.java Version 1.1 09/12/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.texture;

/** Class textureStruct
 *  <p> This Class holds the Rock Texture Depth Data.
 *
 *  @version 1.1 09/12/2007
 *  @author  John R. Victorine
 */

public class textureStruct
{
  // Type of sediment

  public static final int  NONE      = lith.texture.textureConstants.NONE;
  public static final int  SANDSTONE = lith.texture.textureConstants.SANDSTONE;
  public static final int  CARBONATE = lith.texture.textureConstants.CARBONATE;
  public static final int  EVAPORITE = lith.texture.textureConstants.EVAPORITE;
  public static final int  ORGANIC   = lith.texture.textureConstants.ORGANIC;
  public static final int  OTHER     = lith.texture.textureConstants.OTHER;

  // Rock Texture

  // Sedimentary Texture Variables

  public String sKEY        = "0";

  public double depthStart  = 0.0; // Starting Depth
  public double depthEnd    = 0.0; // Ending Depth

  /* ---------------------------------------------------- *
   * --------------------- ROCK TYPE -------------------- *
   * ---------------------------------------------------- */

  public int    iType = NONE;
  public String sType = "";

  /* ---------------------------------------------------- *
   * -------------------- ROCK TEXTURE ------------------ *
   * ---------------------------------------------------- */

  public int    iEnergy  = 0; // Energy Level 1=low to 16=high
  public int    iRGB[]   = { 255, 255, 255 }; // Texture Background Color
  public int    id       = lith.lithology.lithologySymbolsStruct._NONE;
  public int    iSymbol  = lith.lithology.lithologySymbolsStruct._NONE;

  public int    iTexture = NONE;
  public String sTexture = "";

  /* ---------------------------------------------------- *
   * ------------------ ROCK COMPOSITION ---------------- *
   * ---------------------------------------------------- */

  public int    iComposition = lith.texture.textureTypesStruct.NONE;
  public String sComposition = "";

  /* .................................................... *
   * ............... Siliclastic Variables .............. *
   * .................................................... */

  // Clay / Silt matrix

  public double dClay        = 0.0;  // Clay / Fine Silt

  // QFR Content Values

  public double dQuartz      = 0.0;  // Quartz
  public double dFeldspar    = 0.0;  // Feldspar
  public double dRock        = 0.0;  // Rock Fragments

  // VMS Content Values

  public double dVolcanic    = 0.0;  // Volcanic Rocks
  public double dMetamorphic = 0.0;  // Metamorphic Rocks
  public double dSedimentary = 0.0;  // Sedimentary Rocks

  // Sedimentary Rock Content Values

  public double dChert       = 0.0;  // Chert
  public double dCarbonate   = 0.0;  // Carbonate
  public double dSilicate    = 0.0;  // Silicate

  /* .................................................... *
   * ....... Carbonate Allochemical Rock Variables ...... *
   * .................................................... */

  // Allochemical Rocks

  public String sOther  = ""; // Other descriptor names

  // Allochem Type

  public int    iAlloType = lith.texture.textureTypesStruct._TYPE_NONE;
  public String sAlloType = "";  // Allochem Type "I", "II", or "III"

  // Matrix Type

  public int    iMatrix = lith.texture.textureTypesStruct._MATRIX_NONE;
  public String sMatrix = "";  // Matrix - "Sparite" or "Micrite"

  // Prefix

  public String sPrefix = "";  // Prefix "", "intra", "oo", "bio", "pel"

  // Percent number of Allochems

  public double dIntraclasts = 0.0; // Intraclasts Percent Compostion Value
  public double dOoids       = 0.0; // Ooids Percent Compostion Value
  public double dBioclasts   = 0.0; // Bioclasts Percent Compostion Value
  public double dPeloids     = 0.0; // Peloids Percent Compostion Value

  /* ---------------------------------------------------- *
   * --------------------- GRAIN SIZE ------------------- *
   * ---------------------------------------------------- */

  public static final int _DEFAULT    = 0;  // Default Grain Size Scale
  public static final int _USER_INPUT = 1;  // User defined Grain Size Scale

  public int    iData     = _DEFAULT;

  public int    iRows     = 0;

  public int    iDesCols  = 2;
  public String sDesc[][] = null;

  public int    iColumns  = 4;
  public double data[][]  = null;

  public int    iClass   = NONE;
  public double dSize    = 0.0;
  public double dPhi     = 0.0;
  public String sClass   = "";

  /* .................................................... *
   * .............. Grain Sorting Variables ............. *
   * .................................................... */

  public int    iSorted  = NONE;
  public double dSorted  = 0.0;
  public String sorted   = "";

  /* .................................................... *
   * ............. Grain Skewness Variables ............. *
   * .................................................... */

  public int    iSkewed  = NONE;
  public double dSkewed  = 0.0;
  public String skewed   = "";

  // Plot Texture by Cell -- OLD Texture Variables --

  public static final int  _TOTAL_TEXTURES = 6;
  public static final int  TOTAL           = 10;
  public int    iLithology[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sKEY       = null;

    iRGB       = null;

    sTexture   = null;
    sType      = null;

    sOther     = null;
    sAlloType  = null;
    sMatrix    = null;
    sPrefix    = null;

    // Grain Size Variables

    sClass     = null;
    sorted     = null;
    skewed     = null;

    sDesc      = null;
    data       = null;

    // Old texture plot variables

    iLithology = null;
  }
}