/*
 * @textureConstants.java Version 1.1 09/02/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.texture;

/** Class textureConstants
 *  <p> This Class holds the Texture Constants
 *
 *  @version 1.1 09/02/2009
 *  @author  John R. Victorine
 */

public class textureConstants
{
  // Type of sediment

  public static final int  NONE      = -1;
  public static final int  SANDSTONE = 0;
  public static final int  CARBONATE = 1;
  public static final int  EVAPORITE = 2;
  public static final int  ORGANIC   = 3;
  public static final int  OTHER     = 4;

  // GROUP

  public static final int _G_MUD       = 0;
  public static final int _G_SAND      = 1;
  public static final int _G_GRAV      = 2;
  public static final int _G_CO3_DUN   = 3;
  public static final int _G_CO3_DUN_2 = 4;
  public static final int _G_DOL_DUN   = 5;
  public static final int _G_DOL_DUN_2 = 6;

  public static final String GROUPS[] = {
      "Mud", "Sand", "Gravel",
      "Limestone Grains", "Limestone Large Grains",
      "Dolomite Grains",  "Dolomite Large Grains" };

  // Siliciclastic constants

  public static final int SIO2_COLOR[][] =
  { {  64,  64,  64 },
    { 128, 128, 128 },

    { 150, 150, 150 },
    { 192, 192, 192 },

    { 204, 204, 153 },
    { 255, 204,  51 },
    { 255, 230,   0 },
    { 255, 255,  52 },
    { 240, 255,  52 },

    { 204, 255,  52 },

    { 153, 204, 150 },
    { 153, 204,  51 },

    { 102, 204, 150 },
    { 102, 204,   0 },

    { 102, 180,  25 },
    { 102, 153,  52 } };

  public static final String SIO2_NAME[][] =
  {
    { "Mud",    "Clay" },
    { "Mud",    "Clay" },
    { "Mud",    "Silt" },
    { "Mud",    "Silt" },
    { "Sand",   "Very Fine Sand" },
    { "Sand",   "Fine Sand" },
    { "Sand",   "Medium Sand" },
    { "Sand",   "Coarse Sand" },
    { "Sand",   "Very Coarse Sand" },
    { "Gravel", "Granules" },
    { "Gravel", "Pebbles" },
    { "Gravel", "Pebbles" },
    { "Gravel", "Cobbles" },
    { "Gravel", "Cobbles" },
    { "Gravel", "Boulders" },
    { "Gravel", "Boulders" },
  };

  public static final int SIO2_TEXTURE[][] =
  {
    { lith.lithology.lithologySymbolsStruct._CLAY, 1 },
    { lith.lithology.lithologySymbolsStruct._CLAY, 2 },

    { lith.lithology.lithologySymbolsStruct._SILT, 3 },
    { lith.lithology.lithologySymbolsStruct._SILT, 4 },

    { lith.lithology.lithologySymbolsStruct._SAND, 5 },
    { lith.lithology.lithologySymbolsStruct._SAND, 6 },
    { lith.lithology.lithologySymbolsStruct._SAND, 7 },
    { lith.lithology.lithologySymbolsStruct._SAND, 8 },
    { lith.lithology.lithologySymbolsStruct._SAND, 9 },

    { lith.lithology.lithologySymbolsStruct._GRAVEL, 10 },

    { lith.lithology.lithologySymbolsStruct._GRAVEL, 11 },
    { lith.lithology.lithologySymbolsStruct._GRAVEL, 12 },

    { lith.lithology.lithologySymbolsStruct._GRAVEL, 13 },
    { lith.lithology.lithologySymbolsStruct._GRAVEL, 14 },

    { lith.lithology.lithologySymbolsStruct._GRAVEL, 15 },
    { lith.lithology.lithologySymbolsStruct._GRAVEL, 16 },
  };

  public static final int _CLAY        = 0;
  public static final int _SILT        = 1;
  public static final int _VERY_FINE   = 2;
  public static final int _FINE        = 3;
  public static final int _MEDIUM      = 4;
  public static final int _COARSE      = 5;
  public static final int _VERY_COARSE = 6;
  public static final int _GRANULE     = 7;
  public static final int _PEBBLE      = 8;
  public static final int _COBBLE      = 9;
  public static final int _BOULDER     = 10;
  public static final int _TOTAL_SILICLASTIC = 11;

  public static final String SiO2[][] =
  {
    //  Type       Size Class       Abbreviation
    { "Mud",    "Clay",               "cl",   "< 1/256" },
    { "Mud",    "Silt",               "slt",  "1/256 - 1/16 mm" },
    { "Sand",   "Sand - Very Fine",   "*f",   "1/16 - 1/8 mm" },
    { "Sand",   "Sand - Fine",        "f",    "1/8 - 1/4 mm" },
    { "Sand",   "Sand - Medium",      "m",    "1/4 - 1/2 mm" },
    { "Sand",   "Sand - Coarse",      "crs",  "1/2 - 1 mm" } ,
    { "Sand",   "Sand - Very Coarse", "*crs", "1 - 2 mm" },
    { "Gravel", "Granules",           "gran", "2 - 4 mm" },
    { "Gravel", "Pebbles",            "pbl",  "4 - 64 mm" },
    { "Gravel", "Cobbles",            "cbl",  "64 - 256 mm" },
    { "Gravel", "Boulders",           "bld",  "> 256 mm" }
  };

  //                                     cly slt vf f  m  c vc  gra peb cob bou
  public static final int SiO2_CELLS[] = {2,  4, 5, 6, 7, 8, 9, 10, 12, 14, 16 };
  public static final int SiO2_COUNT   = 9;

  // Carbonate-Limestone constants

  // -- Limestone

    public static final int LIMESTONE_COLOR[][] =
    { { 47,101,86},
      {107,160,130},   // Mudstone
      { 0,157,118},

      {  48,98,107},   // Wackestone
      {105,156,160},

      { 42,141,158}, // Packstone
      {   0, 180, 204 },

      { 102, 204, 255 },  // Grainstone
      { 128, 255, 255 },

      { 98,99,157 },  // Boundstone
      { 131,125,162 },
      { 186,132,195 },

      { 164,51,147 } };  // Crystalline

  public static final int LIMESTONE_TEXTURE[][] =
  {
    { lith.lithology.lithologySymbolsStruct._LIMESTONE, 1 },
    { lith.lithology.lithologySymbolsStruct._LIMESTONE, 2 },

    { lith.lithology.lithologySymbolsStruct._LIMESTONE, 3 },
    { lith.lithology.lithologySymbolsStruct._LIMESTONE, 4 },

    { lith.lithology.lithologySymbolsStruct._LIMESTONE, 5 },
    { lith.lithology.lithologySymbolsStruct._LIMESTONE, 6 },
    { lith.lithology.lithologySymbolsStruct._LIMESTONE, 7 },
    { lith.lithology.lithologySymbolsStruct._LIMESTONE, 8 },
    { lith.lithology.lithologySymbolsStruct._LIMESTONE, 9 },

    { lith.lithology.lithologySymbolsStruct._BIOLITHITE, 10 },

    { lith.lithology.lithologySymbolsStruct._BIOLITHITE, 11 },
    { lith.lithology.lithologySymbolsStruct._BIOLITHITE, 12 },

    { lith.lithology.lithologySymbolsStruct._LIMESTONE, 13 },
  };

  // -- Dolomite

  public static final int DOLOMITE_COLOR[][] =
      { { 47,101,86},
        {107,160,130},   // Mudstone
        { 0,157,118},

        {  48,98,107},   // Wackestone
        {105,156,160},

        { 42,141,158}, // Packstone
        {   0, 180, 204 },

        { 102, 204, 255 },  // Grainstone
        { 128, 255, 255 },

        { 98,99,157 },  // Boundstone
        { 131,125,162 },
        { 186,132,195 },

        { 164,51,147 } };  // Crystalline

  public static final int DOLOMITE_TEXTURE[][] =
  {
    { lith.lithology.lithologySymbolsStruct._DOLOMITE, 1 },
    { lith.lithology.lithologySymbolsStruct._DOLOMITE, 2 },

    { lith.lithology.lithologySymbolsStruct._DOLOMITE, 3 },
    { lith.lithology.lithologySymbolsStruct._DOLOMITE, 4 },

    { lith.lithology.lithologySymbolsStruct._DOLOMITE, 5 },
    { lith.lithology.lithologySymbolsStruct._DOLOMITE, 6 },
    { lith.lithology.lithologySymbolsStruct._DOLOMITE, 7 },
    { lith.lithology.lithologySymbolsStruct._DOLOMITE, 8 },
    { lith.lithology.lithologySymbolsStruct._DOLOMITE, 9 },

    { lith.lithology.lithologySymbolsStruct._BIOLITHITE, 10 },

    { lith.lithology.lithologySymbolsStruct._BIOLITHITE, 11 },
    { lith.lithology.lithologySymbolsStruct._BIOLITHITE, 12 },

    { lith.lithology.lithologySymbolsStruct._DOLOMITE, 13 },
  };

  // Carbonate Dunham's Panel constants

  public static final int _MUDSTONE    = 0;
  public static final int _WACKESTONE  = 1;
  public static final int _PACKSTONE   = 2;
  public static final int _GRAINSTONE  = 3;
  public static final int _BOUNDSTONE  = 4;
  public static final int _CRYSTALLINE = 5;
  public static final int _FLOATSTONE  = 6;
  public static final int _RUDSTONE_M  = 7;
  public static final int _RUDSTONE_S  = 8;
  public static final int _FRAMESTONE  = 9;
  public static final int _BINDSTONE   = 10;
  public static final int _BAFFLESTONE = 11;
  public static final int _TOTAL_CARBONATE = 12;

  public static final String CaCO3[][] =
  {
  //  Type                Size Class                Abbreviation
    { "Mud Supported",    "Mudstone",                "mdst"   },
    { "Mud Supported",    "Wackestone",              "wkst"   },
    { "Grain Supported",  "Packstone",               "pkst"   },
    { "Grain Supported",  "Grainstone",              "grst"   },
    { "Bound",            "Boundstone",              "bdst"   },
    { "Diagenetic",       "Crystalline",             "xln"    },
    { "Mud Supported",    "Floatstone",              "flst"   },
    { "Grain Supported",  "Rudstone (contains mud)", "rdmst"  },
    { "Grain Supported",  "Rudstone (lacks mud)",    "rdgst"  },
    { "Bound",            "Framestone",              "fmst"   },
    { "Bound",            "Bindstone",               "bnst"   },
    { "Bound",            "Bafflestone",             "bfst"   },
  };

  public static final int CaCO3_CELLS[] =
     // M  W  P  G   B  C
      { 3, 5, 7, 9, 12, 13,  5, 7, 9, 12, 12, 12 };
  public static final int CaCO3_COUNT   = 4;

  public static final String DUNHAM_NAME[][] =
  {
    { "Mudstone",    "Mudstone" },
    { "Mudstone",    "Mudstone" },
    { "Mudstone",    "Mudstone" },
    { "Wackestone",  "Floatstone" },
    { "Wackestone",  "Floatstone" },
    { "Packstone",   "Rudstone" },
    { "Packstone",   "Rudstone" },
    { "Grainstone",  "Rudstone" },
    { "Grainstone",  "Rudstone" },
    { "Boundstone",  "Framestone" },
    { "Boundstone",  "Bindstone" },
    { "Boundstone",  "Bafflestone" },
    { "Crystalline", "Crystalline" },
  };

                                               // Limestone  Dolomite
  public static final String DUNHAM_DOLOMITE[] = { "",        "Dolo" };

  // Carbonate Folk's Allochems Panel constants

  public static final String FOLK_NAME[][] = {
    { "Micrite",    "Micrite",    "Micrite",    "Micrite",  "Micrite" },
    { "Dismicrite", "Dismicrite", "Dismicrite", "Dismicrite", "Dismicrite" },
    { "Intraclast bearing Micrite",   "Oolite bearing Micrite",
      "Fossilliferous Micrite", "Pelletiferous Micrite", "" },
    { "Sparse Intramicrite",    "Sparse Oomicrite",
      "Sparse Biomicrite",      "Sparse Pelmicrite", "" },
    { "Packed Intramicrite",    "Packed Oomicrite",
      "Packed Biomicrite",      "Packed Pelmicrite", "" },
    { "Poorly Washed Intrasparite", "Poorly Washed Oosparite",
      "Poorly Washed Biosparite",   "Poorly Washed Pelsparite", "" },
    { "Unsorted Intrasparite",  "Unsorted Oosparite",
      "Unsorted Biosparite",    "Unsorted Pelsparite", "" },
    { "Sorted Intrasparite",    "Sorted Oosparite",
      "Sorted Biosparite",      "Sorted Pelsparite", "" },
    { "Rounded Intrasparite",   "Rounded Oosparite",
      "Rounded Biosparite",     "Rounded Pelsparite", "" },
    { "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite" },
    { "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite" },
    { "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite" },
    { "Crystalline Intraclastic Dolomite", "Crystalline Oolitic Dolomite",
      "Crystalline Biogenic Dolomite", "Crystalline Pellet Dolomite", ""},
  };

  public static final String FOLK_DOLOMITE[] = {
  // Limestone   >10% Replace  >10% Unknown  Primary Dolomite
     "",        "Dolomitized", "Dolomitic",  "Primary Dolomite" };

  public static final int    FOLK_LEVEL[] = {4,3,2, 1,1, 0,0,0,0, 5,5,5, 6};
  public static final String ALLOCHEMS[][] =
  {
    //  Type I          Type II             Type III
    //  Type IIIa   Type IIIb     Type IV       Type V
    { "Intrasparite", "Intramicrite", "Intraclast bearing micrite",
      "Dismicrite", "Micrite", "Biolithite", "Crystalline Intraclastic Dolomite" },
    { "Oosparite",    "Oomicrite",    "Oolite bearing micrite",
      "Dismicrite", "Micrite", "Biolithite", "Crystalline Oolitic Dolomite" },
    { "Biosparite",   "Biomicrite",   "Fossilliferous micrite",
      "Dismicrite", "Micrite", "Biolithite", "Crystalline Biogenic Dolomite" },
    { "Pelsparite",   "Pelmicrite",   "Pelletiferous micrite",
      "Dismicrite", "Micrite", "Biolithite", "Crystalline Pellet Dolomite" },
    { "",   "",   "", "Dismicrite", "Micrite", "Biolithite", "" }
  };

  public static final int FOLK_LIME_TEXTURE[][] =
  {
    { lith.lithology.lithologySymbolsStruct._INTRA_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._INTRA_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._INTRA_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._INTRA_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._LIMESTONE,
      lith.lithology.lithologySymbolsStruct._BIOLITHITE,
      lith.lithology.lithologySymbolsStruct._INTRA_LIMESTONE },

    { lith.lithology.lithologySymbolsStruct._OO_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._OO_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._OO_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._OO_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._LIMESTONE,
      lith.lithology.lithologySymbolsStruct._BIOLITHITE,
      lith.lithology.lithologySymbolsStruct._OO_LIMESTONE },

    { lith.lithology.lithologySymbolsStruct._BIO_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._BIO_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._BIO_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._BIO_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._LIMESTONE,
      lith.lithology.lithologySymbolsStruct._BIOLITHITE,
      lith.lithology.lithologySymbolsStruct._BIO_LIMESTONE },

    { lith.lithology.lithologySymbolsStruct._PEL_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._PEL_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._PEL_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._PEL_LIMESTONE,
      lith.lithology.lithologySymbolsStruct._LIMESTONE,
      lith.lithology.lithologySymbolsStruct._BIOLITHITE,
      lith.lithology.lithologySymbolsStruct._PEL_LIMESTONE },

    { lith.lithology.lithologySymbolsStruct._LIMESTONE,
      lith.lithology.lithologySymbolsStruct._LIMESTONE,
      lith.lithology.lithologySymbolsStruct._LIMESTONE,
      lith.lithology.lithologySymbolsStruct._LIMESTONE,
      lith.lithology.lithologySymbolsStruct._LIMESTONE,
      lith.lithology.lithologySymbolsStruct._BIOLITHITE,
      lith.lithology.lithologySymbolsStruct._LIMESTONE },
  };

  public static final int FOLK_DOLO_TEXTURE[][] =
  {
    { lith.lithology.lithologySymbolsStruct._INTRA_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._INTRA_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._INTRA_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._INTRA_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._DOLOMITE,
      lith.lithology.lithologySymbolsStruct._BIOLITHITE,
      lith.lithology.lithologySymbolsStruct._INTRA_DOLOMITE },

    { lith.lithology.lithologySymbolsStruct._OO_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._OO_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._OO_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._OO_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._DOLOMITE,
      lith.lithology.lithologySymbolsStruct._BIOLITHITE,
      lith.lithology.lithologySymbolsStruct._OO_DOLOMITE },

    { lith.lithology.lithologySymbolsStruct._BIO_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._BIO_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._BIO_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._BIO_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._DOLOMITE,
      lith.lithology.lithologySymbolsStruct._BIOLITHITE,
      lith.lithology.lithologySymbolsStruct._BIO_DOLOMITE },

    { lith.lithology.lithologySymbolsStruct._PEL_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._PEL_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._PEL_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._PEL_DOLOMITE,
      lith.lithology.lithologySymbolsStruct._DOLOMITE,
      lith.lithology.lithologySymbolsStruct._BIOLITHITE,
      lith.lithology.lithologySymbolsStruct._PEL_DOLOMITE },

    { lith.lithology.lithologySymbolsStruct._DOLOMITE,
      lith.lithology.lithologySymbolsStruct._DOLOMITE,
      lith.lithology.lithologySymbolsStruct._DOLOMITE,
      lith.lithology.lithologySymbolsStruct._DOLOMITE,
      lith.lithology.lithologySymbolsStruct._DOLOMITE,
      lith.lithology.lithologySymbolsStruct._BIOLITHITE,
      lith.lithology.lithologySymbolsStruct._DOLOMITE },
  };
}