/*
 * @rockColumnStruct.java Version 1.1 08/02/2012
 *
 * Copyright (c) 2012 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.rock;

/** Class rockColumnStruct
 *  <p> This Class holds the Rock Column Depth Data.
 *
 *  @version 1.1 08/02/2012
 *  @author  John R. Victorine
 */

public class rockColumnStruct
{
  public static final int _NONE      = -1;
  public static final int _TRACE     = 0; // a visible mark (sparse)
  public static final int _SLIGHTLY  = 1; // a little (some - unspecified amount) (few)
  public static final int _NORMAL    = 2; // evident
  public static final int _MANY      = 3; // large number
  public static final int _VERY      = 4; // Extremely - exceedingly; abundant - great plenty
  public static final int _PRIMARY   = 5; // Primary Lithology

  public static final String AMOUNT[] = { "trace", "slightly", "", "many", "very", "primary" };

  public String sKEY          = "0";  // Unique Identifier

  public double depthStart    = 0.0;  // Starting Depth
  public double depthEnd      = 0.0;  // Ending Depth

  public int    iRGB[]        = { 255, 255, 255 }; // Background Color

  public String sPrimary      = "";   // Primary Lithology Identifier

  public int    iSecondary    = 0;    // Total Number of Secondary Lithology
  public int    iAmount[]     = null; // Amount of Secondary Lithology using above identifiers.
  public String secondary[]   = null; // Array of Secondary Lithology ID's

  // Texture/Grainsize

  public static final int _T_MUD_1  = 1;
  public static final int _T_MUD_2  = 2;
  public static final int _T_MUD_3  = 3;
  public static final int _T_GRN_1  = 4;
  public static final int _T_GRN_2  = 5;
  public static final int _T_GRN_3  = 6;
  public static final int _T_E_CRS  = 7;

  public static final int _CRYPTO   = 0;  // Clay/Shale
  public static final int _MICRO    = 1;  // Silt
  public static final int _V_FINE   = 2;  // Very Fine Grained
  public static final int _FINE     = 3;  // Fine Grained
  public static final int _MEDIUM   = 4;  // Medium Grained
  public static final int _COARSE   = 5;  // Coarse Grained
  public static final int _V_COARSE = 6;  // Very Coarse Grained
  public static final int _E_COARSE = 7;  // Gravel
  public static final int _TOTAL    = 8;

  public static final int MAP[]     = { 2, 3, 4, 4, 5, 6, 6, 7 };
  public static final String MAP_STR[] = {
	"crypto", "micro", "very fine", "fine", "medium", "coarse", "very coarse", "extremely coarse"
  };
  public static final int MAP2[]     = { 0, 0, 1, 3, 4, 5, 7 };

  public int iTexture   = -1;
  public int igrains[]  = { -1, -1, -1, -1, -1, -1, -1, -1 };

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sKEY        = null;
    iRGB        = null;
    iAmount     = null;
    secondary   = null;

    igrains     = null;
  }
}

/*
 *  @version 1.1 08/02/2012
 *  @author  John Victorine
 */
