/*
 * @rockColumnListStruct.java Version 1.1 08/02/2012
 *
 * Copyright (c) 2012 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.rock;

import lith.rock.rockColumnStruct;

/** Class rockColumnListStruct
 *  <p> This Class holds the Rock Lithology Depth Data.
 *
 *  @version 1.1 08/02/2012
 *  @author  John R. Victorine
 */

public class rockColumnListStruct
{
  public double depthStart = 0.0; // Starting Depth
  public double depthEnd   = 0.0; // Ending Depth

  public int              iCount   = 0;    // Total Number of Records
  public rockColumnStruct stItem[] = null; // Total Rock Column Structure

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}

/*
 *  @version 1.1 08/02/2012
 *  @author  John Victorine
 */
