/*
 * @rockColumnPlotLegend.java Version 1.1 08/31/2012
 *
 * Copyright (c) 2012 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.rock.plot;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;

import lith.rock.rockColumnListStruct;
import lith.rock.rockColumnStruct;
import lith.rock.plot.rockColumnPlotSymbol;

import parse.parseRockColumnSymbolsListStruct;

public class rockColumnPlotLegend extends Canvas
{
  public static final int _NO    = cmn.cmnStruct._NO;
  public static final int _YES   = cmn.cmnStruct._YES;

  // Global Variables

  private rockColumnListStruct             stList    = null;
  private rockColumnListStruct             stColumn  = null;

  private parseRockColumnSymbolsListStruct stSymbols = null;
  private rockColumnPlotSymbol             plotLith  = null;

  private String                           sID[][]   = null;
  private int                              id[][]    = null;

  private int iWidth      = 100;  // Width of Plot
  private int iHeight     = 100;  // Height of Plot with the Titles
  private int iLegend     = 0;    // Legend Height

  public static final int PLOT_TITLES = iqstrat.iqstratTracksStruct.PLOT_TITLES;
  public static final int LABELSTART  = iqstrat.iqstratTracksStruct.LABELSTART;

  /** CONSTRUCTOR rockColumnPlotLegend()
   *  <p> This is the constructor for this class.
   *  @param stSymbols  = Texture Symbols List Data Structure
   */

  public rockColumnPlotLegend( parseRockColumnSymbolsListStruct stSymbols )
  {
    this.stSymbols = stSymbols;
    plotLith       = new rockColumnPlotSymbol( stSymbols );

    getLookup();

    this.setBackground(Color.white);
  }

  /** Method close()
   * <p> This method will set object to null to force JAVA to reallocate memory
   */

  public void close()
  {
    stList    = null;
    stSymbols = null;

    if (stColumn != null)
      stColumn.delete();
    stColumn  = null;

    if (plotLith != null)
      plotLith.close();
    plotLith = null;
  }

  /* =============================================================== *
   * ------------------------- GET METHODS ------------------------- *
   * =============================================================== */

  /** Method getLookup()
   *  <P> This method will load the Symbol Info into arrays as lookups
   *      for plotting legend.
   */

  private void getLookup()
  {
	if (stSymbols != null)
	{
	  sID   = new String[stSymbols.iCount][2];
	  id    = new int[stSymbols.iCount][2];

	  for (int i=0; i<stSymbols.iCount; i++)
	  {
		sID[i][0] = new String( stSymbols.stItem[i].sID );
		sID[i][1] = new String( stSymbols.stItem[i].sType );

		id[i][0]  = _NO;
		id[i][1]  = -1;

		if (sID[i][1].equals("1st"))
		  id[i][1] = 1;
		else if (sID[i][1].equals("2nd"))
		  id[i][1] = 2;
		else if (sID[i][1].equals("both"))
		  id[i][1] = 0;
	  }
	}
  }

  /** Method getData()
   *  <p> This method will load an array of identifiers that identify
   *      the lithologies used in the plot and will only plot those
   *      lithologies in the legend.
   */

  private void getData()
  {
	if ((stList != null) && (stSymbols != null))
	{
      for (int i=0; i<stList.iCount; i++)
      {
		for (int j=0; j<stSymbols.iCount; j++)
		{
		  if (stList.stItem[i].sPrimary.equals(sID[j][0]))
		  {
 		    if (id[j][0] == _NO)
		      iHeight  = iHeight+20;

		    id[j][0] = _YES;

		    if (id[j][1] == 0)
		    {
			  id[j][1] = 1;
			}
		  }

		  for (int k=0; k<stList.stItem[i].iSecondary; k++)
		  {
		    if (stList.stItem[i].secondary[k].equals(sID[j][0]))
		    {
			  if (id[j][0] == _NO)
		        iHeight  = iHeight+20;

		      id[j][0] = _YES;

		      if (id[j][1] == 0)
		      {
			    id[j][1] = 2;
			  }
			}
		  }
		}
	  }
	}
  }

  /* =============================================================== *
   * ------------------------- SET METHODS ------------------------- *
   * =============================================================== */

  /** Method setRockColumn( rockColumnListStruct st )
   * <p> This method will set the rock Column that will be shown
   * @param st = Rock column determined by user from rock data.
   */

  public void setRockColumn( rockColumnListStruct st )
  {
	this.stList = st;
	getData();
  }

  /* =============================================================== *
   * ------------------------ DRAW METHODS ------------------------- *
   * =============================================================== */

  /** Method drawColumn( Graphics g, int iStartTrack, int iWidthTrack )
   * <p> This method draw the texture from the Gamma Ray after determining if
   *     it is a carbonate or a siliclastic rock.
   * @param g           = Graphics Parameter.
   * @param iStartTrack = The starting pixel for the LAS Track
   * @param iWidthTrack = The width of LAS Track in pixels
   */

  public int drawColumn( Graphics g, int iStartTrack, int iWidthTrack )
  {
	int     i,j,k;
	int     iDepth   = LABELSTART+12; //PLOT_TITLES;
	int     iPlot    = 0;
    int     iLith    = -1;
    int     iRows    = 2;
    int     iCells   = 0;
    int     iCellY   = 0;
    int     iCellX   = 0;
    int     iCellYd  = 0;
    int     iCellXd  = 0;
    int     iRGB[]   = { 255, 255, 255 };
    int     iRGBd[]  = { 255, 255, 255 };
    int     iTypes[] = { -1, -1, -1 };
    int     iOrder   = -1;
    String  sName    = "";
    int     iStart   = 0;

    Font fsb = new Font("Serif", Font.BOLD, 12);
    FontMetrics fsbm = g.getFontMetrics(fsb);
    g.setFont( fsb );

    g.setColor(Color.black);
    g.drawString("Primary Rock Lithology", iStartTrack+20, iDepth);
    iDepth = iDepth + 20;

    fsb  = new Font("Serif", Font.BOLD, 11);
    fsbm = g.getFontMetrics(fsb);
    g.setFont( fsb );

	if (stSymbols != null)
	{
	  for (k=0; k<stSymbols.iCount; k++)
	  {
		if ((id[k][0] == _YES) && (id[k][1] == 1 ))
		{
          iLith  = parse.parseRockColumnSymbolsUtility.getID( sID[k][0], stSymbols );
          iTypes = parse.parseRockColumnSymbolsUtility.getCapType( sID[k][0], stSymbols );

          if (iLith > -1)
          {
			iDepth = iDepth + 2*iCellY;

            iCells = stSymbols.stItem[iLith].iWeather;
            iCellY = stSymbols.stItem[iLith].iRows;
            iCellX = stSymbols.stItem[iLith].iColumns;
            iRGB   = stSymbols.stItem[iLith].iRGB;
            iPlot  = stSymbols.stItem[iLith].iOrder;
            sName  = new String( stSymbols.stItem[iLith].sName );

            g.setColor(Color.black);
            g.drawString(sName, iStartTrack+100, iDepth+10);

            for (i=0; i<iRows; i++)
            {
              for (j=0; j<iCells; j++)
              {
                plotLith.drawBlock( g, iRGB[0], iRGB[1], iRGB[2],
                                    iStartTrack+j*iCellX, iDepth + i*iCellY,
                                    iCellX, iCellY);
                plotLith.drawSymbolMask(
                       g, iCellY, i,
                       parse.parseRockColumnSymbolsUtility.getSymbol(sID[k][0], stSymbols),
                       iStartTrack+j*iCellX, iDepth + i*iCellY );
			  }
/*
              if (iTypes != null)
              {
                if (iTypes[0] != -1)
                {
                  plotLith.drawSymbolMask(
                         g, iCellY, i, iRGB,
                         parse.parseRockColumnSymbolsUtility.getCaps(sID[k][0], stSymbols),
                         iStartTrack+iCells*iCellX, iDepth + i*iCellY );
				}
			  }
*/
			}
		  }
		}
	  }

  	  iDepth = iDepth + 40;

	  for (k=0; k<stSymbols.iCount; k++)
	  {
		if ((id[k][0] == _YES) && (id[k][1] == 2 ))
		{
		  if (iStart == 0)
		  {
            fsb = new Font("Serif", Font.BOLD, 12);
            fsbm = g.getFontMetrics(fsb);
            g.setFont( fsb );

            g.setColor(Color.black);
            g.drawString("Secondary Rock Lithology", iStartTrack+20, iDepth);

            fsb = new Font("Serif", Font.BOLD, 11);
            fsbm = g.getFontMetrics(fsb);
            g.setFont( fsb );

            iStart = 1;
		  }

          iLith  = parse.parseRockColumnSymbolsUtility.getID( sID[k][0], stSymbols );
          iTypes = parse.parseRockColumnSymbolsUtility.getCapType( sID[k][0], stSymbols );

          if (iLith > -1)
          {
            iCells = 2; //stSymbols.stItem[iLith].iWeather;
            iCellY = stSymbols.stItem[iLith].iRows;
            iCellX = stSymbols.stItem[iLith].iColumns;
            iRGB   = stSymbols.stItem[iLith].iRGB;
            iPlot  = stSymbols.stItem[iLith].iOrder;
            sName  = new String( stSymbols.stItem[iLith].sName );

			iDepth = iDepth + 2*iCellY;

            g.setColor(Color.black);
            g.drawString(sName, iStartTrack+100, iDepth+10);

            for (i=0; i<iRows; i++)
            {
              for (j=0; j<iCells; j++)
              {
//                plotLith.drawBlock( g, iRGB[0], iRGB[1], iRGB[2],
//                                    iStartTrack+j*iCellX, iDepth + i*iCellY,
//                                    iCellX, iCellY);
                if (iPlot < 3)
                {
                  plotLith.drawSymbolMask(
                       g, iCellY, i, iRGB,
                       parse.parseRockColumnSymbolsUtility.getSymbol(sID[k][0], stSymbols),
                       iStartTrack+j*iCellX, iDepth + i*iCellY );
			    }
			    else // if (iPlot == 3)
			    {
                  plotLith.drawBlock( g, 229, 229, 229,
                                    iStartTrack+j*iCellX, iDepth + i*iCellY,
                                    iCellX, iCellY);
                  plotLith.drawSymbolMask(
                       g, iCellY, i,
                       parse.parseRockColumnSymbolsUtility.getSymbol(sID[k][0], stSymbols),
                       iStartTrack+j*iCellX, iDepth + i*iCellY );
			    }
//			    else
//			    {
//                  plotLith.drawBlock( g, iRGB[0], iRGB[1], iRGB[2],
//                                    iStartTrack+j*iCellX, iDepth + i*iCellY,
//                                    iCellX, iCellY);
//                  plotLith.drawSymbolMask(
//                       g, iCellY, i,
//                       parse.parseRockColumnSymbolsUtility.getSymbol(sID[k][0], stSymbols),
//                       iStartTrack+j*iCellX, iDepth + i*iCellY );
//			    }
			  }
			}

            g.setColor(Color.gray);
            g.drawLine(iStartTrack, iDepth,  iStartTrack+40,   iDepth);
		  }
		}
	  }
	}

	return (iDepth);
  }

  /** Method draw( Graphics g, int iSelected, int iStartTrack, int iWidthTrack )
   * <p> This method will create a LAS Plot Track
   * @param g           = Graphics Parameter.
   * @param iSelected   = The Track that was selected
   * @param iStartTrack = The starting pixel for the LAS Track
   * @param iWidthTrack = The width of LAS Track in pixels
   */

  public int draw(Graphics g, int iSelected, int iStartTrack, int iWidthTrack)
  {
	if (iSelected == iqstrat.iqstratTracksStruct._ROCK_MEASURED_SECTION)
	{
      iLegend = drawColumn( g, iStartTrack+5, iWidthTrack );
	}

	return (iLegend);
  }

  /** Method paint( Graphics g )
   * <p> This method will paint Porosity & Permeability Plot
   * @param g = Graphics Parameter.
   */

  public void paint( Graphics g )
  {
    g.setColor(Color.white);
    g.fillRect(0, 0, iWidth, iHeight);
  }
}