/*
 * @lithologySymbolsStruct.java Version 1.1 07/09/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.lithology;

/** Class lithologySymbolsStruct
 *  <p> This Class holds the Lithology Symbol Plot Data.
 *
 *  @version 1.1 07/09/2009
 *  @author  John R. Victorine
 */

public class lithologySymbolsStruct
{
  public static final int OFF = 0;
  public static final int ON  = 1;

  public static final int _NONE          = 0;
  // Siliciclastic Lithotypes
  public static final int _GRAVEL        = 2;
  public static final int _SAND          = 4;
  public static final int _SANDSTONE     = 7;
  public static final int _SILT          = 8;
  public static final int _CLAY          = 10;
  public static final int _SHALE         = 12;
//  public static final int _SHALE_HOT     = 14;
  public static final int _SHALY_SAND    = 15;
  public static final int _ARKOSE        = 18;
  public static final int _FELDSPAR      = 95;
  // Carbonate Lithotypes
  public static final int _LIMESTONE     = 19;
  public static final int _SHALY_CARB    = 21;
  public static final int _DOLOMITE      = 22;
  public static final int _SHALY_DOLO    = 24;
  // Carbonate Textures
  public static final int _BIOLITHITE      = 115;
  // -- Limestone
  public static final int _OO_LIMESTONE    = 105;
  public static final int _BIO_LIMESTONE   = 114;
  public static final int _PEL_LIMESTONE   = 122;
  public static final int _INTRA_LIMESTONE = 123;
  // -- Dolomite
  public static final int _OO_DOLOMITE     = 106;
  public static final int _BIO_DOLOMITE    = 121;
  public static final int _PEL_DOLOMITE    = 124;
  public static final int _INTRA_DOLOMITE  = 125;
  // Evaporites
  public static final int _GYPSUM        = 31;
  public static final int _ANHYDRITE     = 32;
  public static final int _SALT_GENERAL  = 33;
  public static final int _HALITE        = 34;
  // Organic-Rich Rocks
  public static final int _COAL          = 44;
  // Misc Sediments
  public static final int _IRONSTONE     = 55;
  // Igneous
  public static final int _IGNEOUS       = 58;  // Igneous (Granites ...)
  public static final int _GRANITE       = 60;  // Felsic Igneous Rocks
  public static final int _GABBRO        = 66;  // Mafic Igneous Rocks
  public static final int _VOLCANIC      = 71;  // Volcanic (Basalt ...)
  public static final int _PLAGIOCLASE   = 171; // Plagioclase
  public static final int _ULTRAMAFIC    = 172; // Olivine

  public static final int _MUSCOVITE     = 231; // Muscovite Mica

  public static final int _SCHIST        = 90;  // Schist

  public int    iHierarchy = -1;  // Hierarchy within the list
                                  //  iHierarchy = 100 * iGroup + iOrder
  public int    id         =  0;  // ID for Lithology Symbol
  public int    iShow      = OFF; // Default Legend parameter
  public int    iExtend    = OFF; // Extended Legend parameter
  public int    iOrder     = -1;  // Order within the group
  public int    iGroup     = -1;  // Group Number
  public String sGroup     = "";  // The group the lithology belongs
  public String sName      = "";  // Name or Description of lithology
  public String sAbrev     = "";  // Abbreviation of lithology
  public String sMnemonic  = "";  // Mnemonic of lithology

  // Background color

  public int    iRGB[]     = { 255, 255, 255 };

  // Plot Symbol for lithology default is an empty or None symbol

  public int    iRows      =  5;
  public int    iColumns   = 10;
  public String symbol[][] = {
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." },
    {  "..........", ".........." }
  };

  // Thesaurus for searching and parsing geologist field notes or comments

  public int    iThesaurus   = 0;
  public String sThesaurus[] = null;

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    id         =  0;    // ID for Lithology Symbol
    iShow      = OFF;   // Default Legend parameter
    iExtend    = OFF;   // Extended Legend parameter
    iOrder     = -1;    // Order within the group
    iGroup     = -1;    // Group Number
    sGroup     = null;  // The group the lithology belongs
    sName      = null;  // Name or Description of lithology
    sAbrev     = null;  // Abbreviation of lithology
    sMnemonic  = null;  // Mnemonic of lithology

    // Background color

    iRGB       = null;

    // Plot Symbol for lithology default is an empty or None symbol

    iRows      =  5;
    iColumns   = 10;
    symbol     = null;

    // Thesaurus for searching and parsing geologist field notes or comments

    iThesaurus = 0;
    sThesaurus = null;
  }
}