/*
 * @lithologySymbolsListStruct.java Version 1.1 07/09/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.lithology;

import lith.lithology.lithologyColorsStruct;
import lith.lithology.lithologyGroupsStruct;
import lith.lithology.lithologySymbolsStruct;

/** Class lithologySymbolsListStruct
 *  <p> This Class holds the Lithology Symbol Plot Data.
 *
 *  @version 1.1 07/09/2009
 *  @author  John R. Victorine
 */

public class lithologySymbolsListStruct
{
  // Lithology Colors

  public lithologyColorsStruct  stForeground = null; // foreground colors
  public lithologyColorsStruct  stBackground = null; // background colors

  // Lithology Groups

  public lithologyGroupsStruct  stGroups     = null; // Lithology Groups

  // Lithology Symbols

  public int                    iCount   = 0;    // Total Number of Records
  public lithologySymbolsStruct stItem[] = null; // Lithology Symbols Structure

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    if (stForeground != null)
      stForeground.delete();
    stForeground = null; // foreground colors

    if (stBackground != null)
      stBackground.delete();
    stBackground = null; // background colors

    if (stGroups != null)
      stGroups.delete();
    stGroups = null;     // Lithology Groups

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}
