/*
 * @lithologyStruct.java Version 1.1 09/12/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.lithology;

/** Class lithologyStruct
 *  <p> This Class holds the Rock Color Depth Data.
 *
 *  @version 1.1 09/12/2007
 *  @author  John R. Victorine
 */

public class lithologyStruct
{
  public String sKEY        = "0";

  public double depthStart  = 0.0; // Starting Depth
  public double depthEnd    = 0.0; // Ending Depth

  public double dRhomaa     = 0.0;
  public double dUmaa       = 0.0;
  public double dGR         = 0.0;

  public static final int TOTAL = 10;
  public String sAbbreviation   = "";
  public int iStreaks           = 0;
  public int iLithology[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sKEY          = null;
    sAbbreviation = null;
    iLithology    = null;
  }
}