/*
 * @lithologyListStruct.java Version 1.1 09/12/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.lithology;

import lith.lithology.lithologyStruct;
import lith.lithology.lithologyColumnsStruct;

/** Class lithologyListStruct
 *  <p> This Class holds the Rock Lithology Depth Data.
 *
 *  @version 1.1 09/12/2007
 *  @author  John R. Victorine
 */

public class lithologyListStruct
{
  // Stratigraphic Headers Data Information

  public String sKID       = "0";  // Primary Key of the Well
  public String sKEY       = "";   // Primary Key created on user's PC
  public int    iType      = iqstrat.iqstratHeadersStruct.WELL; // Type of Data
  public String sAPI       = "";   // API-Number OR UWI
  public String sName      = "";   // Well Name or Outcrop Name
  public String status     = iqstrat.iqstratStatusStruct.STATUS[0][0]; // Status
  public double dLatitude  = 0.0;  // Latitude of Location
  public double dLongitude = 0.0;  // Longitude of Location
  public double depth      = 0.0;  // Total Depth of Well or Height of Outcrop
  public double dGL        = 0.0;  // Ground Level

//  public static final int UNITS_FT = 0;
//  public static final int UNITS_IN = 1;

//  public int    iUnit      = UNITS_FT;
  public int    iUnit      = iqstrat.iqstratTracksStruct._SCALE_HALF_FOOT;
  public double depthStart = 0.0; // Starting Depth
  public double depthEnd   = 0.0; // Ending Depth

  // LAS 3 Dependent Variable

  public String sKGS     = "YES"; // KGS Saved Data Indicator
  public String source   = "";    // Source of Data
  public String sCreated = "";    // Created Date

  public int             iCount   = 0;    // Total Number of Records
  public lithologyStruct stItem[] = null; // Total Rock Lithology Sections

  public int                    iColumns  = 0;      // Total Number of Columns
  public lithologyColumnsStruct stColumns[] = null; // Array of Columns Structures

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    int i = 0;

    sKID     = null; // Primary Key of the Well
    sKEY     = null; // Primary Key created on user's PC
    sAPI     = null; // API-Number OR UWI
    sName    = null; // Well Name or Outcrop Name
    status   = null; // Status

    sKGS     = null; // KGS Saved Data Indicator
    source   = null; // Source of Data
    sCreated = null; // Created Date

    for (i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;

    for (i=0; i<iColumns; i++)
    {
      if (stColumns[i] != null)
        stColumns[i].delete();
      stColumns[i] = null;
    }

    iColumns = 0;
  }
}
