/*
 * @lithologyColorsStruct.java Version 1.1 07/09/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.lithology;

/** Class lithologyColorsStruct
 *  <p> This Class holds the Lithology Plot Colors Data.
 *
 *  @version 1.1 07/09/2009
 *  @author  John R. Victorine
 */

public class lithologyColorsStruct
{
  public int    iColors   = 0;    // total number of records
  public char   colors[]  = null; // Character Symbol
  public String sColors[] = null; // Color description
  public int    iRGB[][]  = null; // rgb values

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    iColors = 0;    // total number of records
    colors  = null; // Character Symbols
    sColors = null; // Color description
    iRGB    = null; // rgb values
  }
}