/*
 * @lithConstants.java Version 1.1 04/19/2011
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith;

/** Class lithConstants
 *  <p> This Class holds the Lithology/Texture Constants
 *
 *  @version 1.1 04/19/2011
 *  @author  John R. Victorine
 */

public class lithConstants
{
  public static final int _OFF = 0;
  public static final int _ON  = 1;
  public static final int _SET = 2;

  // Sedimentary Rock Constants

  // -- Primary Lithology

  public static final int _NONE         = 0;
  public static final int _SOIL         = 1;
  public static final int _LOESS        = 2;
  public static final int _LOAM         = 3;
  public static final int _CLAY_LOAM    = 4;
  public static final int _SILT_LOAM    = 5;
  public static final int _CLAY         = 6;
  public static final int _CLAYSTONE    = 7;
  public static final int _BENTONITE    = 8;
  public static final int _GLAUCONITE   = 9;
  public static final int _SHALE        = 10;
  public static final int _CLAY_SHALE   = 11;
  public static final int _SILT_SHALE   = 12;
  public static final int _SILT         = 13;
  public static final int _SILTSTONE    = 14;
  public static final int _SAND         = 15;
  public static final int _SANDSTONE    = 16;
  public static final int _BRECCIA      = 17;
  public static final int _GRAVEL       = 18;
  public static final int _CONGLOMERATE = 19;

  public static final int _LIMESTONE    = 20;
  public static final int _MARL         = 21;
  public static final int _MARLSTONE    = 22;
  public static final int _DOLOMITE     = 23;
  public static final int _CHALK        = 24;

  public static final int _COAL         = 25;
  public static final int _SAPROPELIC   = 26;
  public static final int _BOGHEAD      = 27;
  public static final int _CANNEL       = 28;
  public static final int _HUMIC        = 29;
  public static final int _PEAT         = 30;
  public static final int _LIGNITE      = 31;
  public static final int _SUB_BITUMINOUS = 32;
  public static final int _BITUMINOUS   = 33;
  public static final int _ANTHRACITE   = 34;

  public static final int _CHERT        = 35;
  public static final int _FLINT        = 36;

  public static final int _ANHYDRITE    = 37;
  public static final int _GYPSUM       = 38;
  public static final int _PHOSPHATE    = 39;
  public static final int _SALT         = 40;
  public static final int _HALITE       = 41;
  public static final int _SYLVITE      = 42;

  public static final int _PYRITE       = 43;
  public static final int _LIMONITE     = 44;
  public static final int _HEMATITE     = 45;
  public static final int _SIDERITE     = 46;

  public static final int _ARKOSE       = 47;

  public static final int _CALCIRUDITE  = 48;
  public static final int _CALCARENITE  = 49;
  public static final int _CALCILUTITE  = 50;
  public static final int _DOLORUDITE   = 51;
  public static final int _DOLARENITE   = 52;
  public static final int _DOLOLUTITE   = 53;

  public static final int _AGGLOMERATE  = 54;
  public static final int _VOL_BRECCIA  = 55;
  public static final int _TUFF         = 56;

  public static final int _GRANITE      = 57;
  public static final int _SYENITE      = 58;
  public static final int _MONZONITE    = 59;
  public static final int _GRANODIORITE = 60;
  public static final int _DIORITE      = 61;
  public static final int _GABBRO       = 62;
  public static final int _PERIDOTITE   = 63;

  public static final int _RHYOLITE     = 64;
  public static final int _TRACHYTE     = 65;
  public static final int _LATITE       = 66;
  public static final int _DACITE       = 67;
  public static final int _ANDESITE     = 68;
  public static final int _BASALT       = 69;
  public static final int _LAMPROPHYRE  = 70;

  public static final int _OBSIDIAN     = 71;
  public static final int _PUMICE       = 72;
  public static final int _SCORIA       = 73;

  public static final int _SLATE        = 74;
  public static final int _PHYLLITE     = 75;
  public static final int _SCHIST       = 76;
  public static final int _GNEISS       = 77;
  public static final int _MIGMATITE    = 78;
  public static final int _AMPHIBOLITE  = 79;
  public static final int _GRANULITE    = 80;
  public static final int _QUARTZITE    = 81;
  public static final int _MARBLE       = 82;
  public static final int _MARBLE_DOL   = 83;
  public static final int _HORNFELS     = 84;

  public static final int _PRIMARY      = 85;

  public static final int _GROUPS       = 6;

  public static final String PRIMARY[][] = {
	{ "none",         "" },
    { "soil",         "Soil" },
    { "loess",        "Soil" },
    { "loam",         "Soil" },
    { "clay loam",    "Soil" },
    { "silt loam",    "Soil" },

    { "clay",         "Siliciclastic" },
    { "claystone",    "Siliciclastic" },
    { "bentonite",    "Siliciclastic" },
    { "glauconite",   "Siliciclastic" },

    { "shale",        "Siliciclastic" },
    { "clay shale",   "Siliciclastic" },
    { "silt shale",   "Siliciclastic" },

    { "silt",         "Siliciclastic" },
    { "siltstone",    "Siliciclastic" },
    { "sand",         "Siliciclastic" },
    { "sandstone",    "Siliciclastic" },

    { "breccia",      "Siliciclastic" },
    { "gravel",       "Siliciclastic" },
    { "conglomerate", "Siliciclastic" },

    { "limestone",    "Carbonate" },
    { "marl",         "Carbonate" },
    { "marlstone",    "Carbonate" },
    { "dolomite",     "Carbonate" },
    { "chalk",        "Organics" },

    { "coal",           "Organics" },
    { "sapropelic coal", "Organics" },
    { "boghead",        "Organics" },
    { "cannel",         "Organics" },
    { "humic coal",     "Organics" },
    { "peat",           "Organics" },
    { "lignite",        "Organics" },
    { "sub bituminous coal", "Organics" },
    { "bituminous coal",     "Organics" },
    { "anthracite",     "Organics" },

    { "chert",        "Organics" },
    { "flint",        "Organics" },

    { "anhydrite",    "Evaporite" },
    { "gypsum",       "Evaporite" },
    { "phosphate",    "Evaporite" },
    { "salt",         "Evaporite" },
    { "halite",       "Evaporite" },
    { "sylvite",      "Evaporite" },

    { "pyrite",       "Ironstone" },
    { "limonite",     "Ironstone" },
    { "hematite",     "Ironstone" },
    { "siderite",     "Ironstone" },

    { "arkose",       "" },

    { "calcirudite",  "" },
    { "calcarenite",  "" },
    { "calcilutite",  "" },
    { "dolorudite",   "" },
    { "dolarenite",   "" },
    { "dololutite",   "" },

    // Igneous & Volcanic Rocks

    { "agglomerate",      "" },
    { "volcanic breccia", "" },
    { "tuff",             "" },

    { "granite",          "Felsic - Phaneritic" },
    { "syenite",          "Felsic - Phaneritic" },
    { "monzonite",        "Felsic - Phaneritic" },
    { "granodiorite",     "Intermediate - Phaneritic" },
    { "diorite",          "Intermediate - Phaneritic" },
    { "gabbro",           "Mafic - Phaneritic" },
    { "peridotite",       "Ultramafic - Phaneritic" },
    { "rhyolite",         "Felsic - Aphanitic" },
    { "trachyte",         "Felsic - Aphanitic" },
    { "latite",           "Felsic - Aphanitic" },
    { "dacite",           "Intermediate - Aphanitic" },
    { "andesite",         "Intermediate - Aphanitic" },
    { "basalt",           "Mafic - Aphanitic" },
    { "lamprophyre",      "Mafic - Aphanitic" },

    { "obsidian",         "glassy"},
    { "pumice",           "frothy - vesicular"},
    { "scoria",           "frothy - vesicular"},

    // Metamorphic Rocks

    { "slate",            "foliated"},
    { "phyllite",         "foliated"},
    { "schist",           "foliated"},
    { "gneiss",           "foliated"},
    { "migmatite",        "foliated"},
    { "amphibolite",      "foliated"},
    { "granulite",        "non-foliated"},
    { "quartzite",        "non-foliated"},
    { "marble",           "non-foliated"},
    { "dolomitic marble", "non-foliated"},
    { "hornfels",         "non-foliated"},
  };

  public static final int PRIMARY_SIZE[][] = {
  //    1     2     3     4     5     6     7     8     9    10    11    12    13    14
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _NONE
    { _OFF, _OFF, _OFF, _OFF, _ON,  _SET, _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF }, // _SOIL
    { _OFF, _OFF, _OFF, _OFF, _SET, _ON,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _LOESS
    { _OFF, _OFF, _OFF, _OFF, _ON,  _SET, _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF }, // _LOAM
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _CLAY_LOAM
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _SILT_LOAM
    { _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _CLAY
    { _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _CLAYSTONE
    { _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _BENTONITE
    { _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _GLAUCONITE
    { _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _SHALE
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _CLAY_SHALE
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _SILT_SHALE
    { _OFF, _OFF, _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _SILT
    { _OFF, _OFF, _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _SILTSTONE
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _SET, _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF }, // _SAND
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _SET, _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF }, // _SANDSTONE
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _SET, _ON,  _ON,  _ON,  _ON  }, // _BRECCIA
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _SET, _ON,  _ON,  _ON,  _ON  }, // _GRAVEL
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _SET, _ON,  _ON,  _ON,  _ON  }, // _CONGLOMERATE

    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _LIMESTONE
    { _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _MARL
    { _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _MARLSTONE
    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _DOLOMITE

    { _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _CHALK

    { _OFF, _OFF, _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _COAL
    { _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _SAPROPELIC
    { _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _BOGHEAD
    { _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _CHANNEL
    { _OFF, _OFF, _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _HUMIC
    { _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _PEAT
    { _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _LIGNITE
    { _OFF, _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _SUB_BITUMINOUS
    { _OFF, _OFF, _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _BITUMINOUS
    { _OFF, _OFF, _OFF, _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _ANTHRACITE

    { _OFF, _OFF, _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _CHERT
    { _OFF, _OFF, _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _FLINT

  //    1     2     3     4     5     6     7     8     9    10    11    12    13    14
    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _ANHYDRITE
    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _GYPSUM
    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _PHOSPHATE
    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _SALT
    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _HALITE
    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _SYLVITE

    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _PYRITE
    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _LIMONITE
    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _HEMATITE
    { _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF, _OFF }, // _SIDERITE

    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _SET, _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF }, // _ARKOSE

  //    1     2     3     4     5     6     7     8     9    10    11    12    13    14
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _ON,  _SET, _ON,  _ON,  _OFF, _OFF }, // CALCIRUDITE
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _SET, _ON,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // CALCARENITE
    { _ON,  _ON,  _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // CALCILUTITE
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _ON,  _SET, _ON,  _ON,  _OFF, _OFF }, // DOLORUDITE
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _SET, _ON,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // DOLARENITE
    { _ON,  _ON,  _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // DOLOLUTITE

    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _SET, _ON,  _ON,  _ON,  _ON  }, // _AGGLOMERATE
    { _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _SET, _ON,  _ON,  _ON,  _ON  }, // _VOL_BRECCIA
    { _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF }, // _TUFF

  //    1     2     3     4     5     6     7     8     9    10    11    12    13    14
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _ON,  _SET,  _ON, _ON,  _ON,  _ON,  _ON  }, // _GRANITE
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _ON,  _SET,  _ON, _ON,  _ON,  _ON,  _ON  }, // _SYENITE
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _ON,  _SET,  _ON, _ON,  _ON,  _ON,  _ON  }, // _MONZONITE
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _ON,  _SET,  _ON, _ON,  _ON,  _ON,  _ON  }, // _GRANODIORITE
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _ON,  _SET,  _ON, _ON,  _ON,  _ON,  _ON  }, // _DIORITE
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _ON,  _SET,  _ON, _ON,  _ON,  _ON,  _ON  }, // _GABBRO
    { _OFF, _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _ON,  _SET,  _ON, _ON,  _ON,  _ON,  _ON  }, // _PERIDOTITE

    { _OFF, _OFF, _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _RHYOLITE
    { _OFF, _OFF, _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _TRACJUTE
    { _OFF, _OFF, _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _LATITE
    { _OFF, _OFF, _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _DACITE
    { _OFF, _OFF, _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _ANDESITE
    { _OFF, _OFF, _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _BASALT
    { _OFF, _OFF, _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _LAMPROPHYRE

    { _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _OBSIDIAN
    { _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _PUMICE
    { _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, // _SCORIA

  //    1     2     3     4     5     6     7     8     9    10    11    12    13    14
    { _ON,  _ON,  _SET, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, //  _SLATE
    { _OFF, _OFF, _OFF, _ON,  _SET, _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF }, //  _PHYLLITE
    { _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF }, //  _SCHIST
    { _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF }, //  _GNEISS
    { _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF }, //  _MIGMATITE
    { _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _OFF, _OFF, _OFF, _OFF, _OFF }, //  _AMPHIBOLITE
    { _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF }, //  _GRANULITE
    { _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF }, //  _QUARTZITE
    { _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF }, //  _MARBLE
    { _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF }, //  _MARBLE_DOL
    { _OFF, _OFF, _OFF, _ON,  _ON,  _ON,  _SET, _ON,  _ON,  _ON,  _ON,  _OFF, _OFF, _OFF }, //  _HORNFELS
  };

  // -- Secondary Lithologies

  public static final int _TUFFACEOUS   = 0;
  public static final int _ARGILLACEOUS = 1;
  public static final int _CLAYEY       = 2;
  public static final int _GLAUCONITIC  = 3;
  public static final int _BENTONITIC   = 4;
  public static final int _SHALY        = 5;
  public static final int _MICACEOUS    = 6;
  public static final int _SILTY        = 7;
  public static final int _SANDY        = 8;
  public static final int _BRECCIATED   = 9;
  public static final int _CALCAREOUS   = 10;
  public static final int _DOLOMITIC    = 11;
  public static final int _PEATY        = 12;
  public static final int _BIUMINOUS    = 13;
  public static final int _CARBONACEOUS = 14;
  public static final int _CARBONIZED   = 15;
  public static final int _CHALKY       = 16;
  public static final int _CHERTY       = 17;
  public static final int _FLINTY       = 18;
  public static final int _ANHYDRITIC   = 19;
  public static final int _GYPSIFEROUS  = 20;
  public static final int _PHOSPHATIC   = 21;
  public static final int _PYRITIC      = 22;
  public static final int _LIMONITIC    = 23;
  public static final int _SECONDARY    = 24;

  public static final String SECONDARY[] = {
    "tuffaceous",

    "argillaceous",
    "clayey",
    "glauconitic",
    "bentonitic",

    "shaly",
    "micaceous",

    "silty",
    "sandy",
    "brecciated",

    "calcareous",
    "dolomitic",

    "peaty",
    "bituminous",
    "carbonaceous",
    "carbonized",

    "chalky",
    "cherty",
    "flinty",

    "anhydritic",
    "gypsiferous",
    "phosphatic",

    "pyritic",
    "limonitic",
  };

  // Lithology Combination Radio button actions

  public static final int ACTION[][] = {
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // soil

  // tuff,  arg,   cl, glau, bent, shly, mica, slty, sndy, brec, calc, dolo,  pty,  bit, carb, carbn, chlky, chrty, flnty, anhy,  gyp, phos,  pyr,  lim
    {_OFF,  _ON,  _ON, _OFF, _OFF, _OFF,  _ON,  _ON,  _ON, _OFF, _OFF, _OFF,  _ON,  _ON,  _ON,   _ON,   _ON,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // soil
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // loess
    {_OFF,  _ON,  _ON, _OFF, _OFF, _OFF,  _ON,  _ON,  _ON, _OFF, _OFF, _OFF,  _ON,  _ON,  _ON,   _ON,   _ON,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // loam
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _ON,  _ON, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // clay loam
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // silt loam

    { _ON, _OFF, _OFF,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON, _OFF,  _ON,  _ON, _OFF,  _ON,  _ON,   _ON,   _ON,   _ON,   _ON,  _ON,  _ON,  _ON,  _ON,  _ON  }, // clay
    { _ON, _OFF, _OFF,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON, _OFF,  _ON,  _ON, _OFF,  _ON,  _ON,   _ON,   _ON,   _ON,   _ON,  _ON,  _ON,  _ON,  _ON,  _ON  }, // claystone
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // bentonite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // glauconite

    { _ON,  _ON,  _ON,  _ON,  _ON, _OFF,  _ON,  _ON,  _ON, _OFF,  _ON,  _ON, _OFF,  _ON,  _ON,   _ON,   _ON,   _ON,   _ON,  _ON,  _ON,  _ON,  _ON,  _ON  }, // shale
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // clay shale
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // silt shale

  // tuff,  arg,   cl, glau, bent, shly, mica, slty, sndy, brec, calc, dolo,  pty,  bit, carb, carbn, chlky, chrty, flnty, anhy,  gyp, phos,  pyr,  lim
    { _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON, _OFF,  _ON, _OFF,  _ON,  _ON, _OFF,  _ON,  _ON,   _ON,   _ON,   _ON,   _ON,  _ON,  _ON,  _ON,  _ON,  _ON  }, // silt
    { _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON, _OFF,  _ON, _OFF,  _ON,  _ON, _OFF,  _ON,  _ON,   _ON,   _ON,   _ON,   _ON,  _ON,  _ON,  _ON,  _ON,  _ON  }, // siltstone
    { _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON, _OFF, _OFF,  _ON,  _ON, _OFF,  _ON,  _ON,   _ON,   _ON,   _ON,   _ON,  _ON,  _ON,  _ON,  _ON,  _ON  }, // sand
    { _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON, _OFF, _OFF,  _ON,  _ON, _OFF,  _ON,  _ON,   _ON,   _ON,   _ON,   _ON,  _ON,  _ON,  _ON,  _ON,  _ON  }, // sandstone

    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // breccia
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // gravel
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // conglomerate

    { _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON, _OFF,  _ON, _OFF,  _ON,  _ON,   _ON,   _ON,   _ON,   _ON,  _ON,  _ON,  _ON,  _ON,  _ON  }, // limestone
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // marl
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // marlstone
    { _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON,  _ON, _OFF, _OFF,  _ON,  _ON,   _ON,   _ON,   _ON,   _ON,  _ON,  _ON,  _ON,  _ON,  _ON  }, // dolomite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // chalk

    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _ON, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // coal
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // sapropelic coal
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // boghead
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // cannel
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // humic
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // peat
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // lignite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // sub bituminous
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // bituminous
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // anthracite

    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // chert
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // flint

    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // anhydrite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // gypsum
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // phosphate
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // salt
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // halite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // sylvite

    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // pyrite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // limonite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // hematite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // siderite

    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // arkose
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // calcirudite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // calcarenite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // calcilutite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // dolorudite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // dolarenite
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // dololutite

    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // agglomerate
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // volcanic breccia
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // tuff

    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // granite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // syenite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // monzonite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // granodiorite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // diorite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // gabbro",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // peridotite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // rhyolite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // trachyte",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // latite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // dacite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // andesite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // basalt",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // lamprophyre",

    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // obsidian",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // pumice",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  }, // scoria",

    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //slate",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //phyllite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //schist",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //gneiss",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //migmatite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //amphibolite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //granulite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //quartzite",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //marble",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //dolomitic marble",
    {_OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF, _OFF,  _OFF,  _OFF,  _OFF,  _OFF, _OFF, _OFF, _OFF, _OFF, _OFF  },  //hornfels",
  };

  public static final String DEFAULT[] = {
    "     < 512    mm",  // 1
    "1/512 - 1/256 mm",  // 2
    "1/256 - 1/128 mm",  // 3
    "1/128 - 1/16  mm",  // 4
    "1/16  - 1/8   mm",  // 5
    "1/8   - 1/4   mm",  // 6
    "1/4   - 1/2   mm",  // 7
    "1/2   -   1   mm",  // 8
    "  1   -   2   mm",  // 9
    "  2   -   4   mm",  // 10
    "  4   -  32   mm",  // 11
    " 32   -  64   mm",  // 12
    " 64   - 128   mm",  // 13
    "    > 128     mm",  // 14
  };

  public static final int DEFAULT_COLOR[][] =
  { { 255, 255, 255 },
    { 255, 255, 255 },

    { 255, 255, 255 },
    { 255, 255, 255 },

    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },

    { 255, 255, 255 },

    { 255, 255, 255 },
    { 255, 255, 255 },

    { 255, 255, 255 },
    { 255, 255, 255 } };

  public static final String SIO2[] = {
    "",
    "Clay",
    "",
    "Silt",
    "Very Fine",
    "Fine",
    "Medium",
    "Coarse",
    "Very Coarse",
    "Granules",
    "",
    "Pebbles",
    "",
    "Cobbles"
  };

  public static final int SIO2_COLOR[][] =
  { {  64,  64,  64 },  //  - Not Used
    { 127, 127, 127 },  //  - grey 50

    { 150, 150, 150 },  //  - Not Used
    { 192, 192, 192 },  //  - silt

    { 204, 204, 153 },  //  - vfs
    { 255, 204,  51 },  //  - fs
    { 255, 230,   0 },  //  - ms
    { 255, 255,  52 },  //  - cs
    { 240, 255,  52 },  //  - vcs

    { 204, 255,  52 },  //  - gran

    { 153, 204, 150 },  //  - Not Used
    { 153, 204,  51 },  //  - peb

    { 102, 204, 150 },  //  - Not Used
    { 102, 204,   0 } };  //  - cob

  public static final String CO3[] = {
    "Very Fine",
    "Fine",
    "Medium",
    "Coarse",
    "Very Fine",
    "Fine",
    "Medium",
    "Coarse",
    "Fine",
    "Medium",
    "Coarse",
    "Very Coarse",
    "",
    ""
  };

  public static final int CO3_COLOR[][] =
  { {  47, 101,  86 }, //  - 1
    { 107, 160, 130 }, //  - 2
    {   0, 157, 118 }, //  - 3
    {  48,  98, 107 }, //  - 4

    { 105, 156, 160 }, //  - 5
    {  42, 141, 158 }, //  - 6
    {   0, 180, 204 }, //  - 7
    { 135, 206, 235 }, //  - sky blue


    {   0, 191, 255 }, //  - deep sky blue 1
    { 102, 204, 255 }, //  - 8
    {   0, 255, 255 }, //  - cyan
    { 128, 255, 255 }, //  - 9

    { 255, 255, 255 },
    { 255, 255, 255 } };

  public static final int LIMESTONE_COLOR[][] =
  { {  47, 101,  86 }, //                 - 1
    { 107, 160, 130 }, // Mudstone        - 2
    {   0, 157, 118 }, //                 - 3 or mdst

    {  48,  98, 107 }, // Wackestone      - 4
    { 105, 156, 160 }, //                 - 5 or wkst

    {  42, 141, 158 }, // Packstone       - 6
    {   0, 180, 204 }, //                 - 7 or pkst

    { 102, 204, 255 }, // Grainstone      - 8
    { 128, 255, 255 }, //                 - 9 or grst

    {  98,  99, 157 }, // Boundstone      - 10
    { 131, 125, 162 }, //                 - 11
    { 186, 132, 195 }, //                 - 12 or bdst

    { 164,  51, 147 },  //                - 13
    { 164,  51, 147 }}; // Crystalline    - 13

  // Carbonate Folk's Allochems Panel constants

  public static final String FOLK_NAME[][] = {
    { "Micrite",    "Micrite",    "Micrite",    "Micrite",  "Micrite" },
    { "Dismicrite", "Dismicrite", "Dismicrite", "Dismicrite", "Dismicrite" },
    { "Intraclast bearing Micrite",   "Oolite bearing Micrite",
      "Fossilliferous Micrite", "Pelletiferous Micrite", "" },
    { "Sparse Intramicrite",    "Sparse Oomicrite",
      "Sparse Biomicrite",      "Sparse Pelmicrite", "" },
    { "Packed Intramicrite",    "Packed Oomicrite",
      "Packed Biomicrite",      "Packed Pelmicrite", "" },
    { "Poorly Washed Intrasparite", "Poorly Washed Oosparite",
      "Poorly Washed Biosparite",   "Poorly Washed Pelsparite", "" },
    { "Unsorted Intrasparite",  "Unsorted Oosparite",
      "Unsorted Biosparite",    "Unsorted Pelsparite", "" },
    { "Sorted Intrasparite",    "Sorted Oosparite",
      "Sorted Biosparite",      "Sorted Pelsparite", "" },
    { "Rounded Intrasparite",   "Rounded Oosparite",
      "Rounded Biosparite",     "Rounded Pelsparite", "" },
    { "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite" },
    { "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite" },
    { "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite",  "Biolithite" },
    { "Crystalline Intraclastic Dolomite", "Crystalline Oolitic Dolomite",
      "Crystalline Biogenic Dolomite", "Crystalline Pellet Dolomite", ""},
  };

  public static final String XLN[] = {
    "Crypto Crystalline",
    "Micro Crystalline",
    "Very Fine Crystalline",
    "Fine Crystalline",
    "",
    "Medium Crystalline",
    "",
    "Coarse Crystalline",
    "",
    "Very Coarse Crystalline",
    "",
    "",
    "",
    ""
  };

  public static final int XLN_COLOR[][] =
  { { 140,   0, 211 }, // crypto        - dark violet

    {  98,  99, 157 }, // micro         - 10

    { 131, 125, 162 }, // very fine     - 11

    { 131, 125, 162 }, // fine          - 11

    { 186, 132, 195 }, //               - 12
    { 186, 132, 195 }, // medium        - 12

    { 164,  51, 147 }, //               - 13
    { 164,  51, 147 }, // coarse        - 13

    { 164,  51, 147 }, //               - 13
    { 164,  51, 147 }, // very coarse   - 13

    { 255, 255, 255 },
    { 255, 255, 255 }, // Extremely Coarse Crystalline
    { 255, 255, 255 },
    { 255, 255, 255 }};

  public static final String XLN2[] = {
    "Crypto Crystals",
    "Micro Crystals",
    "Very Fine Crystals",
    "Fine Crystals",
    "",
    "Medium Crystals",
    "",
    "Coarse Crystals",
    "",
    "Very Coarse Crystals",
    "",
    "",
    "",
    ""
  };

  public static final int XLN_COLOR2[][] =
  { {   0,   0,   0 }, // crypto       - black

    { 127, 127, 127 }, // micro        - grey 50

    { 190, 190, 190 }, // very fine    - grey

    { 190, 190, 190 }, // fine         - grey

    { 229, 229, 229 }, //              - grey 90
    { 229, 229, 229 }, // medium       - grey 90

    { 248, 248, 255 }, //              - ghost white
    { 248, 248, 255 }, // coarse       - ghost white

    { 248, 248, 255 }, //              - ghost white
    { 248, 248, 255 }, // very coarse  - ghost white

    { 255, 255, 255 },
    { 255, 255, 255 }, // Extremely Coarse Crystalline
    { 255, 255, 255 },
    { 255, 255, 255 }};

  public static final String PYRO[] = {
    "",
    "",
    "Very Fine",
    "",
    "Fine",
    "",
    "Medium",
    "",
    "Coarse",
    "Granules",
    "",
    "Pebbles",
    "",
    "Cobbles"
  };

  public static final int PYRO_COLOR[][] =
  { {102,  51,   0},  // Ohm 13 ?
    {153,  51,  51},  // Ohm 12 ?
    {153,  51,   0},  // Ohm 11
    {204, 102,  51},  // Ohm 10
    {204, 102,   0},  // Ohm 9
    {255, 153,   0},  // Ohm 8
    {255, 153,  51},  // Ohm 7
    {255, 204,   0},  // Ohm 6
    {255, 204,  51},  // Ohm 5
    {255, 204, 102},  // Ohm 4
    {255, 255,   0},  // yellow
    {255, 255,  51},  // Ohm 2  ?
    {255, 255, 102},  // Ohm 1  ?
    {255, 255, 204},  // Ohm 0  ?
  };

  public static final String ORG[] = {
    "1 ",
    "2 ",
    "3 ",
    "4 ",
    "5 ",
    "6 ",
    "7 ",
    "8 ",
    "9 ",
    "10",
    "11",
    "12",
    "13",
    "14" };

  public static final int ORG_COLOR[][] =
  { { 153,  51,   0 },  // Ohm 11
	{ 153,  51,  51 },  // Ohm 12 ?
	{ 102,  51,   0 },  // Ohm 13 ?
	{ 102,  51,  51 },  // Ohm 14 ?
	{  51,   0,   0 },  // Ohm 15 ?

    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 } };

  public static final int ORG_COLOR2[][] =
  { { 255, 255, 255 },
    { 128, 128, 255 },  // Middle Blue
    { 229, 229, 229 },  // Grey 90
    { 248, 248, 255 },  // ghost white
    { 255, 255, 255 },

    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 } };

  public static final String MET[] = {
    "",
    "",
    "Very Fine",
    "",
    "Fine",
    "",
    "Medium",
    "",
    "Coarse",
    "",
    "Massive",
    "",
    "",
    ""
  };

  public static final int MET_COLOR[][] =
  { {  69, 139, 116 }, // - aquamarine 4
    {  69, 139, 116 }, // - aquamarine 4
    {  69, 139, 116 }, // - aquamarine 4

    { 102, 205, 170 }, // - aquamarine 3
    { 102, 205, 170 }, // - aquamarine 3

    { 250, 128, 114 }, // - salmon
    { 250, 128, 114 }, // - salmon

    { 255, 105, 180 }, // - hot pink
    { 255, 105, 180 }, // - hot pink

    { 255, 182, 193 }, // - light pink
    { 255, 182, 193 }, // - light pink

    { 255, 255, 255 },
    { 255, 255, 255 },
    { 255, 255, 255 }
  };

  public static final String IGN[] = {
    "",
    "Dense",
    "",
    "Fine",
    "",
    "Medium",
    "",
    "",
    "Coarse",
    "",
    "",
    "Pegmatite",
    "",
    ""
  };

  public static final int IGN_COLOR[][] =
  {
    { 255, 140,   0 },  //  1 - Dense                     - dark orange
    { 255, 140,   0 },  //  2 - Dense                     - dark orange
    { 255, 165,   0 },  //  3 - Fine                      - orange
    { 255, 165,   0 },  //  4 - Fine                      - orange
    { 255,  20, 147 },  //  5 - Medium                    - deep pink
    { 255,  20, 147 },  //  6 - Medium                    - deep pink
    { 255,  20, 147 },  //  7 - Medium                    - deep pink
    { 255, 105, 180 },  //  8 - Coarse                    - hot pink
    { 255, 105, 180 },  //  9 - Coarse                    - hot pink
    { 255, 105, 180 },  // 10 - Coarse                    - hot pink
    { 255, 182, 193 },  // 11 - Very Coarse ( Pegmatite ) - light pink
    { 255, 182, 193 },  // 12 - Very Coarse ( Pegmatite ) - light pink
    { 255, 182, 193 },  // 13 - Very Coarse ( Pegmatite ) - light pink
    { 255, 182, 193 },  // 14 - Very Coarse ( Pegmatite ) - light pink
  };
}
