/*
 * @lithColorsStruct.java Version 1.1 03/25/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith;

/** Class lithColorsStruct
 *  <p> This Class holds the Lithology Plot Colors Data.
 *
 *  @version 1.1 03/25/2008
 *  @author  John R. Victorine
 */

public class lithColorsStruct
{
  public static final int _WHITE         = 0;
  public static final int _BLACK         = 1;
  public static final int _GREY_50       = 2;
  public static final int _GREY          = 3;
  public static final int _GREY_90       = 4;
  public static final int _RED           = 5;
  public static final int _BROWN         = 6;
  public static final int _SIENNA        = 7;
  public static final int _BURLYWOOD     = 8;
  public static final int _TAN           = 9;
  public static final int _SALMON        = 10;
  public static final int _ORANGE_RED_1  = 11;
  public static final int _DARK_ORANGE   = 12;
  public static final int _ORANGE        = 13;
  public static final int _MIDDLE_YELLOW = 14;
  public static final int _DARK_YELLOW   = 15;
  public static final int _YELLOW        = 16;
  public static final int _GREEN_YELLOW  = 17;
  public static final int _YELLOW_GREEN  = 18;
  public static final int _PALE_GREEN_1  = 19;
  public static final int _LIGHT_GREEN   = 20;
  public static final int _GREEN         = 21;
  public static final int _LAWN_GREEN    = 22;
  public static final int _FOREST_GREEN  = 23;
  public static final int _OLIVE_DRAB    = 24;
  public static final int _TURQUOISE     = 25;
  public static final int _AQUAMARINE_1  = 26;
  public static final int _AQUAMARINE_3  = 27;
  public static final int _AQUAMARINE_4  = 28;
  public static final int _MIDDLE_CYAN   = 29;
  public static final int _CYAN          = 30;
  public static final int _SKY_BLUE      = 31;
  public static final int _DEEP_SKY_BLUE_1 = 32;
  public static final int _DEEP_SKY_BLUE_2 = 33;
  public static final int _MIDDLE_BLUE   = 34;
  public static final int _ROYAL_BLUE    = 35;
  public static final int _BLUE          = 36;
  public static final int _LIGHT_PINK    = 37;
  public static final int _HOT_PINK      = 38;
  public static final int _DEEP_PINK     = 39;
  public static final int _LIGHT_MAGENTA = 40;
  public static final int _MAGENTA       = 41;
  public static final int _VIOLET        = 42;
  public static final int _DARK_VIOLET   = 43;
  public static final int _GHOST_WHITE   = 44;

  public static final int TOTAL          = 45;

  public static final int COLORS[][] =
  { { 255, 255, 255 }, // WHITE         = 0;
    {   0,   0,   0 }, // BLACK         = 1;
    { 127, 127, 127 }, // GREY_50       = 2;
    { 190, 190, 190 }, // GREY          = 3;
    { 229, 229, 229 }, // GREY_90       = 4;
    { 255,   0,   0 }, // RED           = 5;
    { 165,  42,  42 }, // BROWN         = 6;
    { 160,  82,  45 }, // SIENNA        = 7;
    { 222, 184, 135 }, // BURLYWOOD     = 8;
    { 210, 180, 140 }, // TAN           = 9;
    { 250, 128, 114 }, // SALMON        = 10;
    { 255,  69,   0 }, // ORANGE_RED_1  = 11;
    { 255, 140,   0 }, // DARK_ORANGE   = 12;
    { 255, 165,   0 }, // ORANGE        = 13;
    { 255, 255, 128 }, // MIDDLE_YELLOW = 14;
    { 255, 225,  25 }, // Darker Yellow
    { 255, 255,   0 }, // YELLOW        = 15;
    { 173, 255,  47 }, // GREEN_YELLOW  = 16;
    { 154, 205,  50 }, // YELLOW_GREEN  = 17;
    { 154, 255, 154 }, // PALE_GREEN_1  = 18;
    { 128, 255, 128 }, // LIGHT_GREEN   = 19;
    {   0, 255,   0 }, // GREEN         = 20;
    { 124, 252,   0 }, // LAWN_GREEN    = 21;
    {  34, 139,  34 }, // FOREST_GREEN  = 22;
    { 107, 142,  35 }, // OLIVE_DRAB    = 23;
    {  64, 224, 208 }, // TURQUOISE     = 24;
    { 127, 255, 212 }, // AQUAMARINE_1  = 25;
    { 102, 205, 170 }, // AQUAMARINE_3  = 26;
    {  69, 139, 116 }, // AQUAMARINE_4  = 27;
    { 128, 255, 255 }, // MIDDLE_CYAN   = 28;
    {   0, 255, 255 }, // CYAN          = 29;
    { 135, 206, 235 }, // SKY_BLUE      = 30;
    {   0, 191, 255 }, // DEEP_SKY_BLUE_1 = 31;
    {   0, 178, 238 }, // DEEP_SKY_BLUE_2 = 32;
    { 128, 128, 255 }, // MIDDLE_BLUE   = 33;
    {  65, 105, 225 }, // ROYAL_BLUE    = 34;
    {   0,   0, 255 }, // BLUE          = 35;
    { 255, 182, 193 }, // LIGHT_PINK    = 36;
    { 255, 105, 180 }, // HOT_PINK      = 37;
    { 255,  20, 147 }, // DEEP_PINK     = 38;
    { 255, 128, 255 }, // LIGHT_MAGENTA = 39;
    { 255,   0, 255 }, // MAGENTA       = 40;
    { 238, 130, 238 }, // VIOLET        = 41;
    { 140,   0, 211 }, // DARK_VIOLET   = 42;
    { 248, 248, 255 }}; // Ghost White

  /** Method getR()
   * <p> This method will return the Integer value of Red
   * @param  icolor  = The lithology color to return
   * @return Integer value of Red
   */

  public static int getR(int icolor) { return (COLORS[icolor][0]); }

  /** Method getG()
   * <p> This method will return the Integer value of Green
   * @param  icolor  = The lithology color to return
   * @return Integer value of Green
   */

  public static int getG(int icolor) { return (COLORS[icolor][1]); }

  /** Method getB()
   * <p> This method will return the Integer value of Blue
   * @param  icolor  = The lithology color to return
   * @return Integer value of Blue
   */

  public static int getB(int icolor) { return (COLORS[icolor][2]); }
}