/*
 * @lithOrganicTexturePanel.java Version 1.1 04/28/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.gui;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.util.Observable;
import java.util.Observer;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

/** Class lithOrganicTexturePanel
 *  <p> This Class will display the Chemical lithology sedimentary rock selected
 *
 *  @version 1.1 04/28/2011
 *  @author  John R. Victorine
 */

public class lithOrganicTexturePanel extends JPanel implements ActionListener
{
  // Input Variables

  private Observable notifier = null;     // Panel Observable

  // Global Variables

  public static final String ORG[] = lith.lithConstants.ORG;
  public static final int ORG_COLOR[][]  = lith.lithConstants.ORG_COLOR;
  public static final int ORG_COLOR2[][]  = lith.lithConstants.ORG_COLOR2;

  public static final int PRIMARY_SIZE[][] = lith.lithConstants.PRIMARY_SIZE;

  private int    iRock    = -1;      // Primary Lithology
  private int    iTexture = -1;      // Texture Energy Level
  private String sTexture = "";      // Texture Level Description

  // Global Panel Widgets

  // -- Lithology & Texture Widgets

  private JRadioButton rb[]   = null;  // Sediment Size
  private JRadioButton rbP[]  = null;  // Primary Lithologies

  /** Constructor lithOrganicTexturePanel()
   *  <p> This is the Constructor for this class.
   *  @param notifier = Observable
   */

  public lithOrganicTexturePanel( Observable notifier )
  {
    try
    {
      this.notifier = notifier;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
	int i=0;
	int    COLOR[][]   = null;
	String SIZE[]      = null;

    JPanel pnlTop      = new JPanel();

    JPanel pnlCenter   = new JPanel();
    JPanel pnlOrganic  = new JPanel();

    JPanel pnlWest     = new JPanel();

    ButtonGroup group  = new ButtonGroup();
    ButtonGroup groupP = new ButtonGroup();

    this.setLayout(new BorderLayout());
    this.setBackground(new Color( 255, 255, 255 ));

    // West Panel

    pnlWest.setLayout(new GridLayout(14,1));
    pnlWest.setBackground(new Color( 255, 255, 255 ));

    // -- Grain Size

    rb = new JRadioButton[14];

    COLOR = ORG_COLOR;
    SIZE  = ORG;

    for (i=13; i>-1; i--)
    {
	  rb[i] = new JRadioButton();
      rb[i].setFont(new java.awt.Font("Monospaced", 1, 11));
      rb[i].setHorizontalAlignment(SwingConstants.LEFT);
      rb[i].setBackground(new Color(COLOR[i][0],COLOR[i][1],COLOR[i][2]));
      rb[i].setForeground(new Color( 255, 255, 255 ));
      rb[i].setText( SIZE[i] );
      if (SIZE[i].length() == 0) { rb[i].setEnabled(false); }
      rb[i].addActionListener(this);

      pnlWest.add( rb[i], null);
      group.add( rb[i] );
	}

    // -- Build Main Lithologies

    rbP = new JRadioButton[lith.lithConstants._PRIMARY];

    for (i=0; i<lith.lithConstants._PRIMARY; i++)
    {
	  rbP[i] = new JRadioButton();
      rbP[i].setFont(new java.awt.Font("Monospaced", 1, 11));
      rbP[i].setHorizontalAlignment(SwingConstants.LEFT);
      rbP[i].setBackground(new Color( 255, 255, 255 ));
      rbP[i].setText( lith.lithConstants.PRIMARY[i][0] );
      rbP[i].addActionListener(this);

      groupP.add( rbP[i] );
    }

    // Center Panel

    pnlCenter.setLayout(new BorderLayout());
    pnlCenter.setBackground(new Color( 255, 255, 255 ));

    pnlOrganic = buildPanel();

    // Attach Widgets to Panel

    this.add(pnlWest,            BorderLayout.WEST);

    this.add(pnlCenter,          BorderLayout.CENTER);
    pnlCenter.add(pnlOrganic,    BorderLayout.CENTER);
  }

  /** Method buildPanel()
   * <p> This method will build the Chemical Lithology Panel
   */

  private JPanel buildPanel()
  {
	JPanel panel     = new JPanel();
	JPanel pnlCoal   = new JPanel();
	JPanel pnlSAPRO  = new JPanel();
	JPanel pnlSAPRO1 = new JPanel();
	JPanel pnlSAPRO2 = new JPanel();
	JPanel pnlHUMIC  = new JPanel();
	JPanel pnlHUMIC1 = new JPanel();
	JPanel pnlHUMIC2 = new JPanel();
	JPanel pnlChert  = new JPanel();

    TitledBorder titledBorderCoal = BorderFactory.createTitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Coals");
    titledBorderCoal.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderChert = BorderFactory.createTitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Chalk/Flint/Chert");
    titledBorderChert.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    panel.setLayout(new GridLayout(2,1));
    panel.setBackground(new Color( 255, 255, 255 ));

    pnlCoal.setLayout(new GridLayout(2,1));
    pnlCoal.setBorder(titledBorderCoal);
    pnlCoal.setBackground(new Color( 255, 255, 255 ));

    pnlSAPRO.setLayout(new GridLayout());
    pnlSAPRO.setBackground(new Color( 255, 255, 255 ));

    pnlSAPRO1.setLayout(new GridLayout());
    pnlSAPRO1.setBackground(new Color( 255, 255, 255 ));

    pnlSAPRO1.add(rbP[lith.lithConstants._SAPROPELIC],  null);

    pnlSAPRO2.setLayout(new GridLayout(2,1));
    pnlSAPRO2.setBackground(new Color( 255, 255, 255 ));

    pnlSAPRO2.add(rbP[lith.lithConstants._BOGHEAD],  null);
    pnlSAPRO2.add(rbP[lith.lithConstants._CANNEL],   null);

	pnlSAPRO.add(pnlSAPRO1,  null);
	pnlSAPRO.add(pnlSAPRO2,  null);

    pnlHUMIC.setLayout(new GridLayout());
    pnlHUMIC.setBackground(new Color( 255, 255, 255 ));

    pnlHUMIC1.setLayout(new GridLayout());
    pnlHUMIC1.setBackground(new Color( 255, 255, 255 ));

    pnlHUMIC1.add(rbP[lith.lithConstants._HUMIC],  null);

    pnlHUMIC2.setLayout(new GridLayout(5,1));
    pnlHUMIC2.setBackground(new Color( 255, 255, 255 ));

    pnlHUMIC2.add(rbP[lith.lithConstants._ANTHRACITE],      null);
    pnlHUMIC2.add(rbP[lith.lithConstants._BITUMINOUS],      null);
    pnlHUMIC2.add(rbP[lith.lithConstants._SUB_BITUMINOUS],  null);
    pnlHUMIC2.add(rbP[lith.lithConstants._LIGNITE],         null);
    pnlHUMIC2.add(rbP[lith.lithConstants._PEAT],            null);

	pnlHUMIC.add(pnlHUMIC1,  null);
	pnlHUMIC.add(pnlHUMIC2,  null);

	pnlCoal.add(pnlHUMIC,  null);
	pnlCoal.add(pnlSAPRO,  null);

    pnlChert.setLayout(new GridLayout(3,1));
    pnlChert.setBorder(titledBorderChert);
    pnlChert.setBackground(new Color( 255, 255, 255 ));

    pnlChert.add(rbP[lith.lithConstants._CHERT],  null);
    pnlChert.add(rbP[lith.lithConstants._FLINT],  null);
    pnlChert.add(rbP[lith.lithConstants._CHALK],  null);

	// Attach widgets to panel

	panel.add(pnlCoal,  null);
	panel.add(pnlChert, null);

	return (panel);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getLithology()
   *  <p> This method will retrieve the Primary Lithology selected
   *  @return iRock = The Primary Lithology
   */

  public int getLithology() { return (iRock); }

  /** Method getTexture()
   *  <p> This method will retrieve the Texture Level selected
   *  @return iTexture = The Texture Level Selected
   */

  public int getTexture() { return (iTexture); }

  /** Method getTextureDesc()
   *  <p> This method will retrieve the Texture Level Description selected
   *  @return sTexture = The Texture Level Description Selected
   */

  public String getTextureDesc() { return (sTexture); }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setTextureBTNS()
   *  <p> This method will set the Texture values depending on the seleced
   *      lithology.
   *  @param iRock = is the selected Rock button
   */

  private void setTextureBTNS( int iRock )
  {
	int    COLOR[][]   = null;
	String SIZE[]      = null;

	this.iRock = iRock;

    switch (iRock)
    {
	  case lith.lithConstants._CHALK:
	  case lith.lithConstants._FLINT:
	  case lith.lithConstants._CHERT:
	    SIZE  = ORG;
	    COLOR = ORG_COLOR2;
	    break;
	  default:
	    SIZE  = ORG;
	    COLOR = ORG_COLOR;
	    break;
	}

    if (iRock > -1)
    {
      for (int i=13; i>-1; i--)
      {
        rb[i].setBackground(new Color( 255, 255, 255 ));
        rb[i].setEnabled(false);

	    if ((PRIMARY_SIZE[iRock][i] == lith.lithConstants._ON) ||
	        (PRIMARY_SIZE[iRock][i] == lith.lithConstants._SET))
	    {
          rb[i].setBackground(new Color( COLOR[i][0],
                                         COLOR[i][1],
                                         COLOR[i][2]));
          rb[i].setText( SIZE[i] );
  	      rb[i].setSelected( true );
  	      rb[i].setEnabled( true );
  	      setTexture( i );
	    }
      }
    }
  }

  /** Method setTexture()
   *  <p> This method will set the Texture identifier
   *  @param iTexture = is the selected Texture button
   */

  private void setTexture( int iTexture )
  {
    this.sTexture = new String("");
    this.iTexture = iTexture+1;
  }

  /* ===================================================================== *
   * ----------------------------- CLOSE --------------------------------- *
   * ===================================================================== */

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
	int i = 0;

    // Input Variables

    notifier = null; // Panel Observable

    // Global Variables

    sTexture = null; // Texture Level Description

    // Global Panel Widgets

    // -- Lithology & Texture Widgets

    for (i=0; i<14; i++)
    {
	  rb[i] = null;
	}

    for (i=0; i<lith.lithConstants._PRIMARY; i++)
    {
	  rbP[i] = null;
	}

    rb   = null;  // Sediment Size
    rbP  = null;  // Primary Lithologies
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
	int i=0;

    for (i=0; i<14; i++)
    {
	  if (event.getSource() == rb[i])
	  {
	    setTexture( i );
	  }
	}

    for (i=0; i<lith.lithConstants._PRIMARY; i++)
    {
	  if (event.getSource() == rbP[i])
	  {
	    setTextureBTNS( i );
	  }
	}

    if (notifier != null)
      notifier.notifyObservers(new String("Primary Organic Selected"));
  }
}

/*
 *  @version 1.1 04/28/2011
 *  @author  John Victorine
 */
