/*
 * @lithMetamorphPanel.java Version 1.1 04/25/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.gui;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.util.Observable;
import java.util.Observer;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

/** Class lithMetamorphPanel
 *  <p> This Class will display the Igneous lithology/texture
 *
 *  @version 1.1 04/25/2011
 *  @author  John R. Victorine
 */

public class lithMetamorphPanel extends Panel implements ActionListener
{
  // Input Variables

  private Observable pNotifier = null;     // Panel Observable

  // Global Variables

  public static final String MET[]      = lith.lithConstants.MET;
  public static final int MET_COLOR[][] = lith.lithConstants.MET_COLOR;

  public static final int PRIMARY_SIZE[][] = lith.lithConstants.PRIMARY_SIZE;

  private int    iRock    = -1;      // Primary Lithology
  private String sRock    = "";      // Primary Lithology Description
  private int    iTexture = -1;      // Texture Energy Level
  private String sTexture = "";      // Texture Level Description

  // Global Widgets

  // -- Lithology & Texture Widgets

  private JRadioButton rb[]   = null;   // Sediment Size
  private JRadioButton rbP[]  = null;  // Primary Lithologies

  /** Constructor lithMetamorphPanel()
   *  <p> This is the Constructor for this class.
   *  @param pNotifier = Observable
   */

  public lithMetamorphPanel( Observable pNotifier )
  {
    try
    {
      this.pNotifier = pNotifier;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
	int    i=0;
	int    COLOR[][]      = null;
	String SIZE[]         = null;

    JPanel pnlWest        = new JPanel();

    JPanel pnlCenter      = new JPanel();
    JPanel pnlFoliated    = new JPanel();
    JPanel pnlNonfoliated = new JPanel();

    ButtonGroup group     = new ButtonGroup();
    ButtonGroup groupP    = new ButtonGroup();

    TitledBorder titledBorderFol = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Foliated:");
    titledBorderFol.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderNon = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Nonfoliated:");
    titledBorderNon.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    // Build Panel

    this.setBackground(Color.white);
    this.setLayout(new BorderLayout());

    // West Panel

    pnlWest.setLayout(new GridLayout(14,1));
    pnlWest.setBackground(Color.white);

    // -- Grain Size

    rb = new JRadioButton[14];

    COLOR = MET_COLOR;
    SIZE  = MET;

    for (i=13; i>-1; i--)
    {
	  rb[i] = new JRadioButton();
      rb[i].setFont(new java.awt.Font("Monospaced", 1, 11));
      rb[i].setHorizontalAlignment(SwingConstants.LEFT);
      rb[i].setBackground(new Color( COLOR[i][0],
                                     COLOR[i][1],
                                     COLOR[i][2]));
      rb[i].setText( SIZE[i] );
      if (SIZE[i].length() == 0) { rb[i].setEnabled(false); }
      rb[i].addActionListener(this);

      pnlWest.add( rb[i], null);
      group.add( rb[i] );
	}

    // -- Build Main Lithologies

    rbP = new JRadioButton[lith.lithConstants._PRIMARY];

    for (i=0; i<lith.lithConstants._PRIMARY; i++)
    {
	  rbP[i] = new JRadioButton();
      rbP[i].setFont(new java.awt.Font("Monospaced", 1, 11));
      rbP[i].setHorizontalAlignment(SwingConstants.LEFT);
      rbP[i].setBackground(new Color( 255, 255, 255 ));
      rbP[i].setText( lith.lithConstants.PRIMARY[i][0] );
      rbP[i].addActionListener(this);

      groupP.add( rbP[i] );
    }

    // Center Panel

    pnlCenter.setLayout(new GridLayout());
    pnlCenter.setBackground(Color.white);

    pnlFoliated.setLayout(new GridLayout(6,1));
    pnlFoliated.setBorder(titledBorderFol);
    pnlFoliated.setBackground(Color.white);

    pnlFoliated.add(rbP[lith.lithConstants._MIGMATITE],   null);
    pnlFoliated.add(rbP[lith.lithConstants._AMPHIBOLITE], null);
    pnlFoliated.add(rbP[lith.lithConstants._GNEISS],      null);
    pnlFoliated.add(rbP[lith.lithConstants._SCHIST],      null);
    pnlFoliated.add(rbP[lith.lithConstants._PHYLLITE],    null);
    pnlFoliated.add(rbP[lith.lithConstants._SLATE],       null);

    pnlNonfoliated.setLayout(new GridLayout(6,1));
    pnlNonfoliated.setBorder(titledBorderNon);
    pnlNonfoliated.setBackground(Color.white);

    pnlNonfoliated.add(rbP[lith.lithConstants._HORNFELS],   null);
    pnlNonfoliated.add(rbP[lith.lithConstants._MARBLE],     null);
    pnlNonfoliated.add(rbP[lith.lithConstants._MARBLE_DOL], null);
    pnlNonfoliated.add(rbP[lith.lithConstants._GRANULITE],  null);
    pnlNonfoliated.add(rbP[lith.lithConstants._QUARTZITE],  null);
    pnlNonfoliated.add(rbP[lith.lithConstants._ANTHRACITE], null);

    // Attach Widgets to Panel

    this.add(pnlWest,             BorderLayout.WEST);

    this.add(pnlCenter,           BorderLayout.CENTER);
    pnlCenter.add(pnlFoliated,    null);
    pnlCenter.add(pnlNonfoliated, null);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getLithology()
   *  <p> This method will retrieve the Primary Lithology selected
   *  @return sRock = The Primary Lithology Description
   */

  public String getLithology() { return (sRock); }

  /** Method getTexture()
   *  <p> This method will retrieve the Texture Level selected
   *  @return iTexture = The Texture Level Selected
   */

  public int getTexture() { return (iTexture); }

  /** Method getTextureDesc()
   *  <p> This method will retrieve the Texture Level Description selected
   *  @return sTexture = The Texture Level Description Selected
   */

  public String getTextureDesc() { return (sTexture); }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setTextureBTNS()
   *  <p> This method will set the Texture values depending on the seleced
   *      lithology.
   *  @param iRock = is the selected Rock button
   */

  private void setTextureBTNS( int iRock )
  {
	int    COLOR[][]   = null;
	String SIZE[]      = null;

	this.iRock = iRock;
	this.sRock = new String( lith.lithConstants.PRIMARY[iRock][0] );

    COLOR = MET_COLOR;
    SIZE  = MET;

    if (iRock > -1)
    {
      for (int i=13; i>-1; i--)
      {
        rb[i].setBackground(Color.white);
 	    rb[i].setEnabled(false);
      }

      for (int i=13; i>-1; i--)
      {
	    if ((PRIMARY_SIZE[iRock][i] == lith.lithConstants._ON) ||
	        (PRIMARY_SIZE[iRock][i] == lith.lithConstants._SET))
	    {
  	      if (PRIMARY_SIZE[iRock][i] == lith.lithConstants._SET)
  	      {
  	        rb[i].setSelected( true );
  	        setTexture( i );
		  }

          rb[i].setBackground(new Color( COLOR[i][0],
                                         COLOR[i][1],
                                         COLOR[i][2]));
          rb[i].setText( SIZE[i] );
    	  rb[i].setEnabled(true);

          if (SIZE[i].length() == 0)
          {
	  	    rb[i].setEnabled(false);
		  }
        }
      }
    }
  }

  /** Method setTexture()
   *  <p> This method will set the Texture identifier
   *  @param iTexture = is the selected Texture button
   */

  private void setTexture( int iTexture )
  {
	String SIZE[]      = null;
    SIZE  = MET;

    this.sTexture = new String( SIZE[iTexture] );
    this.iTexture = iTexture+1;
  }

  /* ===================================================================== *
   * ----------------------------- CLOSE --------------------------------- *
   * ===================================================================== */

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
	int i = 0;

    // Input Variables

    pNotifier = null; // Panel Observable

    // Global Variables

    sRock     = null; // Primary Lithology Description
    sTexture  = null; // Texture Level Description

    // Global Widgets

    // -- Lithology & Texture Widgets

    for (i=0; i<14; i++)
    {
	  rb[i] = null;
	}

    for (i=0; i<lith.lithConstants._PRIMARY; i++)
    {
	  rbP[i] = null;
	}

    rb   = null;  // Sediment Size
    rbP  = null;  // Primary Lithologies
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
	int i=0;

    for (i=0; i<14; i++)
    {
	  if (event.getSource() == rb[i])
	  {
	    setTexture( i );
	  }
	}

    for (i=0; i<lith.lithConstants._PRIMARY; i++)
    {
	  if (event.getSource() == rbP[i])
	  {
	    setTextureBTNS( i );
	  }
	}

    if (pNotifier != null)
      pNotifier.notifyObservers(new String("Metamorphic Lithology Selected"));
  }
}

/*
 *  @version 1.1 04/25/2011
 *  @author  John Victorine
 */
