/*
 * @lithIgneousPanel.java Version 1.1 04/25/2011
 *
 * Copyright (c) 2011 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package lith.gui;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.util.Observable;
import java.util.Observer;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

/** Class lithIgneousPanel
 *  <p> This Class will display the Igneous lithology/texture
 *
 *  @version 1.1 04/25/2011
 *  @author  John R. Victorine
 */

public class lithIgneousPanel extends Panel implements ActionListener
{
  // Input Variables

  private Observable pNotifier = null;     // Panel Observable

  // Global Variables

  public static final String IGN[]      = lith.lithConstants.IGN;
  public static final int IGN_COLOR[][] = lith.lithConstants.IGN_COLOR;

  public static final int PRIMARY_SIZE[][] = lith.lithConstants.PRIMARY_SIZE;

  private int    iRock    = -1;      // Primary Lithology
  private String sRock    = "";      // Primary Lithology Description
  private int    iTexture = -1;      // Texture Energy Level
  private String sTexture = "";      // Texture Level Description

  // Global Widgets

  // -- Lithology & Texture Widgets

  private JRadioButton rb[]   = null;   // Sediment Size
  private JRadioButton rbP[]  = null;  // Primary Lithologies

  /** Constructor lithIgneousPanel()
   *  <p> This is the Constructor for this class.
   *  @param pNotifier = Observable
   */

  public lithIgneousPanel( Observable pNotifier )
  {
    try
    {
      this.pNotifier = pNotifier;

      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Panel for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
	int    i=0;
	int    COLOR[][]      = null;
	String SIZE[]         = null;

    JPanel pnlNorth       = new JPanel();

    JLabel lblFelsic      = new JLabel();
    JLabel lblInter       = new JLabel();
    JLabel lblMafic       = new JLabel();
    JLabel lblUltra       = new JLabel();

    JPanel pnlWest        = new JPanel();

    JPanel pnlCenter      = new JPanel();
    JPanel pnlIntrusive   = new JPanel();
    JPanel pnlIntrusive1  = new JPanel();
    JPanel pnlIntrusive2  = new JPanel();
    JPanel pnlIntrusive3  = new JPanel();
    JPanel pnlIntrusive4  = new JPanel();

    JPanel pnlExtrusive   = new JPanel();
    JPanel pnlExtrusive1  = new JPanel();
    JPanel pnlExtrusive2  = new JPanel();
    JPanel pnlExtrusive3  = new JPanel();
    JPanel pnlExtrusive4  = new JPanel();

    JLabel lbl[]          = null;

    ButtonGroup group     = new ButtonGroup();
    ButtonGroup groupP    = new ButtonGroup();

    TitledBorder titledBorderTop = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "");
    titledBorderTop.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderInt = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Intrusive:");
    titledBorderInt.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    TitledBorder titledBorderExt = new TitledBorder(
        BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),
        "Extrusive:");
    titledBorderExt.setTitleFont(new java.awt.Font("Dialog", 1, 11));

    // Build Panel

    this.setBackground(Color.white);
    this.setLayout(new BorderLayout());

    // .. North Panel

    pnlNorth.setLayout(new GridLayout());
    pnlNorth.setBackground(Color.white);

    lblFelsic.setFont(new java.awt.Font("Dialog", 1, 12));
    lblFelsic.setHorizontalAlignment(SwingConstants.LEFT);
    lblFelsic.setText("  Felsic");

    lblInter.setFont(new java.awt.Font("Dialog", 1, 12));
    lblInter.setHorizontalAlignment(SwingConstants.LEFT);
    lblInter.setText("Intermediate");

    lblMafic.setFont(new java.awt.Font("Dialog", 1, 12));
    lblMafic.setHorizontalAlignment(SwingConstants.LEFT);
    lblMafic.setText("Mafic");

    lblUltra.setFont(new java.awt.Font("Dialog", 1, 12));
    lblUltra.setHorizontalAlignment(SwingConstants.LEFT);
    lblUltra.setText("Ultramafic");

    // West Panel

    pnlWest.setLayout(new GridLayout(14,1));
    pnlWest.setBackground(Color.white);

    // -- Grain Size

    rb = new JRadioButton[14];

    COLOR = IGN_COLOR;
    SIZE  = IGN;

    for (i=13; i>-1; i--)
    {
	  rb[i] = new JRadioButton();
      rb[i].setFont(new java.awt.Font("Monospaced", 1, 11));
      rb[i].setHorizontalAlignment(SwingConstants.LEFT);
      rb[i].setBackground(new Color( COLOR[i][0],
                                     COLOR[i][1],
                                     COLOR[i][2]));
      rb[i].setText( SIZE[i] );
      if (SIZE[i].length() == 0) { rb[i].setEnabled(false); }
      rb[i].addActionListener(this);

      pnlWest.add( rb[i], null);
      group.add( rb[i] );
	}

    // -- Build Main Lithologies

    rbP = new JRadioButton[lith.lithConstants._PRIMARY];

    for (i=0; i<lith.lithConstants._PRIMARY; i++)
    {
	  rbP[i] = new JRadioButton();
      rbP[i].setFont(new java.awt.Font("Monospaced", 1, 11));
      rbP[i].setHorizontalAlignment(SwingConstants.LEFT);
      rbP[i].setBackground(new Color( 255, 255, 255 ));
      rbP[i].setText( lith.lithConstants.PRIMARY[i][0] );
      rbP[i].addActionListener(this);

      groupP.add( rbP[i] );
    }

    // -- Center Panel

    pnlCenter.setLayout(new BorderLayout());
    pnlCenter.setBackground(Color.white);

    // .. Intrusive Panel

    pnlIntrusive.setLayout(new GridLayout());
    pnlIntrusive.setBorder(titledBorderInt);
    pnlIntrusive.setBackground(Color.white);

    // .. .. Felsic

    pnlIntrusive1.setLayout(new GridLayout(3,1));
    pnlIntrusive1.setBackground(Color.white);

    pnlIntrusive1.add(rbP[lith.lithConstants._GRANITE], null);
    pnlIntrusive1.add(rbP[lith.lithConstants._SYENITE], null);
    pnlIntrusive1.add(rbP[lith.lithConstants._MONZONITE], null);

    // .. .. Intermediate

    pnlIntrusive2.setLayout(new GridLayout(3,1));
    pnlIntrusive2.setBackground(Color.white);

    pnlIntrusive2.add(rbP[lith.lithConstants._DIORITE], null);
    pnlIntrusive2.add(rbP[lith.lithConstants._GRANODIORITE], null);

    // .. .. Mafic

    pnlIntrusive3.setLayout(new GridLayout(3,1));
    pnlIntrusive3.setBackground(Color.white);

    pnlIntrusive3.add(rbP[lith.lithConstants._GABBRO], null);

    // .. .. Ultramafic

    pnlIntrusive4.setLayout(new GridLayout(3,1));
    pnlIntrusive4.setBackground(Color.white);

    pnlIntrusive4.add(rbP[lith.lithConstants._PERIDOTITE], null);

    // .. Attach Compositions

    pnlIntrusive.add(pnlIntrusive1, null);
    pnlIntrusive.add(pnlIntrusive2, null);
    pnlIntrusive.add(pnlIntrusive3, null);
    pnlIntrusive.add(pnlIntrusive4, null);

    // .. Extrusive Panel

    pnlExtrusive.setLayout(new GridLayout());
    pnlExtrusive.setBorder(titledBorderExt);
    pnlExtrusive.setBackground(Color.white);
    pnlExtrusive.setPreferredSize(new Dimension(10, 250));

    lbl = new JLabel[5];

    // .. .. Felsic

    pnlExtrusive1.setLayout(new GridLayout(5,1));
    pnlExtrusive1.setBackground(Color.white);

    pnlExtrusive1.add(rbP[lith.lithConstants._RHYOLITE], null);
    pnlExtrusive1.add(rbP[lith.lithConstants._TRACHYTE], null);
    pnlExtrusive1.add(rbP[lith.lithConstants._LATITE],   null);

    // .. .. Intermediate

    pnlExtrusive2.setLayout(new GridLayout(5,1));
    pnlExtrusive2.setBackground(Color.white);

    pnlExtrusive2.add(rbP[lith.lithConstants._ANDESITE], null);
    pnlExtrusive2.add(rbP[lith.lithConstants._DACITE],   null);

    lbl[0] = new JLabel();

    pnlExtrusive2.add(lbl[0], null);
    pnlExtrusive2.add(rbP[lith.lithConstants._OBSIDIAN], null);
    pnlExtrusive2.add(rbP[lith.lithConstants._PUMICE],   null);

    // .. .. Mafic

    pnlExtrusive3.setLayout(new GridLayout(5,1));
    pnlExtrusive3.setBackground(Color.white);

    pnlExtrusive3.add(rbP[lith.lithConstants._BASALT], null);

    // .. .. Ultramafic

    pnlExtrusive4.setLayout(new GridLayout(5,1));
    pnlExtrusive4.setBackground(Color.white);

    lbl[1] = new JLabel();
    lbl[2] = new JLabel();
    lbl[3] = new JLabel();
    lbl[4] = new JLabel();

    pnlExtrusive4.add(lbl[1], null);
    pnlExtrusive4.add(lbl[2], null);
    pnlExtrusive4.add(lbl[3], null);
    pnlExtrusive4.add(lbl[4], null);

    pnlExtrusive4.add(rbP[lith.lithConstants._SCORIA], null);

    // .. Attach Compositions

    pnlExtrusive.add(pnlExtrusive1, null);
    pnlExtrusive.add(pnlExtrusive2, null);
    pnlExtrusive.add(pnlExtrusive3, null);
    pnlExtrusive.add(pnlExtrusive4, null);

    // Attach Widgets to Panel

    this.add(pnlCenter,           BorderLayout.CENTER);
    pnlCenter.add(pnlNorth,       BorderLayout.NORTH);
    pnlNorth.add(lblFelsic,       null);
    pnlNorth.add(lblInter,        null);
    pnlNorth.add(lblMafic,        null);
    pnlNorth.add(lblUltra,        null);

    pnlCenter.add(pnlIntrusive,   BorderLayout.CENTER);
    pnlCenter.add(pnlExtrusive,   BorderLayout.SOUTH);

    this.add(pnlWest,             BorderLayout.WEST);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getLithology()
   *  <p> This method will retrieve the Primary Lithology selected
   *  @return sRock = The Primary Lithology Description
   */

  public String getLithology() { return (sRock); }

  /** Method getTexture()
   *  <p> This method will retrieve the Texture Level selected
   *  @return iTexture = The Texture Level Selected
   */

  public int getTexture() { return (iTexture); }

  /** Method getTextureDesc()
   *  <p> This method will retrieve the Texture Level Description selected
   *  @return sTexture = The Texture Level Description Selected
   */

  public String getTextureDesc() { return (sTexture); }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setTextureBTNS()
   *  <p> This method will set the Texture values depending on the seleced
   *      lithology.
   *  @param iRock = is the selected Rock button
   */

  private void setTextureBTNS( int iRock )
  {
	int    COLOR[][]   = null;
	String SIZE[]      = null;

	this.iRock = iRock;
	this.sRock = new String( lith.lithConstants.PRIMARY[iRock][0] );

    COLOR = IGN_COLOR;
    SIZE  = IGN;

    if (iRock > -1)
    {
      for (int i=13; i>-1; i--)
      {
        rb[i].setBackground(Color.white);
 	    rb[i].setEnabled(false);
      }

      for (int i=13; i>-1; i--)
      {
	    if ((PRIMARY_SIZE[iRock][i] == lith.lithConstants._ON) ||
	        (PRIMARY_SIZE[iRock][i] == lith.lithConstants._SET))
	    {
  	      if (PRIMARY_SIZE[iRock][i] == lith.lithConstants._SET)
  	      {
  	        rb[i].setSelected( true );
  	        setTexture( i );
		  }

          rb[i].setBackground(new Color( COLOR[i][0],
                                         COLOR[i][1],
                                         COLOR[i][2]));
          rb[i].setText( SIZE[i] );
    	  rb[i].setEnabled(true);

          if (SIZE[i].length() == 0)
          {
	  	    rb[i].setEnabled(false);
		  }
        }
      }
    }
  }

  /** Method setTexture()
   *  <p> This method will set the Texture identifier
   *  @param iTexture = is the selected Texture button
   */

  private void setTexture( int iTexture )
  {
	String SIZE[]      = null;
    SIZE  = IGN;

    this.sTexture = new String( SIZE[iTexture] );
    this.iTexture = iTexture+1;
  }

  /* ===================================================================== *
   * ----------------------------- CLOSE --------------------------------- *
   * ===================================================================== */

  /** Method close()
   * <p> This method will close all dialogs that are opened by this class.
   */

  public void close()
  {
	int i = 0;

    // Input Variables

    pNotifier = null; // Panel Observable

    // Global Variables

    sRock     = null; // Primary Lithology Description
    sTexture  = null; // Texture Level Description

    // Global Widgets

    // -- Lithology & Texture Widgets

    for (i=0; i<14; i++)
    {
	  rb[i] = null;
	}

    for (i=0; i<lith.lithConstants._PRIMARY; i++)
    {
	  rbP[i] = null;
	}

    rb   = null;  // Sediment Size
    rbP  = null;  // Primary Lithologies
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
	int i=0;

    for (i=0; i<14; i++)
    {
	  if (event.getSource() == rb[i])
	  {
	    setTexture( i );
	  }
	}

    for (i=0; i<lith.lithConstants._PRIMARY; i++)
    {
	  if (event.getSource() == rbP[i])
	  {
	    setTextureBTNS( i );
	  }
	}

    if (pNotifier != null)
      pNotifier.notifyObservers(new String("Igneous Lithology Selected"));
  }
}

/*
 *  @version 1.1 04/25/2011
 *  @author  John Victorine
 */
