/*
 * @las3Struct.java Version 1.1 01/15/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package las3;

/** Class las3Struct
 *  <p> This Class holds a spectific data type from the LAS Digital Log File,
 *      it will hold the three sections of data for each type.
 *      ~{}_Parameter   - Parameter Data sections that corresponds to
 *                        Parameters for the data section.
 *      ~{}_Definition  - Column Definition sections that corresponds to
 *                        Curve Definitions for the data section
 *      ~{}_Data        - Column Data sections that corresponds to LAS data
 *                        for the section type
 *
 *      Parameter & Definition LAS Line Format
 *        MNEM.UNIT VALUE : DESCRIPTION {Format} | Assoc1 Assoc2
 */

public class las3Struct
{
  // Parameter & Definition LAS Line Format

  public static final int _MNEMONIC      = 0;
  public static final int _UNIT          = 1;
  public static final int _VALUE         = 2;
  public static final int _DESCRIPTION   = 3;
  public static final int _FORMAT        = 4;
  public static final int _ASSOCIATION   = 5;
  public static final int _TOTAL         = 6;

  // Parameter & Definition LAS Line Format Abbreviations

  public static final String LAS_LINE[] = {
    "MNEM", "UNIT", "VALUE", "DESC", "FORMAT", "ASSOC" };

  // LAS File Format or Data Type Identifier

  public static final int _NONE       = -1;
  public static final int _INTEGER    = 0;
  public static final int _FLOAT      = 1;
  public static final int _DOUBLE     = 2;
  public static final int _SCIENTIFIC = 3;
  public static final int _CHARACTER  = 4;
  public static final int _STRING     = 5;
  public static final int _ARRAY      = 6;

  public static final String FORMAT[] = { "I", "F", "D", "E", "S", "C", "A" };

  public int    iArray  = 0;                       // Array Number
  public int    iType   = las3.las3Constants._NONE; // Type of Data Identifier
  public String sType   = "";                      // Type of Data Name Set
  public int    iqstrat = -1;                      // IQSTRAT Saved Data Indicator

  /* LAS File Information
   */

  public int    iArrayP    = -1;   // Array Number
  public String sWrapP     = "No"; // Multiple lines per row
  public String sDelimP    = " ";  // Delimiting Character between data
  public int    iTypeP     = 0;    // Type of LAS File Retrieval, FILE or URL
  public String sDirectory = "";   // Directory Path to the LAS File
  public String sFilename  = "";   // File name of LAS File
  public double dVersion   = 0.0;  // Version Number of the File

  /* Parameters
   */

  public int    iParamRows  = 0;      // Total number of rows
  public int    iParamCols  = _TOTAL; // Total number of columns
  public int    iParam[]    = null;   // Array holding the Format Identifiers
  public String sParam[]    = null;   // Array holding the Format of Data
                                      // within Parameters, Column Data is
                                      //   -- "F" - float"
                                      //   -- "I" - integer
                                      //   -- "C" - String
                                      //   -- "S" - String
  public String sParams[][] = null;   // Array holding the Parameter Definitions

  /* Curves (Definitions)
   */

  public int    iCurveRows  = 0;      // Total number of rows
  public int    iCurveCols  = _TOTAL; // Total number of columns
  public int    iCurve[]    = null;   // Array holding the Curve Format ID
  public String sCurve[]    = null;   // Array holding the Format of Data
                                      // within Curve, Column Data is
                                      //   -- "F" - float"
                                      //   -- "I" - integer
                                      //   -- "E" - Scientific Notation
                                      //   -- "C" - String
                                      //   -- "S" - String
                                      //   -- "A" - Array of Data
  public String sCurves[][] = null;   // Array holding the Curve Definitions

  public int    iSelectRows = 0;      // Total number of modifiers to Curves
  public String select[][]  = null;   // Selected Curves & KGS Mnemonics
                                      // for the Log & Core Data Types Only

  /* Data
   */

//  public int    iCount     = 0;
  public int    iRows      = 0;      // Total Number of Rows
  public int    iColumns   = 0;      // Total Number of Columns ( iCurveRows )
  public String sData[][]  = null;   // Array holding the Data

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    iArray     = 0;    // Array Number
    iType      = -1;   // Type of Data Identifier
    sType      = null; // Type of Data Set

    /* LAS File Information
     */

    iArrayP    = 0;    // Array Number
    sWrapP     = null; // Multiple lines per row
    sDelimP    = null; // Delimiting Character between data
    iTypeP     = 0;    // Type of LAS File Retrieval, FILE or URL
    sDirectory = null; // Directory Path to the LAS File
    sFilename  = null; // File name of LAS File
    dVersion   = 0.0;  // Version Number of the File

    /* Parameters
     */

    iParamRows = 0;    // Total number of rows
    iParamCols = 0;    // Total number of columns
    sParam     = null; // Array holding the Format of Data within Parameters
    iParam     = null; // Array holding the Format Identifiers
    sParams    = null; // Array holding the Parameter Definitions

    /* Curves
     */

    iCurveRows  = 0;    // Total number of rows
    iCurveCols  = 0;    // Total number of columns
    sCurve      = null; // Array holding the Format of Data within Curve
    iCurve      = null; // Array holding the Curve Format ID
    sCurves     = null; // Array holding the Curve Definitions

    iSelectRows = 0;    // Total number of modifiers to Curves
    select      = null; // Selected Curves & KGS Mnemonics

    /* Data
     */

//    iCount     = 0;
    iRows      = 0;    // Total Number of Rows in LAS Data Section
    iColumns   = 0;    // Total Number of Columns in LAS Data Section
    sData      = null; // Array holding Data in LAS Data Section
  }
}

/*
 *  @version 1.1 01/15/2010
 *  @author  John Victorine
 */
