/*
 * @las3Parse.java Version 1.1 01/16/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package las3;

import las3.las3ListStruct;
import las3.las3Struct;

/** Class las3Parse
 *  <p> This Class will provide parse utilities for the LAS 3 Read Class
 *
 *  @version 1.1 01/16/2010
 *  @author  John R. Victorine
 */

public class las3Parse
{
  public static final int _TILDE         = las3.las3Constants._TILDE;
  public static final char TILDE         = las3.las3Constants.TILDE;
  public static final int _POUND         = las3.las3Constants._POUND;
  public static final char POUND         = las3.las3Constants.POUND;
  public static final int _PERIOD        = las3.las3Constants._PERIOD;
  public static final char PERIOD        = las3.las3Constants.PERIOD;
  public static final int _COLON         = las3.las3Constants._COLON;
  public static final char COLON         = las3.las3Constants.COLON;
  public static final int _SEMI_COLON    = las3.las3Constants._SEMI_COLON;
  public static final char SEMI_COLON    = las3.las3Constants.SEMI_COLON;
  public static final int _BRACE_LEFT    = las3.las3Constants._BRACE_LEFT;
  public static final char BRACE_LEFT    = las3.las3Constants.BRACE_LEFT;
  public static final int _BRACE_RIGHT   = las3.las3Constants._BRACE_RIGHT;
  public static final char BRACE_RIGHT   = las3.las3Constants.BRACE_RIGHT;
  public static final int _BRACKET_LEFT  = las3.las3Constants._BRACKET_LEFT;
  public static final char BRACKET_LEFT  = las3.las3Constants.BRACKET_LEFT;
  public static final int _BRACKET_RIGHT = las3.las3Constants._BRACKET_RIGHT;
  public static final char BRACKET_RIGHT = las3.las3Constants.BRACKET_RIGHT;
  public static final int _BAR           = las3.las3Constants._BAR;
  public static final char BAR           = las3.las3Constants.BAR;
  public static final int _TAB           = las3.las3Constants._TAB;
  public static final char TAB           = las3.las3Constants.TAB;
  public static final int _COMMA         = las3.las3Constants._COMMA;
  public static final char COMMA         = las3.las3Constants.COMMA;
  public static final int _SPACE         = las3.las3Constants._SPACE;
  public static final char SPACE         = las3.las3Constants.SPACE;

  public static final String CHAR[] = las3.las3Constants.CHAR;

  // Title Name of Data Section Identifiers
/*
  public static final int _NONE         = las3.las3Constants._NONE;
  public static final int _VERSION      = las3.las3Constants._VERSION;
  public static final int _WELL         = las3.las3Constants._WELL;
  public static final int _LOG          = las3.las3Constants._LOG;
  public static final int _CORE         = las3.las3Constants._CORE;
  public static final int _DRILLING     = las3.las3Constants._DRILLING;
  public static final int _INCLINOMETRY = las3.las3Constants._INCLINOMETRY;
  public static final int _TOPS         = las3.las3Constants._TOPS;
  public static final int _TEST         = las3.las3Constants._TEST;
  public static final int _PERFORATION  = las3.las3Constants._PERFORATION;
  public static final int _IQ_CONTROL   = las3.las3Constants._IQ_CONTROL;
  public static final int _IQ_LOG       = las3.las3Constants._IQ_LOG;
  public static final int _IQ_CORE      = las3.las3Constants._IQ_CORE;
*/
  // Title Name of Data Section

  public static final String SECTIONS[] = las3.las3Constants.SECTIONS;

  // Section Name

  public static final String SECTION[] = las3.las3Constants.SECTION;

  // Alternate Standard Name

  public static final String ALTERNATE[][] = las3.las3Constants.ALTERNATE;

  public static final String VALID_SECTIONS[][] = las3.las3Constants.VALID_SECTIONS;

  /* ====================================================================== *
   * ---------------------- CHECK LAS 3 Text METHODS ---------------------- *
   * ====================================================================== */

  /** Method isCommentLine()
   * <p> This method will detect if this is a Comment line
   * @param  str    = the string to be tested.
   * @return bValue = true-comment line; false-Not a comment line
   */

  public static boolean isCommentLine( String str )
  {
    boolean bValue = false;
    String  sTemp  = "";

    if (str.length() >= 2)
    {
      sTemp = ( str.trim() ).substring(0, 1);
      if (sTemp.equals( CHAR[_POUND] ))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method isSectionTitle()
   * <p> This method will detect if this is a new Section Title
   * @param  str    = the string to be tested.
   * @return bValue = true-New Section; false-Not a New Secton
   */

  public static boolean isSectionTitle( String str )
  {
    boolean bValue = false;
    String  sTemp  = "";

    if (str.length() >= 2)
    {
      sTemp = ( str.trim() ).substring(0, 1);
      if (sTemp.equals( CHAR[_TILDE] ))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method is1stSpace()
   * <p> This method will detect if the first character a space
   * @param  str    = the string to be tested.
   * @return bValue = true-is space; false-Not a space
   */

  public static boolean is1stSpace( String str )
  {
    boolean bValue = false;
    String  sTemp  = "";

    if (str.length() >= 2)
    {
      sTemp = ( str.trim() ).substring(0, 1);
      if (sTemp.equals( CHAR[_SPACE] ))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method is1stBrace()
   * <p> This method will detect if the first character a brace
   * @param  str    = the string to be tested.
   * @return bValue = true-is brace; false-Not a brace
   */

  public static boolean is1stBrace( String str )
  {
    boolean bValue = false;
    String  sTemp  = "";

    if (str.length() >= 2)
    {
      sTemp = ( str.trim() ).substring(0, 1);
      if (sTemp.equals( CHAR[_BRACE_LEFT] ))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /* ====================================================================== *
   * ---------------------------- GET METHODS ----------------------------- *
   * ====================================================================== */

  /** Method getFormatText()
   * <p> This method will retrieve the format statement from the string
   * @param  str  = The string to be parsed
   * @return str1 = the format statement
   */

  public static String getFormatText( String str )
  {
    String str1 = new String("");
    char   c[]  = null;
    int    iadd = 0;

    if (str != null)
    {
      c = str.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i] == '{')
          iadd = 1;
        else if (c[i] == '}')
          iadd = 0;
        else if (iadd == 1)
          str1 = new String(str1 + c[i]);
      }
    }

    return (str1);
  }

  /** Method getDescription()
   * <p> This method will retrieve the format statement from the string
   * @param  str  = The string to be parsed
   * @return str1 = the format statement
   */

  public static String getDescription( String str )
  {
    String str1 = new String("");
    char   c[]  = null;
    int    iadd = 1;

    if (str != null)
    {
      c = str.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i] == '{')
          iadd = 0;
        else if (c[i] == '}')
          iadd = 0;
        else if (iadd == 1)
          str1 = new String(str1 + c[i]);
      }
    }

    return (str1);
  }

  /** Method getValidSection()
   * <p> This method will return the Valid Section and Type
   * @param  str    = the string to be split for information
   * @return sValid = the Valid Section and Type
   */

  public static String[] getValidSection( String str )
  {
    String  sValid[]  = { "", "", "" };
    String  sec[]     = { "", "", "" };
    boolean bVal      = false;
    int     len       = 0;
    int     iFound    = 0;

    if (str.length() > 0)
    {
      for (int i=0; i<VALID_SECTIONS.length; i++)
      {
        for (int j=0; j<5; j++)
        {
          sec[0] = new String( "" );
          sec[1] = new String( "" );
          sec[2] = new String( "" );

          len  = str.length();
          if (str.equals(VALID_SECTIONS[i][j]))
          {
            bVal   = true;
            iFound = i;
          }

          if (bVal)
          {
            sec[0] = new String( VALID_SECTIONS[iFound][5] );
            sec[1] = new String( VALID_SECTIONS[iFound][6] );

            for (int k=0; k<SECTION.length; k++)
            {
              if (sec[1].equals(SECTION[k]))
              {
                sValid[0] = new String( sec[0] );
                sValid[1] = new String( sec[1] );
                sValid[2] = new String( "0" );
              }
            }
          }
        }
      }

      if (sValid[0].length() == 0)
      {
        for (int i=0; i<VALID_SECTIONS.length; i++)
        {
          for (int j=0; j<5; j++)
          {
            sec[0] = new String( "" );
            sec[1] = new String( "" );
            sec[2] = new String( "" );

            len  = str.length();
            for (int m=0; m<10; m++)
            {
              bVal = str.regionMatches(
                       0, VALID_SECTIONS[i][j]+"["+m+"]", 0, len);

              if (bVal)
              {
                sec[0] = new String( VALID_SECTIONS[i][5] );
                sec[1] = new String( VALID_SECTIONS[i][6] );

                for (int k=0; k<SECTION.length; k++)
                {
                  if (sec[1].equals(SECTION[k]))
                  {
                    sValid[0] = new String( sec[0] );
                    sValid[1] = new String( sec[1] );
                    sValid[2] = new String( "" + m );
                  }
                }
              }
            }
          }
        }
      }
//      return (sValid);
    }

    return (sValid);
  }

  /** Method getSection()
   * <p> This method will get the section, type and order.
   * @param  str = the string to be split for information
   * @return sec = an array holding the section, type and order strings
   */

  public static String[] getSection( String str )
  {
    String  sec[]    = { "", "", "0" };
    String  tokens[] = null;
    String  sDelim   = new String("[" + SPACE  + "]+");

    if (str.length() > 0)
    {
      tokens = str.split(sDelim);
      sec    = getValidSection( tokens[0].toUpperCase() );
    }

    return (sec);
  }

  /** Method getSection()
   * <p> This method will get the section, type and order.
   * @param  str      = the string to be split for information
   * @param  dVersion = Version Number
   * @return sec      = an array holding the section, type and order strings
   */

  public static String[] getSection( String str, double dVersion )
  {
    String  sec[]    = { "", "", "0" };
    String  tokens[] = null;
    String  sDelim   = new String("[" + SPACE  + "]+");
    String  sTemp    = "";

    if (str.length() > 0)
    {
      tokens = str.split(sDelim);

      sTemp = new String( tokens[0] );
      if (dVersion == 2.0)
        sTemp = new String( tokens[0].substring(0,2) );

//      sec    = getValidSection( tokens[0].toUpperCase() );
      sec    = getValidSection( sTemp.toUpperCase() );
    }

    return (sec);
  }

  /** Method getAssociation()
   * <p> This method will get the section, type and order.
   * @param  str = the string to be split for information
   * @return sec = an array holding the section, type and order strings
   */

  public static String[] getAssociation( String str )
  {
    String  sec[]    = { "", "", "0" };

    if (str.length() > 0)
    {
      sec = getValidSection( str.toUpperCase() );
    }

    return (sec);
  }

  /* ====================================================================== *
   * ---------------------- SPLIT LAS 3 Line METHODS ---------------------- *
   * ====================================================================== */

  /** Method splitTitle()
   * <p> This method will split the Section Title into two parts if a '|'
   *     divides the Section Title.
   * @param  str   = the string to be split
   * @return split = an array holding two strings
   */

  public static String[] splitTitle( String str )
  {
    String split[]  = { "", "" };
    String tokens[] = null;
    String sDelim   = new String("[" + BAR  + "]+");

    if (str.length() > 0)
    {
      tokens = str.split( sDelim );

      if (tokens.length > 1)
      {
        split[0] = new String( tokens[0].trim() );
        split[1] = new String( tokens[1].trim() );
      }
      else if (tokens.length > 0)
        split[0] = new String( tokens[0].trim() );
    }

    return (split);
  }

  /** Method splitLine()
   * <p> This method will 1st split the Description Data Line into 3 strings
   *     1st break at '.'
   *     2nd break at ':'
   *     3rd break at '|' if it is present only
   *     Then it will assign the split value for the 6 types,
   *     the Association values will parsed later.
   *
   * Data Line Format  "MNEM.UNIT VALUE : DESCRIPTION {Format} | Assoc1 Assoc2"
   * @param  str   = the string to be split
   * @param  sDel  = the delimiter character to split the "VALUE" Term
   * @return split = an array holding two strings
   */

  public static String[][] splitLine( String str, String sDel )
  {
    int i=0;
    int iValue = 0;
    String split[][] = null;
    String sTemp[]   = { "", "", "", "" };
    String tokens[]  = null;
    String sPeriod   = new String("[" + PERIOD  + "]+");
    String sColon    = new String("[" + COLON  + "]+");
    String sBar      = new String("[" + BAR  + "]+");
    String space     = new String("[" + SPACE  + "]+");
    String sDelim    = new String("[" + sDel  + "]+");

    if (str.length() > 0)
    {
      tokens   = str.split( sColon );

      if (tokens.length > 1)
      {
        sTemp[0] = new String( tokens[0] );
        sTemp[1] = new String( tokens[1] );
      }
      else
        sTemp[0] = new String( tokens[0] );

      if (sTemp[0].length() > 0)
      {
        tokens   = ( sTemp[0].trim() ).split( sPeriod );

        if (tokens.length > 1)
        {
          // Add MNEM to Array
          split    = addData( tokens[0].trim(), "MNEM", split );

          sTemp[0] = new String( "" );
          for (i=1; i<tokens.length; i++)
          {
            if (i>1)
              sTemp[0] = new String( sTemp[0] + "." );
            sTemp[0] = new String( sTemp[0] +  tokens[i] );
          }

          if (sTemp[0].length() > 0)
          {
            // -- Split UNIT from VALUE --

            tokens = sTemp[0].split( space );

            if (tokens.length > 1)
            {
              if (!is1stSpace( tokens[0] ))
              {
                iValue = 1;
                // Add UNIT to Array
                if (tokens[0].trim().length() > 0)
                  split = addData( tokens[0].trim(), "UNIT", split );
              }

              sTemp[0] = "";
              for (i=iValue; i<tokens.length; i++)
                sTemp[0] = new String( sTemp[0] + tokens[i] + " " );

              // Add VALUE to Array
              if (sTemp[0].trim().length() > 0)
                split = addData( sTemp[0].trim(), "VALUE", split );
            }
            else
            {
              if (is1stSpace( tokens[0] ))
              {
                if (tokens[0].trim().length() > 0)
                  split = addData( tokens[0].trim(), "VALUE", split );
              }
              else
              {
                // Add UNIT to Array
                if (tokens[0].trim().length() > 0)
                  split = addData( tokens[0].trim(), "UNIT", split );
              }
            }
          }
        }
        else
        {
          // Add MNEM to Array
          split    = addData( tokens[0].trim(), "MNEM", split );
        }
      }

      if (sTemp[1].length() > 0)
      {
        tokens   = ( sTemp[1].trim() ).split( sBar );

        if (tokens.length > 1)
        {
          sTemp[1] = new String( tokens[0] );
          sTemp[2] = new String( tokens[1] );
        }
        else
          sTemp[1] = new String( tokens[0] );

        if (sTemp[1].length() > 0)
        {
          // -- Split DESCRIPTION from FORMAT --

          sTemp[3] = getDescription( tokens[0].trim() );
          if (sTemp[3].length() > 0)
            split = addData( sTemp[3], "DESCRIPTION", split );

          sTemp[3] = getFormatText( tokens[0].trim() );
          if (sTemp[3].length() > 0)
            split = addData( sTemp[3], "FORMAT", split );
        }

        if (sTemp[2].length() > 0)
        {
          // Add Assoc1 to Array
          split = addData( sTemp[2].trim(), "ASSOCIATION", split );
        }
      }
    }

    return (split);
  }

  /** Method splitDataLine()
   * <p> This method will split the data line into individual data strings using
   *     the delimeter.  Note: This method will only run if the Definition
   *     columns is populated.
   * @param  str      = the string to be split
   * @param  sDel     = the delimiter character to split the data term
   * @return split    = the array of data strings
   */

  public static String[] splitDataLine( String str, String sDel )
  {
    int i=0, k=0, m=0;
    int    iCount   = 0;
    String split1[] = null;
    String split[]  = null;
    String tokens[] = null;
    String sDelim   = new String("[" + sDel  + "]+");
    String sTemp    = "";
    String sTemp1   = "";
    int    iTotal   = 0;

    if (str.length() > 0)
    {
      tokens = str.split( sDelim );

      if (tokens.length > 0)
      {
        split  = new String[tokens.length];
        iTotal = tokens.length;

        for (i=0; i<tokens.length; i++)
        {
          sTemp  = "";
          sTemp1 = "";

          if (i<tokens.length-1)
          {
            sTemp  = new String( tokens[i].substring(0,1) );
            sTemp1 = new String(
                tokens[i].substring( tokens[i].length()-1, tokens[i].length()));
            k=i+1;
          }

          if (sTemp.equals("\""))
          {
            while (!sTemp1.equals("\""))
            {
              sTemp1 = new String(
                  tokens[k].substring( tokens[k].length()-1,
                                       tokens[k].length()));
              k++;
            }

            split[iCount] = new String( tokens[i] );
            for (m=i+1; m<k; m++)
            {
              split[iCount] = new String( split[iCount] + sDel + tokens[m] );
              i++; // Increment the tokens counter by one.
              iTotal--;
            }
            split[iCount] = new String( removeQuotes( split[iCount] ) );
            iCount++;
          }
          else
          {
            split[iCount] = new String( tokens[i] );
            iCount++;
          }
        }
      }
    }

    if (split != null)
    {
      if (split.length > 0)
      {
        split1 = new String[iTotal];
        for (i=0; i<iTotal; i++)
        {
          split1[i] = new String( removeQuotes( split[i] ) );
        }
      }
    }

    return (split1);
  }

  /* ====================================================================== *
   * ---------------------------- MISC METHODS ---------------------------- *
   * ====================================================================== */

  /** Method addData()
   * <p> This method will add a string to the data array
   * @param   str  = string to be added to array
   * @param   sTyp = Type of String in the array
   * @param   sArr = String array
   * @return  sArr = String array
   */

  public static String[][] addData( String str, String sTyp, String sArr[][] )
  {
    int i, j;
    String sTemp[][] = null;
    int    iCount  = 0;

    if (sArr != null)
    {
      sTemp = new String[sArr.length+1][2];

      for (i=0; i<sArr.length; i++)
      {
        for (j=0; j<2; j++)
        {
          sTemp[iCount][j] = new String( sArr[i][j] );
        }
        iCount++;
      }
    }
    else
    {
      sTemp       = new String[1][2];
      sTemp[0][0] = new String( "" );
      sTemp[0][1] = new String( "" );
    }


    sTemp[iCount][0] = new String( str );
    sTemp[iCount][1] = new String( sTyp );
    iCount++;

    sArr = new String[iCount][2];

    for (i=0; i<iCount; i++)
    {
      for (j=0; j<2; j++)
      {
        sArr[i][j] = new String( sTemp[i][j] );
      }
    }

    return (sArr);
  }

  /** Method removeBraces()
   * <p> This method will remove the Braces around the Format statement
   * @param  str  = The string to be converted
   * @return sNew = The text being converted
   */

  public static String removeBraces( String str )
  {
    String sNew = new String("");
    char   c[]  = null;

    if (str != null)
    {
      c = str.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if ((c[i] != '{') || (c[i] != '}'))
          sNew = new String(sNew + c[i]);
      }
    }

    return (sNew);
  }

  /** Method removeQuotes()
   * <p> This method will remove the Quotes around the String
   * @param  str  = The string to be converted
   * @return sNew = The text converted
   */

  public static String removeQuotes( String str )
  {
    String sNew = new String("");
    char   c[]  = null;

    if (str != null)
    {
      c = str.toCharArray();

      for (int i=0; i<c.length; i++)
      {
        if (c[i] != '\"')
          sNew = new String(sNew + c[i]);
      }
    }

    return (sNew);
  }
}

/*
 *  @version 1.1 01/16/2010
 *  @author  John Victorine
 */
