/*
 * @las3ListStruct.java Version 1.1 01/15/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package las3;

import las3.las3Struct;

/** Class las3ListStruct
 *  <p> This Class will hold all the LAS Data File Data Sections
 */

public class las3ListStruct
{
  public double     dVersion = 0.0;  // Version Number of LAS File
  public String     sWrap    = "No"; // Multiple lines per row
  public String     sDelim   = " ";  // Delimiting Character between data

  public int        iCount   = 0;    // Total Number of Records Retrieved
  public las3Struct stItem[] = null; // Array of LAS 3 Data Structures.

  public int        iError   = 0;    // Error Number
  public String     sError   = "";   // Error Text.

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    iError = 0;    // Error Number
    sError = null; // Error Text.

    dVersion = 0.0;  // Version Number of LAS File
    sWrap    = null; // Multiple lines per row
    sDelim   = null; // Delimiting Character between data

    if (iCount > 0)
    {
      for (int i=0; i<iCount; i++)
      {
        stItem[i].delete();
      }
    }

    iCount = 0;    // Total Number of Records Retrieved
    stItem = null; // Array of LAS 3 Data Structures.
  }
}

/*
 *  @version 1.1 01/15/2010
 *  @author  John Victorine
 */
