/*
 * @las3Constants.java Version 1.1 01/16/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package las3;

import las3.las3ListStruct;
import las3.las3Struct;

/** Class las3Constants
 *  <p> This Class will provide parse constants for the LAS 3 Read Class
 *
 *  @version 1.1 01/16/2010
 *  @author  John R. Victorine
 */

public class las3Constants
{
  public static final int _SOURCE_NONE = -1; // No Data
  public static final int _SOURCE_APP  = 0;  // Data Entry through App
  public static final int _SOURCE_LAS  = 1;  // Data Entry through LAS
  public static final int _SOURCE_CSV  = 2;  // Data Entry through CSV
  public static final int _SOURCE_KGS  = 3;  // Data Entry through KGS
  public static final int _SOURCE_PC   = 4;  // Data Entry through PC

  // ~ Tilde         - Start of Section title
  //                 - First Non Space                         - ASCII Code 126
  public static final int _TILDE         = 0;
  public static final char TILDE         = '~';
  // # Pound         - Start of Comment line
  //                 - First Non Space                         - ASCII Code 35
  public static final int _POUND         = 1;
  public static final char POUND         = '#';
  // . Period        - MNEM and Unit
  //                 - First period on line                    - ASCII Code 46
  public static final int _PERIOD        = 2;
  public static final char PERIOD        = '.';
  // : Colon         - Value and Description
  //                 - Last colon on line                      - ASCII Code 58
  public static final int _COLON         = 3;
  public static final char COLON         = ':';
  // ; Semi Colon    - Format and Array Spacing indicators
  //                 - Within { } format field                 - ASCII Code 59
  public static final int _SEMI_COLON    = 4;
  public static final char SEMI_COLON    = ';';
  // { Left Brace    - Begins Format
  //                 - After Description before | or EOL       - ASCII Code 123
  public static final int _BRACE_LEFT    = 5;
  public static final char BRACE_LEFT    = '{';
  // } Right Brace   - Ends Format
  //                 - After Description before | or EOL       - ASCII Code 125
  public static final int _BRACE_RIGHT   = 6;
  public static final char BRACE_RIGHT   = '}';
  // [ Left Bracket  - Begins Section Title or MNEM index
  //                 - Appended to any MNEM or section title   - ASCII Code 91
  public static final int _BRACKET_LEFT  = 7;
  public static final char BRACKET_LEFT  = '[';
  // ] Right Bracket - Ends Section Title or MNEM index
  //                 - Appended to any MNEM or section title   - ASCII Code 93
  public static final int _BRACKET_RIGHT = 8;
  public static final char BRACKET_RIGHT = ']';
  // | Bar           - Description or Format and Association
  //                 - After Description or Format {}          - ASCII Code 93
  public static final int _BAR           = 9;
  public static final char BAR           = '|';
  // \t Tab           - Column Data Item
  //                 - Present between items                   - ASCII Code 9
  public static final int _TAB           = 10;
  public static final char TAB           = '\t';
  // , Comma         - Column Data Item
  //                 - Present between items                   - ASCII Code 44
  public static final int _COMMA         = 11;
  public static final char COMMA         = ',';
  // ' ' Space       - Unit and Value on Parameter Data Lines and Column Data
  //                 - Present between items                   - ASCII Code 32
  public static final int _SPACE         = 12;
  public static final char SPACE         = ' ';

  public static final String CHAR[] = { "~", "#", ".", ":", ";",
                                        "{", "}", "[", "]", "|",
                                        "\t", ",", " " };

  // Title Name of Data Section Identifiers

  public static final int _NONE          = -1;

  // LAS 3 Standard Data Sections

  public static final int _VERSION       = 0;  // Version Informaiton
  public static final int _WELL          = 1;  // Well Information
  public static final int _LOG           = 2;  // Log Data Section
  public static final int _CORE          = 3;  // Core Data Section
  public static final int _DRILLING      = 4;  // Drilling Data Section
  public static final int _INCLINOMETRY  = 5;  // Inclinometry Data Section
  public static final int _TOPS          = 6;  // Tops Data Section
  public static final int _TEST          = 7;  // Test Data Section
  public static final int _PERFORATION   = 8;  // Perforation Data Section

  // -- User Defined Data Sections

  public static final int _IQ_CONTROL    = 9;  // Control Data Section
  public static final int _IQ_LOG        = 10; // Selected Log Curves
  public static final int _IQ_CORE       = 11; // Selected Core Curves

  public static final int _IQ_SEQ_STRAT  = 12; // Sequence Stratigraphy

  public static final int _IQ_FLOW       = 13; // PfEFFER FLow Units
  public static final int _IQ_PFEFFER    = 14; // PfEFFER Table Data

  public static final int _IQ_GEO_REPORT = 15; // Geo report Table Data

  public static final int _IQ_SHALE      = 16; // Gamma API Shale Limits

  public static final int _IQ_IMAGES     = 17; // Rock Images Table Data
  public static final int _IQ_BRINE      = 18; // Brine Data Table Data

  public static final int _IQ_BIO        = 19; // Brine Data Table Data
  public static final int _IQ_ENV        = 20; // Depositional Environment Table Data

  public static final int _TOTAL         = 21;

  // Title Name of Data Section

  public static final String SECTIONS[] = {
    "Version",
    "Well",                          // Note: The "User Defined" Name will be
    "Log",                           //       replaced by the actual data type
    "Core",                          //       name, i.e. Fossils, Color, etc.
    "Drilling",
    "Inclinometry",
    "Tops",
    "Test",
    "Perforation",
    // -- User Defined Data Sections
    "IQ_Control",   // Control Data Structure
    "IQ_Las",       // Log Curves using KGS Mnemonics
    "IQ_Rock",      // Core Curves using KGS Mnemonics

    "IQ_Seq_Strat",  // Sequence Stratigaphy

    "IQ_Flow",       // PfEFFER FLow Units
    "IQ_Pfeffer",    // PfEFFER Table Data

    "IQ_Geo_Report", // Geo-Report Table Data

    "IQ_Shale",      // Gamma API Shale Limits

    "IQ_Images",     // Rock Table Images
    "IQ_Brine",      // Brine Table Data

    "IQ_Bio",        // Bio Stratigraphy Table Data
    "IQ_Env",        // Depositional Environment Table Data
  };

  // Line Terms

  public static final String LINE_TERMS[] = {
    "MNEM", "UNIT", "VALUE", "DESCRIPTION",  "FORMAT", "ASSOCIATION" };

  // Section Name Identifiers

  public static final int _PARAMETER  = 0;
  public static final int _DEFINITION = 1;
  public static final int _DATA       = 2;

  // Section Name

  public static final String SECTION[] = { "Parameter", "Definition", "Data" };

  // Alternate Standard Name ?????

  public static final String ALTERNATE[][] = {{ "V",         "Version" },
                                              { "W",         "Well" },
                                              { "CURVE",     "Log_Definition" },
                                              { "C",         "Log_Definition" },
                                              { "PARAMETER", "Log_Parameter" },
                                              { "P",         "Log_Parameter" },
                                              { "ASCII",     "Log_Data" },
                                              { "A",         "Log_Data" },
                                              { "O",         "Other" } };

  public static final String VALID_SECTIONS[][] = {
    { "~VERSION",         "~V", "VERSION", "", "",
        "Version", "Parameter" },

    { "~WELL",            "~W", "WELL",   "",  "",
        "Well",    "Parameter" },

    { "~PARAMETER",       "~P", "~LOG_PARAMETER",  "PARAMETER", "LOG_PARAMETER",
        "Log", "Parameter" },
    { "~CURVE",           "~C", "~LOG_DEFINITION", "CURVE",     "LOG_DEFINITION",
        "Log", "Definition" },
    { "~ASCII",           "~A", "~LOG_DATA",       "ASCII",     "LOG_DATA",
        "Log", "Data" },

    { "~CORE_PARAMETER",  "",      "",             "CORE_PARAMETER",  "",
        "Core", "Parameter" },
    { "~CORE_DEFINITION", "",      "",             "CORE_DEFINITION", "",
        "Core", "Definition" },
    { "~CORE_DATA",       "~CORE", "",             "CORE_DATA",       "CORE",
        "Core", "Data" },

    { "~DRILLING_DATA",   "~DRILLING", "",         "DRILLING_DATA",  "DRILLING",
        "Drilling", "Data" },
    { "~DRILLING_DEFINITION",     "", "",          "DRILLING_DEFINITION", "",
        "Drilling", "Definition" },
    { "~DRILLING_PARAMETER",      "", "",          "DRILLING_PARAMETER", "",
        "Drilling", "Parameter" },

    { "~INCLINOMETRY_DATA", "~INCLINOMETRY", "",   "INCLINOMETRY_DATA", "INCLINOMETRY",
        "Inclinometry", "Data" },
    { "~INCLINOMETRY_DEFINITION", "", "",          "INCLINOMETRY_DEFINITION", "",
        "Inclinometry", "Definition" },
    { "~INCLINOMETRY_PARAMETER",  "", "",          "INCLINOMETRY_PARAMETER",  "",
        "Inclinometry", "Parameter" },

    { "~TOPS_DATA",                  "~TOPS", "", "TOPS_DATA",           "TOPS",
        "Tops",        "Data" },
    { "~TOPS_DEFINITION",            "", "",   "TOPS_DEFINITION",          "",
        "Tops",        "Definition" },
    { "~TOPS_PARAMETER",             "", "",   "TOPS_PARAMETER",           "",
        "Tops",        "Parameter" },

    { "~TEST_DATA",                  "~TEST", "", "TEST_DATA",           "TEST",
        "Test",        "Data" },
    { "~TEST_DEFINITION",            "", "",   "TEST_DEFINITION",          "",
        "Test",        "Definition" },
    { "~TEST_PARAMETER",             "", "",   "TEST_PARAMETER",           "",
        "Test",        "Parameter" },

    { "~PERFORATION_DATA", "~PERFORATION", "~PERF", "PERFORATION_DATA", "PERFORATION",
        "Perforation", "Data" },
    { "~PERFORATION_DEFINITION",     "", "",   "PERFORATION_DEFINITION",   "",
        "Perforation", "Definition" },
    { "~PERFORATION_PARAMETER",      "", "",   "PERFORATION_PARAMETER",    "",
        "Perforation", "Parameter" },

    // Profile Plot Control Data

    { "~IQ_CONTROL_PARAMETER",       "", "",   "IQ_CONTROL_PARAMETER",     "",
        "IQ_Control", "Parameter" },
    { "~IQ_CONTROL_DEFINITION",      "", "",   "IQ_CONTROL_DEFINITION",    "",
        "IQ_Control", "Definition" },
    { "~IQ_CONTROL_DATA",            "", "",   "IQ_CONTROL_DATA",          "",
        "IQ_Control", "Data" },

    // Log & Core Selected Curves Data

    { "~IQ_LOG_PARAMETER",          "", "",    "IQ_LOG_PARAMETER",         "",
        "IQ_Las", "Parameter" },
    { "~IQ_LAS_PARAMETER",          "", "",    "IQ_LAS_PARAMETER",         "",
        "IQ_Las", "Parameter" },
    { "~IQ_LOG_DATA",               "", "",    "IQ_LOG_DATA",              "",
        "IQ_Las", "Parameter" },
    { "~IQ_LAS_DATA",               "", "",    "IQ_LAS_DATA",              "",
        "IQ_Las", "Parameter" },

    { "~IQ_CORE_PARAMETER",         "", "",    "IQ_CORE_PARAMETER",        "",
        "IQ_Rock", "Parameter" },
    { "~IQ_ROCK_PARAMETER",         "", "",    "IQ_ROCK_PARAMETER",        "",
        "IQ_Rock", "Parameter" },
    { "~IQ_CORE_DATA",              "", "",    "IQ_CORE_DATA",             "",
        "IQ_ROCK", "Parameter" },
    { "~IQ_ROCK_DATA",              "", "",    "IQ_ROCK_DATA",             "",
        "IQ_Rock", "Parameter" },

    // Profile Plot Control Data

    { "~IQ_SEQ_STRAT_PARAMETER",    "", "",   "IQ_SEQ_STRAT_PARAMETER",    "",
        "IQ_Seq_Strat", "Parameter" },
    { "~IQ_SEQ_STRAT_DEFINITION",   "", "",   "IQ_SEQ_STRAT_DEFINITION",   "",
        "IQ_Seq_Strat", "Definition" },
    { "~IQ_SEQ_STRAT_DATA",         "", "",   "IQ_SEQ_STRAT_DATA",         "",
        "IQ_Seq_Strat", "Data" },

    // PfEFFER Flow Units Data

    { "~IQ_FLOW_PARAMETER",         "", "",    "IQ_FLOW_PARAMETER",        "",
        "IQ_Flow", "Parameter" },
    { "~IQ_FLOW_DEFINITION",        "", "",    "IQ_FLOW_DEFINITION",       "",
        "IQ_Flow", "Definition" },
    { "~IQ_FLOW_DATA",              "", "",    "IQ_FLOW_DATA",             "",
        "IQ_Flow", "Data" },

    // PfEFFER Table Data

    { "~IQ_PFEFFER_PARAMETER",      "", "",    "IQ_PFEFFER_PARAMETER",     "",
        "IQ_Pfeffer", "Parameter" },
    { "~IQ_PFEFFER_DEFINITION",     "", "",    "IQ_PFEFFER_DEFINITION",    "",
        "IQ_Pfeffer", "Definition" },
    { "~IQ_PFEFFER_DATA",           "", "",    "IQ_PFEFFER_DATA",          "",
        "IQ_Pfeffer", "Data" },

    // Geo-Report Table Data

    { "~IQ_GEO_REPORT_PARAMETER",   "", "",    "IQ_GEO_REPORT_PARAMETER",  "",
        "IQ_Geo_Report", "Parameter" },
    { "~IQ_GEO_REPORT_DEFINITION",  "", "",    "IQ_GEO_REPORT_DEFINITION", "",
        "IQ_Geo_Report", "Definition" },
    { "~IQ_GEO_REPORT_DATA",        "", "",    "IQ_GEO_REPORT_DATA",       "",
        "IQ_Geo_Report", "Data" },

    // Gamma Ray Limits Table Data

    { "~IQ_SHALE_PARAMETER",        "", "",    "IQ_SHALE_PARAMETER",       "",
        "IQ_Shale", "Parameter" },
    { "~IQ_SHALE_DEFINITION",       "", "",    "IQ_SHALE_DEFINITION",      "",
        "IQ_Shale", "Definition" },
    { "~IQ_SHALE_DATA",             "", "",    "IQ_SHALE_DATA",            "",
        "IQ_Shale", "Data" },

    // Rock Images Table Data

    { "~IQ_IMAGES_PARAMETER",        "", "",    "IQ_IMAGES_PARAMETER",       "",
        "IQ_Images", "Parameter" },
    { "~IQ_IMAGES_DEFINITION",       "", "",    "IQ_IMAGES_DEFINITION",      "",
        "IQ_Images", "Definition" },
    { "~IQ_IMAGES_DATA",             "", "",    "IQ_IMAGES_DATA",            "",
        "IQ_Images", "Data" },

    // Brine Table Data

    { "~IQ_BRINE_PARAMETER",        "", "",    "IQ_BRINE_PARAMETER",       "",
        "IQ_Brine", "Parameter" },
    { "~IQ_BRINE_DEFINITION",       "", "",    "IQ_BRINE_DEFINITION",      "",
        "IQ_Brine", "Definition" },
    { "~IQ_BRINE_DATA",             "", "",    "IQ_BRINE_DATA",            "",
        "IQ_Brine", "Data" },

    // Bio-Stratigraphy Table Data

    { "~IQ_BIO_PARAMETER",          "", "",    "IQ_BIO_PARAMETER",       "",
        "IQ_Bio", "Parameter" },
    { "~IQ_BIO_DEFINITION",         "", "",    "IQ_BIO_DEFINITION",      "",
        "IQ_Bio", "Definition" },
    { "~IQ_BIO_DATA",               "", "",    "IQ_BIO_DATA",            "",
        "IQ_Bio", "Data" },

    // Depositional Environment Table Data

    { "~IQ_ENV_PARAMETER",          "", "",    "IQ_ENV_PARAMETER",       "",
        "IQ_Env", "Parameter" },
    { "~IQ_ENV_DEFINITION",         "", "",    "IQ_ENV_DEFINITION",      "",
        "IQ_Env", "Definition" },
    { "~IQ_ENV_DATA",               "", "",    "IQ_ENV_DATA",            "",
        "IQ_Env", "Data" },
  };
}

/*
 *  @version 1.1 01/16/2010
 *  @author  John Victorine
 */
