/*
 * @las3BuildStruct.java Version 1.1 01/25/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package las3;

/** Class las3BuildStruct
 *  <p> This Class temporary structure used to hold the data sections
 */

public class las3BuildStruct
{
  public int    iArray = 0;                       // Array Number
  public int    iType  = las3.las3Constants._NONE; // Type of Data Identifier

  public int    iTotal = 0;          // Total Number of Data Rows
  public int    iCount = 0;          // Counter while adding data

  public int    iRows      = 0;      // Total Number of Rows
  public int    iColumns   = 0;      // Total Number of Columns ( iCurveRows )
  public String sData[][]  = null;   // Array holding the Data

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    iArray     = 0;    // Array Number
    iType      = -1;   // Type of Data Identifier

    iTotal = 0;        // Total Number of Data Rows
    iCount = 0;        // Counter while adding data

    iRows      = 0;    // Total Number of Rows in LAS Data Section
    iColumns   = 0;    // Total Number of Columns in LAS Data Section
    sData      = null; // Array holding Data in LAS Data Section
  }
}

/*
 *  @version 1.1 01/25/2010
 *  @author  John Victorine
 */
