/*
 * @las3ToolsTable.java Version 1.1 06/20/2008
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package las3.gui;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.*;

import gui.guiTable;

/** Class las3ToolsTable
 *  <p> This Class will display the Standard Tools Table.
 *
 *  @version 1.1 06/20/2008
 *  @author  John R. Victorine
 */

public class las3ToolsTable
{
  private int      iRows       = 0;
  private int      iColumns    = 5;
  private String   sColumn[]   = { "Mnemonic",
                                   "Description",
                                   "Units",
                                   "Minimum",
                                   "Maximum" };
  private Object   oData[][]   = null;
  private guiTable pTable      = null;

  public static final int _LAS_TYPE    = 0;
  public static final int _CORE_TYPE   = 1;
  public static final int _TOPS_TYPE   = 2;
  public static final int _PERF_TYPE   = 3;
  public static final int _CNTRL_TYPE  = 4;
  public static final int _SEQ_TYPE    = 5;
  public static final int _FLOW_TYPE   = 6;
  public static final int _GEO_TYPE    = 13;
  public static final int _SHALE_TYPE  = 14;
  public static final int _IMAGES_TYPE = 15;
  public static final int _BRINE_TYPE  = 16;
  public static final int _BIO_TYPE    = 17;
  public static final int _ENV_TYPE    = 18;
  public static final int _DST_TYPE    = 19;

  private int iData = _LAS_TYPE;

  /** Constructor las3ToolsTable()
   *  <p> This is the Constructor for this class.
   *  @param iData    = type of data to display
   */

  public las3ToolsTable( int iData )
  {
    this.iData = iData;

    populateList();

    if (iRows > 0)
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    pTable.resizeColumn(0, 8);
    pTable.resizeColumn(2, 8);
    pTable.resizeColumn(3, 8);
    pTable.resizeColumn(4, 8);

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method close()
   * <p> This method will force java to allocate its memory
   */

  public void close()
  {
    sColumn = null;
    oData   = null;
    pTable  = null;
  }

  /** Method populateList
   *  <p> This method will load the Data Array for the guiTable.
   */

  private void populateList()
  {
    int    iTotal = 0;
    String sKID   = "";
    String sMnem  = "";
    String sUnit  = "";
    String sDesc  = "";
    double dMin   = 0.0;
    double dMax   = 0.0;

    if (iData == _LAS_TYPE)
    {
      iTotal = las.lasStandardTools.TOTAL_LAS;
    }
    else if (iData == _CORE_TYPE)
    {
      iTotal = rock.rockStandardTools.TOTAL_DATA;
    }
    else if (iData == _TOPS_TYPE)
    {
      iTotal = horizon.strat.stratStandardTools.TOTAL;
    }
    else if (iData == _PERF_TYPE)
    {
      iTotal = horizon.regions.regionsStandardTools.TOTAL;
    }
    else if (iData == _DST_TYPE)
    {
	  iTotal = dst.dstStandardTools.TOTAL;
	}
    else if (iData == _CNTRL_TYPE)
    {
      iTotal = iqstrat.iqstratControlStandardTools.TOTAL;
    }
    else if (iData == _SEQ_TYPE)
    {
      iTotal = horizon.seq.seqStandardTools.TOTAL;
    }
    else if (iData == _ENV_TYPE)
    {
      iTotal = horizon.env.envStandardTools.TOTAL;
    }
    else if (iData == _BIO_TYPE)
    {
      iTotal = horizon.bio.bioStandardTools.TOTAL;
    }
    else if (iData == _FLOW_TYPE)
    {
      iTotal = pfeffer.pfefferStandardTools.TOTAL_FLOW;
    }
    else if (iData == _GEO_TYPE)
    {
      iTotal = iqstrat.iqstratRemarkStandardTools.TOTAL;
    }
    else if (iData == _SHALE_TYPE)
    {
      iTotal = iqstrat.iqstratShaleStandardTools.TOTAL;
    }
    else if (iData == _IMAGES_TYPE)
    {
      iTotal = rock.rockImagesStandardTools.TOTAL;
    }
    else if (iData == _BRINE_TYPE)
    {
      iTotal = brine.brineStandardTools.TOTAL;
    }

    iRows = 0;
    oData = new Object[iTotal][iColumns];

    for (int i=0; i<iTotal; i++)
    {
      switch (iData)
      {
        case _LAS_TYPE:
          sKID  = new String(las.lasStandardTools.LAS_TOOLS[i][0]);
          sMnem = new String(las.lasStandardTools.LAS_TOOLS[i][1]);
          sDesc = new String(las.lasStandardTools.LAS_TOOLS[i][2]);
          sUnit = new String(las.lasStandardTools.LAS_TOOLS[i][3]);
          dMin  = cmn.cmnString.stringToDouble(
                    las.lasStandardTools.LAS_TOOLS[i][4]);
          dMax  = cmn.cmnString.stringToDouble(
                    las.lasStandardTools.LAS_TOOLS[i][5]);
          break;
        case _CORE_TYPE:
          sKID  = new String(rock.rockStandardTools.ROCK_TOOLS[i][6]);
          sMnem = new String(rock.rockStandardTools.ROCK_TOOLS[i][0]);
          sDesc = new String(rock.rockStandardTools.ROCK_TOOLS[i][1]);
          sUnit = new String(rock.rockStandardTools.ROCK_TOOLS[i][2]);
          dMin  = cmn.cmnString.stringToDouble(
                    rock.rockStandardTools.ROCK_TOOLS[i][4]);
          dMax  = cmn.cmnString.stringToDouble(
                    rock.rockStandardTools.ROCK_TOOLS[i][5]);
          break;
        case _TOPS_TYPE:
          sKID  = new String(horizon.strat.stratStandardTools.CURVES[i][0]);
          sMnem = new String(horizon.strat.stratStandardTools.CURVES[i][1]);
          sDesc = new String(horizon.strat.stratStandardTools.CURVES[i][2]);
          sUnit = new String(horizon.strat.stratStandardTools.CURVES[i][3]);
          dMin  = 0.0;
          dMax  = 0.0;
          break;
        case _PERF_TYPE:
          sKID  = new String(horizon.regions.regionsStandardTools.CURVES[i][0]);
          sMnem = new String(horizon.regions.regionsStandardTools.CURVES[i][1]);
          sDesc = new String(horizon.regions.regionsStandardTools.CURVES[i][2]);
          sUnit = new String(horizon.regions.regionsStandardTools.CURVES[i][3]);
          dMin  = 0.0;
          dMax  = 0.0;
          break;
        case _DST_TYPE:
          sKID  = new String(dst.dstStandardTools.CURVES[i][0]);
          sMnem = new String(dst.dstStandardTools.CURVES[i][1]);
          sDesc = new String(dst.dstStandardTools.CURVES[i][2]);
          sUnit = new String(dst.dstStandardTools.CURVES[i][3]);
          dMin  = 0.0;
          dMax  = 0.0;
          break;
        case _CNTRL_TYPE:
          sKID  = new String(iqstrat.iqstratControlStandardTools.CURVES[i][0]);
          sMnem = new String(iqstrat.iqstratControlStandardTools.CURVES[i][1]);
          sDesc = new String(iqstrat.iqstratControlStandardTools.CURVES[i][2]);
          sUnit = new String("");
          dMin  = 0.0;
          dMax  = 0.0;
          break;
        case _SEQ_TYPE:
          sKID  = new String(horizon.seq.seqStandardTools.CURVES[i][0]);
          sMnem = new String(horizon.seq.seqStandardTools.CURVES[i][1]);
          sDesc = new String(horizon.seq.seqStandardTools.CURVES[i][2]);
          sUnit = new String(horizon.seq.seqStandardTools.CURVES[i][3]);
          dMin  = 0.0;
          dMax  = 0.0;
          break;
        case _ENV_TYPE:
          sKID  = new String(horizon.env.envStandardTools.CURVES[i][0]);
          sMnem = new String(horizon.env.envStandardTools.CURVES[i][1]);
          sDesc = new String(horizon.env.envStandardTools.CURVES[i][2]);
          sUnit = new String(horizon.env.envStandardTools.CURVES[i][3]);
          dMin  = 0.0;
          dMax  = 0.0;
          break;
        case _BIO_TYPE:
          sKID  = new String(horizon.bio.bioStandardTools.CURVES[i][0]);
          sMnem = new String(horizon.bio.bioStandardTools.CURVES[i][1]);
          sDesc = new String(horizon.bio.bioStandardTools.CURVES[i][2]);
          sUnit = new String(horizon.bio.bioStandardTools.CURVES[i][3]);
          dMin  = 0.0;
          dMax  = 0.0;
          break;
        case _FLOW_TYPE:
          sKID  = pfeffer.pfefferStandardTools.P_CURVES[i][0];
          sMnem = pfeffer.pfefferStandardTools.P_CURVES[i][1];
          sDesc = pfeffer.pfefferStandardTools.P_CURVES[i][2];
          sUnit = pfeffer.pfefferStandardTools.P_CURVES[i][3];
          dMin  = cmn.cmnString.stringToDouble(
                    pfeffer.pfefferStandardTools.P_CURVES[i][4] );
          dMax  = cmn.cmnString.stringToDouble(
                    pfeffer.pfefferStandardTools.P_CURVES[i][5] );
          break;
        case _GEO_TYPE:
          sKID  = new String(iqstrat.iqstratRemarkStandardTools.CURVES[i][0] );
          sMnem = new String(iqstrat.iqstratRemarkStandardTools.CURVES[i][1] );
          sDesc = new String(iqstrat.iqstratRemarkStandardTools.CURVES[i][2] );
          sUnit = new String(iqstrat.iqstratRemarkStandardTools.CURVES[i][3] );
          dMin  = 0.0;
          dMax  = 0.0;
          break;
        case _SHALE_TYPE:
          sKID  = new String(iqstrat.iqstratShaleStandardTools.CURVES[i][0] );
          sMnem = new String(iqstrat.iqstratShaleStandardTools.CURVES[i][1] );
          sDesc = new String(iqstrat.iqstratShaleStandardTools.CURVES[i][2] );
          sUnit = new String(iqstrat.iqstratShaleStandardTools.CURVES[i][3] );
          dMin  = 0.0;
          dMax  = 0.0;
          break;
        case _IMAGES_TYPE:
          sKID  = new String(rock.rockImagesStandardTools.CURVES[i][0] );
          sMnem = new String(rock.rockImagesStandardTools.CURVES[i][1] );
          sDesc = new String(rock.rockImagesStandardTools.CURVES[i][2] );
          sUnit = new String(rock.rockImagesStandardTools.CURVES[i][3] );
          dMin  = 0.0;
          dMax  = 0.0;
          break;
        case _BRINE_TYPE:
          sKID  = new String(brine.brineStandardTools.CURVES[i][0]);
          sMnem = new String(brine.brineStandardTools.CURVES[i][1]);
          sUnit = new String(brine.brineStandardTools.CURVES[i][3]);
          sDesc = new String(brine.brineStandardTools.CURVES[i][2]);
          dMin  = 0.0;
          dMax  = 0.0;
          break;
      }

      oData[i][0] = new String( sMnem );
      oData[i][1] = new String( sDesc );
      oData[i][2] = new String( sUnit );
      oData[i][3] = new Double( dMin );
      oData[i][4] = new Double( dMax );

      iRows++;
    }
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getSelectedRow()
   *  <p> This method will return the selected row.
   *  @return Selected Row.
   */

  public int getSelectedRow() { return (pTable.getSelectedRow()); }

  /** Method getTotalRows()
   *  <p> This method will return the total number of rows.
   *  @return iRows - Total Rows.
   */

  public int getTotalRows() { return (iRows); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}
