/*
 * @las3ToolsFrame.java Version 1.1 06/20/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package las3.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Observable;
import javax.swing.*;
import javax.swing.event.*;

import cmn.cmnLASCurveStruct;
import las3.gui.las3ToolsTable;

/** Class las3ToolsFrame
 *  <p> This Class will allow the user to change the Mnemonics of a LAS File
 *
 *  @version 1.1 06/20/2008
 *  @author  John R. Victorine
 */

public class las3ToolsFrame extends JFrame implements ActionListener
{
  // Input Variables

  private Observable  notifier = null;     // Observable

  // Global Variables

  private las3ToolsTable pTable = null;     // Standard Tools List

  public static final int _LAS_TYPE     = las3.gui.las3ToolsTable._LAS_TYPE;
  public static final int _CORE_TYPE    = las3.gui.las3ToolsTable._CORE_TYPE;
  public static final int _TOPS_TYPE    = las3.gui.las3ToolsTable._TOPS_TYPE;
  public static final int _PERF_TYPE    = las3.gui.las3ToolsTable._PERF_TYPE;
  public static final int _CNTRL_TYPE   = las3.gui.las3ToolsTable._CNTRL_TYPE;
  public static final int _SEQ_TYPE     = las3.gui.las3ToolsTable._SEQ_TYPE;
  public static final int _FLOW_TYPE    = las3.gui.las3ToolsTable._FLOW_TYPE;
  public static final int _GEO_TYPE     = las3.gui.las3ToolsTable._GEO_TYPE;
  public static final int _SHALE_TYPE   = las3.gui.las3ToolsTable._SHALE_TYPE;
  public static final int _IMAGES_TYPE  = las3.gui.las3ToolsTable._IMAGES_TYPE;
  public static final int _BRINE_TYPE   = las3.gui.las3ToolsTable._BRINE_TYPE;
  public static final int _BIO_TYPE     = las3.gui.las3ToolsTable._BIO_TYPE;
  public static final int _ENV_TYPE     = las3.gui.las3ToolsTable._ENV_TYPE;
  public static final int _DST_TYPE     = las3.gui.las3ToolsTable._DST_TYPE;

  private int iData = _LAS_TYPE;

  // Global Frame Widgets

  private JButton btnSelect = new JButton();
  private JButton btnCancel = new JButton();

  /** Constructor las3ToolsFrame()
   *  <p> This is the Constructor for this class.
   *  @param notifier = Observable
   *  @param iData    = type of data to display
   */

  public las3ToolsFrame( Observable notifier, int iData )
  {
    try
    {
      this.notifier = notifier;
      this.iData    = iData;
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

  /** METHOD jbInit()
   *  <p> This Method will create the Frame for this class.
   *  @throws Exception
   */

  private void jbInit() throws Exception
  {
    JPanel pnlBase     = new JPanel();
    JPanel pnlCenter   = new JPanel();

    JScrollPane scroll = new JScrollPane();

    this.setTitle("Select KGS Standard Tools");
    this.getContentPane().setLayout(new BorderLayout());

    // Standard Tools List Panel

    pnlCenter.setLayout(new BorderLayout());

    pTable = new las3ToolsTable( iData );
    scroll = pTable.getScrollPane();

    // Global Frame Buttons Panel

    pnlBase.setBorder(BorderFactory.createEtchedBorder());

    // Select Standard KGS Curve

    btnSelect.setFont(new java.awt.Font("Dialog", 1, 11));
    btnSelect.setText("Select");
    btnSelect.addActionListener(this);

    // Close this frame

    btnCancel.setFont(new java.awt.Font("Dialog", 1, 11));
    btnCancel.setText("Cancel");
    btnCancel.addActionListener(this);

    // Attach Widgets to frame

    this.getContentPane().add(pnlBase, BorderLayout.SOUTH);
    pnlBase.add(btnSelect, null);
    pnlBase.add(btnCancel, null);

    this.getContentPane().add(pnlCenter, BorderLayout.CENTER);
    pnlCenter.add(scroll, BorderLayout.CENTER);

    // Display the Frame

    this.setSize(new Dimension(500, 650));
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    this.setLocation((d.width - this.getSize().width) / 2,
                     (d.height - this.getSize().height) / 2);

    this.setResizable(false);
    this.setVisible(true);
  }

  /*========================================================================*
   * ---------------------------- GET METHODS ------------------------------*
   *========================================================================*/

  /** Method getCurve()
   * <p> This method will retrieve the curve from the Standard curves list
   * @param  st = The las curve data structure
   * @return st = The las curve data structure
   */

  public cmnLASCurveStruct getCurve(cmnLASCurveStruct st)
  {
    int    iTool = pTable.getSelectedRow();
    String sKID  = "";
    String sMnem = "";
    String sUnit = "";
    String sDesc = "";
    double dMin  = 0.0;
    double dMax  = 0.0;

    switch (iData)
    {
      case _LAS_TYPE:
        sKID  = new String(las.lasStandardTools.LAS_TOOLS[iTool][0]);
        sMnem = new String(las.lasStandardTools.LAS_TOOLS[iTool][1]);
        sDesc = new String(las.lasStandardTools.LAS_TOOLS[iTool][2]);
        sUnit = new String(las.lasStandardTools.LAS_TOOLS[iTool][3]);
        dMin  = cmn.cmnString.stringToDouble(
                  las.lasStandardTools.LAS_TOOLS[iTool][4]);
        dMax  = cmn.cmnString.stringToDouble(
                  las.lasStandardTools.LAS_TOOLS[iTool][5]);
        break;
      case _CORE_TYPE:
        sKID  = new String(rock.rockStandardTools.ROCK_TOOLS[iTool][6]);
        sMnem = new String(rock.rockStandardTools.ROCK_TOOLS[iTool][0]);
        sDesc = new String(rock.rockStandardTools.ROCK_TOOLS[iTool][1]);
        sUnit = new String(rock.rockStandardTools.ROCK_TOOLS[iTool][2]);
        dMin  = cmn.cmnString.stringToDouble(
                  rock.rockStandardTools.ROCK_TOOLS[iTool][4]);
        dMax  = cmn.cmnString.stringToDouble(
                  rock.rockStandardTools.ROCK_TOOLS[iTool][5]);
        break;
      case _TOPS_TYPE:
        sKID  = new String(horizon.strat.stratStandardTools.CURVES[iTool][0]);
        sMnem = new String(horizon.strat.stratStandardTools.CURVES[iTool][1]);
        sDesc = new String(horizon.strat.stratStandardTools.CURVES[iTool][2]);
        sUnit = new String(horizon.strat.stratStandardTools.CURVES[iTool][3]);
        dMin  = 0.0;
        dMax  = 0.0;
        break;
      case _PERF_TYPE:
        sKID  = new String(horizon.regions.regionsStandardTools.CURVES[iTool][0]);
        sMnem = new String(horizon.regions.regionsStandardTools.CURVES[iTool][1]);
        sDesc = new String(horizon.regions.regionsStandardTools.CURVES[iTool][2]);
        sUnit = new String(horizon.regions.regionsStandardTools.CURVES[iTool][3]);
        dMin  = 0.0;
        dMax  = 0.0;
        break;
      case _BIO_TYPE:
        sKID  = new String(horizon.bio.bioStandardTools.CURVES[iTool][0]);
        sMnem = new String(horizon.bio.bioStandardTools.CURVES[iTool][1]);
        sDesc = new String(horizon.bio.bioStandardTools.CURVES[iTool][2]);
        sUnit = new String(horizon.bio.bioStandardTools.CURVES[iTool][3]);
        dMin  = 0.0;
        dMax  = 0.0;
        break;
      case _DST_TYPE:
        sKID  = new String(dst.dstStandardTools.CURVES[iTool][0]);
        sMnem = new String(dst.dstStandardTools.CURVES[iTool][1]);
        sDesc = new String(dst.dstStandardTools.CURVES[iTool][2]);
        sUnit = new String(dst.dstStandardTools.CURVES[iTool][3]);
        dMin  = 0.0;
        dMax  = 0.0;
        break;
      case _CNTRL_TYPE:
        sKID  = new String(iqstrat.iqstratControlStandardTools.CURVES[iTool][0]);
        sMnem = new String(iqstrat.iqstratControlStandardTools.CURVES[iTool][1]);
        sDesc = new String(iqstrat.iqstratControlStandardTools.CURVES[iTool][2]);
        sUnit = new String("");
        dMin  = 0.0;
        dMax  = 0.0;
        break;
      case _ENV_TYPE:
        sKID  = new String(horizon.env.envStandardTools.CURVES[iTool][0]);
        sMnem = new String(horizon.env.envStandardTools.CURVES[iTool][1]);
        sDesc = new String(horizon.env.envStandardTools.CURVES[iTool][2]);
        sUnit = new String(horizon.env.envStandardTools.CURVES[iTool][3]);
        dMin  = 0.0;
        dMax  = 0.0;
        break;
      case _SEQ_TYPE:
        sKID  = new String(horizon.seq.seqStandardTools.CURVES[iTool][0]);
        sMnem = new String(horizon.seq.seqStandardTools.CURVES[iTool][1]);
        sDesc = new String(horizon.seq.seqStandardTools.CURVES[iTool][2]);
        sUnit = new String(horizon.seq.seqStandardTools.CURVES[iTool][3]);
        dMin  = 0.0;
        dMax  = 0.0;
        break;
      case _FLOW_TYPE:
        sKID  = pfeffer.pfefferStandardTools.P_CURVES[iTool][0];
        sMnem = pfeffer.pfefferStandardTools.P_CURVES[iTool][1];
        sDesc = pfeffer.pfefferStandardTools.P_CURVES[iTool][2];
        sUnit = pfeffer.pfefferStandardTools.P_CURVES[iTool][3];
        dMin  = cmn.cmnString.stringToDouble(
                  pfeffer.pfefferStandardTools.P_CURVES[iTool][4] );
        dMax  = cmn.cmnString.stringToDouble(
                  pfeffer.pfefferStandardTools.P_CURVES[iTool][5] );
        break;
      case _GEO_TYPE:
        sKID  = new String(iqstrat.iqstratRemarkStandardTools.CURVES[iTool][0] );
        sMnem = new String(iqstrat.iqstratRemarkStandardTools.CURVES[iTool][1] );
        sDesc = new String(iqstrat.iqstratRemarkStandardTools.CURVES[iTool][2] );
        sUnit = new String(iqstrat.iqstratRemarkStandardTools.CURVES[iTool][3] );
        dMin  = 0.0;
        dMax  = 0.0;
        break;
      case _SHALE_TYPE:
        sKID  = new String(iqstrat.iqstratShaleStandardTools.CURVES[iTool][0] );
        sMnem = new String(iqstrat.iqstratShaleStandardTools.CURVES[iTool][1] );
        sDesc = new String(iqstrat.iqstratShaleStandardTools.CURVES[iTool][2] );
        sUnit = new String(iqstrat.iqstratShaleStandardTools.CURVES[iTool][3] );
        dMin  = 0.0;
        dMax  = 0.0;
        break;
      case _IMAGES_TYPE:
        sKID  = new String(rock.rockImagesStandardTools.CURVES[iTool][0] );
        sMnem = new String(rock.rockImagesStandardTools.CURVES[iTool][1] );
        sDesc = new String(rock.rockImagesStandardTools.CURVES[iTool][2] );
        sUnit = new String(rock.rockImagesStandardTools.CURVES[iTool][3] );
        dMin  = 0.0;
        dMax  = 0.0;
        break;
      case _BRINE_TYPE:
        sKID  = new String(brine.brineStandardTools.CURVES[iTool][0]);
        sMnem = new String(brine.brineStandardTools.CURVES[iTool][1]);
        sUnit = new String(brine.brineStandardTools.CURVES[iTool][3]);
        sDesc = new String(brine.brineStandardTools.CURVES[iTool][2]);
        dMin  = 0.0;
        dMax  = 0.0;
        break;
    }

    if (st != null)
    {
      st.sToolKID          = new String( sKID );
      st.sMnemonic         = new String( sMnem );
      st.sCurveName        = new String( sDesc );
      st.sCurveUnits       = new String( sUnit );
      st.sCurveDescription = new String( sDesc );
      st.dToolMinimumValue = dMin;
      st.dToolMaximumValue = dMax;
    }

    return (st);
  }

  /* ===================================================================== *
   * ---------------------------- ACTIONS -------------------------------- *
   * ===================================================================== */

  /** Method select()
   * <p> This method will select and plot the LAS File
   */

  private void select()
  {
    if (notifier != null)
      notifier.notifyObservers(new String("Get LAS Standard Tool"));
  }

  /** Method close()
   * <p> This method will set global variables to null in order to force JAVA
   *     to free unwanted memory.
   */

  public void close()
  {
    // Input Variables

    notifier = null;     // Observable

    // Global Variables

    if (pTable != null)
      pTable.close();
    pTable = null;     // Standard Tools List

    // Global Frame Widgets

    btnSelect = null;
    btnCancel = null;

    dispose();
  }

  /** METHOD actionPerformed()
   *  <p> This Method will handle all the actions within the Frame.
   *  @param event - Action Event
   */

  public void actionPerformed(ActionEvent event)
  {
    if (event.getSource() == btnSelect) { select(); }
    if (event.getSource() == btnCancel) { close(); }
  }
}