/*
 * @lasStruct.java Version 1.1 02/20/2004
 *
 * Copyright (c) 2004 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 *
 * Modified by John R. Victorine 11 July 2007
 * This Structure will be used to hold the LAS File Data only.
 */

package las;

import java.net.*;
import java.awt.*;
import java.applet.*;
import java.awt.image.*;

import cmn.cmnStruct;
import cmn.cmnLASFileListStruct;
import cmn.cmnLASFileStruct;

import iqstrat.iqstratHeadersStruct;

/** Class lasStruct
 *  <p> This Class holds the LAS Viewer Global Data.
 *
 *  @version 1.1 02/20/2004
 *  @author  John R. Victorine
 */

public class lasStruct
{
  // Global Data Structure

  public cmnStruct stCMN = new cmnStruct();

  // Color Lith Web Page

  public static final String COLORLITH =
      "http://abyss.kgs.ku.edu/Gemini/colorlith/LithoDensityColorScale.html";

  // Global Variables

  // Well Identifier information

  public String sAPI;            // Well API-Number
  public String sKID;            // Well Header KID
  public String sLASKID;         // LAS KID

  // Depth Range

  public double depthStart;      // Starting Depth of Plot
  public double depthEnd;        // Ending Depth of Plot

  public double dLASStart;       // Starting Depth of LAS
  public double dLASEnd;         // Ending Depth of LAS

  // Identifier to signify how to plot las file
  //   LAS_ONLY  = Read LAS File ONLY
  //   LAS_DATA  = Read in Core Data & images if present
  //   LAS_IMAGE = Read in Core images if present

  public int    iRead;           // Type of data to retrieve

  // Type of LAS Plot to create.

  public static final int SIMPLE_LAS   = 0; // Open LAS & Plot Default Curves
  public static final int WELL_PROFILE = 1; // Open LAS & User Sets Curves

  public int iDisplayPlot = SIMPLE_LAS;

  // Variables for LAS File Read - LAS Plots

  public String sReadMethod; // Read as URL or FILE
  public String sDirectory;  // URL or Directory Path to LAS File
  public String sFilename;   // Filename of LAS File

  public iqstratHeadersStruct  stWell;  // Well Header Info
  public cmnLASFileListStruct  stFiles; // LAS File List
  public cmnLASFileStruct      stFile;  // LAS File Data
}