/*
 * @lasDataListStruct.java Version 1.1 02/25/2004
 *
 * Copyright (c) 2004 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package las;

import las.lasDataStruct;

/** Class lasDataListStruct
 *  <p> This Class will hold the LAS List Structure Data.
 */

public class lasDataListStruct
{
  public int           iError      = 0;    // Error Number
  public String        sError      = "";   // Error Text.

  public int           iColumns    = 0;    // Total Number of Columns in LAS File
  public String        saColumns[] = null; // Array of Column Names

  public int           iCount      = 0;    // Total Number of Records Retrieved
  public lasDataStruct stItem[]    = null; // Array of LAS Data Structures.

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    iError      = 0;    // Error Number
    sError      = null; // Error Text.

    iColumns    = 0;    // Total Number of Columns in LAS File
    saColumns   = null; // Array of Column Names

    if (iCount > 0)
    {
      for (int i=0; i<iCount; i++)
      {
        stItem[i].delete();
      }
    }

    iCount      = 0;    // Total Number of Records Retrieved
    stItem      = null; // Array of LAS Data Structures.
  }
}
