/*
 * @lasFilesTable.java Version 1.1 10/22/2004
 *
 * Copyright (c) 2001 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package las.gui;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;

import gui.guiTable;
import cmn.cmnLASFileListStruct;
import cmn.cmnLASFileStruct;

/** Class lasFilesTable
 *  <p> This Class will display list of wells saved by the user to their PC.
 *
 *  @version 1.1 10/22/2004
 *  @author  John R. Victorine
 */

public class lasFilesTable
{
  private int      iRows     = 0;
  private int      iColumns  = 11;
  private String   sColumn[] = {"Start",
                                "End",
                                "OHM-M",
                                "Neutron",
                                "Density",
                                "Sonic",
                                "GR",
                                "PE",
                                "THOR",
                                "URAN",
                                "POTA"};
  private Object   oData[][] = null;
  private guiTable pTable    = null;

  private int                  iChange = 0;
  private cmnLASFileListStruct stList  = null;

  /** Constructor lasFilesTable()
   *  <p> This is the Constructor for this class.
   */

  public lasFilesTable()
  {
    pTable = new guiTable(0, iColumns, sColumn);
    pTable.resizeColumn(0, 8);
    pTable.resizeColumn(1, 8);
  }

  /** Constructor lasFilesTable()
   *  <p> This is the Constructor for this class.
   * @param stList = The Project List Data Structure.
   */

  public lasFilesTable(cmnLASFileListStruct stList)
  {
    this.stList = stList;

    populateList();

    if ((iRows > 0) && (iChange > 0))
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    pTable.resizeColumn(0, 8);
    pTable.resizeColumn(1, 8);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method close()
   * <p> This method will set global fields null in order to force JAVA to
   *     reallocate memory
   */

  public void close()
  {
    sColumn = null;
    oData   = null;
    pTable  = null;
    stList  = null;
  }

  /** Method populateList()
   *  <p> This method will populate the Region List data.
   */

  private void populateList()
  {
    int    i      = 0;
    int    j      = 0;
    int    iCount = 0;

    iRows = 1;
    oData = new String[1][iColumns];
    for (i=0; i<iColumns; i++)
      oData[0][i] = new String("");

    if (stList != null)
    {
      if (stList.iCount > 0)
      {
        iChange = 1;
        oData = new Object[stList.iCount][iColumns];

        for (i=0; i<stList.iCount; i++)
        {
          oData[iCount][0]  = new Double(stList.stItem[i].depthStart);
          oData[iCount][1]  = new Double(stList.stItem[i].depthEnd);
          oData[iCount][2]  = new String("No");
          oData[iCount][3]  = new String("No");
          oData[iCount][4]  = new String("No");
          oData[iCount][5]  = new String("No");
          oData[iCount][6]  = new String("No");
          oData[iCount][7]  = new String("No");
          oData[iCount][8]  = new String("No");
          oData[iCount][9]  = new String("No");
          oData[iCount][10] = new String("No");

          if (stList.stItem[i].iLog != null)
          {
            for (j=0; j<cmn.cmnLASFileStruct.TOTAL; j++)
            {
              switch (j)
              {
                case cmn.cmnLASFileStruct.RESISTIVITY:
                  if (stList.stItem[i].iLog[j] > 0)
                    oData[iCount][2] = new String("Yes");
                  break;

                case cmn.cmnLASFileStruct.DENSITY:
                  if (stList.stItem[i].iLog[j] > 0)
                    oData[iCount][4] = new String("Yes");
                  break;

                case cmn.cmnLASFileStruct.NEUTRON:
                  if (stList.stItem[i].iLog[j] > 0)
                    oData[iCount][3] = new String("Yes");
                  break;

                case cmn.cmnLASFileStruct.SONIC:
                  if (stList.stItem[i].iLog[j] > 0)
                    oData[iCount][5] = new String("Yes");
                  break;

                case cmn.cmnLASFileStruct.GAMMA_RAY:
                  if (stList.stItem[i].iLog[j] > 0)
                    oData[iCount][6] = new String("Yes");
                  break;

                case cmn.cmnLASFileStruct.PE:
                  if (stList.stItem[i].iLog[j] > 0)
                    oData[iCount][7] = new String("Yes");
                  break;

                 case cmn.cmnLASFileStruct.THORIUM:
                   if (stList.stItem[i].iLog[j] > 0)
                     oData[iCount][8] = new String("Yes");
                   break;

                 case cmn.cmnLASFileStruct.URANIUM:
                   if (stList.stItem[i].iLog[j] > 0)
                     oData[iCount][9] = new String("Yes");
                   break;

                 case cmn.cmnLASFileStruct.POTASSIUM:
                   if (stList.stItem[i].iLog[j] > 0)
                     oData[iCount][10] = new String("Yes");
                   break;
              }
            }
          }

          iCount++;
        }

        iRows = iCount;
      }
    }
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method setData()
   *  <p> This method will reload the Region List after adding, deleting from
   *      the formation name list.
   * @param stList = The Regions List Data Structure
   */

  public void setData(cmnLASFileListStruct stList)
  {
    this.stList = stList;

    populateList();

    pTable.reload(iRows, oData);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getTotal()
   * <p> This method will retrieve the total number of rows
   * @return iRows = The total number of rows
   */

  public int getTotal() { return (iRows); }

  /** Method getRow()
   * <p> This method will retrieve the Project Data Structure
   * @return stProject = the Project Data Structure
   */

  public cmnLASFileStruct getRow()
  {
    cmnLASFileStruct stLAS = null;

    if (iRows > 0)
    {
      stLAS = stList.stItem[pTable.getSelectedRow()];
    }

    return (stLAS);
  }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}
