/*
 * @kgsMeasSectUtility.java Version 1.1 09/27/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package kgs;

import kgs.kgsMeasSectListStruct;
import kgs.kgsMeasSectStruct;
import kgs.kgsMeasSectDataStruct;

/** Class kgsMeasSectUtility
 *  <p> This Class will provide basic utility for the data structures
 *
 *  @version 1.1 09/27/2009
 *  @author  John R. Victorine
 */

public class kgsMeasSectUtility
{
  /** Method copyList()
   * <p> This method will copy one structure to another
   * @param  stOld = the Old List Structure
   * @return stNew = the New List structure
   */

  public static kgsMeasSectListStruct copyList(kgsMeasSectListStruct stOld)
  {
    kgsMeasSectListStruct stNew = null;

    if (stOld != null)
    {
      stNew        = new kgsMeasSectListStruct();
      stNew.iCount = stOld.iCount;
      stNew.stItem = new kgsMeasSectStruct[stOld.iCount];

      for (int i=0; i<stOld.iCount; i++)
      {
        stNew.stItem[i] = copy(stOld.stItem[i]);
      }

      stNew.iRows  = stOld.iRows;
      stNew.stData = new kgsMeasSectDataStruct[stOld.iRows];

      for (int i=0; i<stOld.iRows; i++)
      {
        stNew.stData[i] = copy(stOld.stData[i]);
      }
    }

    return (stNew);
  }

  /** Method copy()
   * <p> This method will copy the data structure
   * @param  stOld = The old data structure
   * @return stNew = The new data structure
   */

  public static kgsMeasSectStruct copy(kgsMeasSectStruct stOld)
  {
    kgsMeasSectStruct stNew = null;

    if (stOld != null)
    {
      stNew = new kgsMeasSectStruct();

      // Identification Information

      stNew.sKID         = new String(stOld.sKID);   // Primary Key
      stNew.sName        = new String(stOld.sName);  // Measured Section
      stNew.sError       = new String(stOld.sError); // Error in SQL QUERY

      // Location Information

      stNew.state        = new String(stOld.state);     // State Name
      stNew.iState       = stOld.iState;                // State Code
      stNew.sCounty      = new String(stOld.sCounty);   // County Name
      stNew.iCounty      = stOld.iCounty;               // County Code

      stNew.iTownship    = stOld.iTownship;             // Township
      stNew.sTownship    = new String(stOld.sTownship); // Township Direction
      stNew.iRange       = stOld.iRange;                // Range
      stNew.sRange       = new String(stOld.sRange);    // Range Direction
      stNew.iSection     = stOld.iSection;              // Section

      // XY Position Information

      stNew.dLatitude    = stOld.dLatitude;  // Latitude of Location
      stNew.dLongitude   = stOld.dLongitude; // Longitude of Location

      // Z Position - Depth, Elevation

      stNew.depth        = stOld.depth; // Total Depth of Measured Section
      stNew.dGL          = stOld.dGL;   // Ground Level

      // Other Information

      stNew.sMeasuredBy  = new String(stOld.sMeasuredBy);  // Measured By
      stNew.sComments    = new String(stOld.sComments);    // general comments
    }

    return (stNew);
  }

  /** Method copy()
   * <p> This method will copy the data structure
   * @param  stOld = The old data structure
   * @return stNew = The new data structure
   */

  public static kgsMeasSectDataStruct copy(kgsMeasSectDataStruct stOld)
  {
    kgsMeasSectDataStruct stNew = null;

    if (stOld != null)
    {
      stNew = new kgsMeasSectDataStruct();

      stNew.sKEY         = new String(stOld.sKEY);         // Primary Key
      stNew.sOrder       = new String(stOld.sOrder);       // Unit Order
      stNew.sUnitNo      = new String(stOld.sUnitNo);      // Unit Number

      stNew.sDescription = new String(stOld.sDescription); // Description

      stNew.dThickness   = stOld.dThickness;               // Bed Thickness
      stNew.sUnits       = new String(stOld.sUnits);       // Thickness Units
    }

    return (stNew);
  }

  /** Method print()
   * <p> This method will print out the contents of the Measured Sections
   * @param st = Measured Section Data List Structure
   */

  public static void print( kgsMeasSectListStruct st )
  {
    int i=0;

    if (st != null)
    {
      for (i=0; i<st.iRows; i++)
      {
        System.out.println( st.stData[i].sKEY + " " +
                            st.stData[i].sOrder + " " +
                            st.stData[i].sUnitNo + " " +
                            st.stData[i].dThickness + " (" +
                            st.stData[i].sUnits + ") " +
                            st.stData[i].sDescription );
      }
    }
  }
}