/*
 * @kgsMeasSectStruct.java Version 1.0 09/27/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package kgs;

/** CLASS kgsMeasSectStruct
 *  <p> This Structure holds the measured section header for individual bed
 *
 *  @version 1.1 09/27/2009
 *  @author  John R. Victorine
 */

public class kgsMeasSectStruct
{
  // Identification Information

  public String sKID         = "0";  // DB Primary Key of the Header Record
  public String sName        = "";   // Well Name or Outcrop Name
  public String sError       = "";   // Error in SQL QUERY

  // Location Information

  public String state        = "";   // State Name
  public int    iState       = -1;   // State Code
  public String sCounty      = "";   // County Name
  public int    iCounty      = -1;   // County Code

  public int    iTownship    = 0;    // Township
  public String sTownship    = "";   // Township Direction
  public int    iRange       = 0;    // Range
  public String sRange       = "";   // Range Direction
  public int    iSection     = 0;    // Section

  // XY Position Information

  public double dLatitude    = 0.0; // Latitude of Location
  public double dLongitude   = 0.0; // Longitude of Location

  // Z Position - Depth, Elevation

  public double depth        = 0.0; // Total Depth of Measured Section
  public double dGL          = 0.0; // Ground Level

  // Other Information

  public String sMeasuredBy  = "";  // Measured By
  public String sComments    = "";  // general comments

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    sKID         = null;  // DB Primary Key of the Header Record
    sName        = null;  // Well Name or Outcrop Name
    sError       = null;  // Error in SQL QUERY

    state        = null; // State Name
    sCounty      = null; // County Name
    sTownship    = null; // township direction
    sRange       = null; //  range direction

    sMeasuredBy  = null; // Measured By
    sComments    = null; // general comments
  }
}
