/*
 * @kgsMeasSectListStruct.java Version 1.1 09/27/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package kgs;

import kgs.kgsMeasSectStruct;
import kgs.kgsMeasSectDataStruct;

/** CLASS kgsMeasSectListStruct
 *  <p> This Structure holds a list of Measured Section Headers
 *      Information Structures.
 *
 *  @version 1.1 09/27/2009
 *  @author  John R. Victorine
 */

public class kgsMeasSectListStruct
{
  public int                   iCount   = 0;    // Total Number of Records
  public kgsMeasSectStruct     stItem[] = null; // Array of Header Structures

  public int                   iRows    = 0;    // Total Number of Records
  public kgsMeasSectDataStruct stData[] = null; // Array of Data Structures

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    if (iCount > 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (stItem[i] != null)
          stItem[i].delete();
      }
    }

    iCount = 0;
    stItem = null;

    if (iRows > 0)
    {
      for (int i=0; i<iRows; i++)
      {
        if (stData[i] != null)
          stData[i].delete();
      }
    }

    iRows = 0;
    stData = null;
  }
}
