/*
 * @kgsMeasSectRead.java Version 1.1 03/04/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package kgs.io;

import java.awt.*;
import javax.swing.*;

import kgs.kgsMeasSectListStruct;
import kgs.kgsMeasSectStruct;
import kgs.io.ReadMeasSectXMLFile;

/** Class kgsMeasSectRead
 *  <p> This Class will retrieve the Measured Section data from the KGS database
 *
 *  @version 1.1 03/04/2010
 *  @author  John R. Victorine
 */

public class kgsMeasSectRead
{
  /** Method read()
   * <p> This method will read measured section data list structure
   * @param  iMethod = The Method used in retrieving the XML
   * @param  sPath   = The url or File Path to use
   * @return st  = The measured section data list structure
   */

  public static kgsMeasSectListStruct read( int iMethod, String sPath )
  {
    kgsMeasSectListStruct st = null;

    ReadMeasSectXMLFile pRead = new ReadMeasSectXMLFile( iMethod );
    st = pRead.Process( sPath );

    String sError = pRead.GetError();

    if ((st.iCount == 1) && (st.stItem[0].sError.length() == 0))
      sError = new String(st.stItem[0].sError);
    else if (st.iCount == 0)
      sError = new String("No Data Available");

    if (sError.length() > 0)
      JOptionPane.showMessageDialog( (Component)null,
                                     sError,
                                     "ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    return ( st );
  }

  /** Method readData()
   * <p> This method will retrieve the Measured section data from the database.
   * @param  sKID = The Measured Section Identifier
   * @return st   = the Measured section data list structure
   */

  public static kgsMeasSectListStruct readData( String sKID )
  {
    kgsMeasSectListStruct st = null;

    ReadMeasSectXMLFile pRead =
        new ReadMeasSectXMLFile(kgs.io.ReadMeasSectXMLFile.URL);

    st = pRead.Process( cmn.cmnStruct.KGS_OUTCROP_DATA  + "id=" + sKID );

    String sError = pRead.GetError();
    if (sError.length() > 0)
      JOptionPane.showMessageDialog( (Component)null,
                                     sError,
                                     "ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    return (st);
  }

  /** Method readCounties()
   * <p> This method will retrieve the list of counties that have Measured
   *     sections in the KGS Database.
   */

  public static kgsMeasSectListStruct readCounties()
  {
    kgsMeasSectListStruct st = null;

    ReadMeasSectXMLFile pRead =
        new ReadMeasSectXMLFile(kgs.io.ReadMeasSectXMLFile.URL);

    st = pRead.Process( cmn.cmnStruct.KGS_OUTCROP_COUNTIES );

    String sError = pRead.GetError();
    if (sError.length() > 0)
      JOptionPane.showMessageDialog( (Component)null,
                                     sError,
                                     "ERROR",
                                     JOptionPane.ERROR_MESSAGE);
    return (st);
  }
}