/*
 * @kgsIOUser.java Version 1.0 10/05/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package kgs.io;

import java.io.*;
import java.awt.*;
import javax.swing.*;

import kgs.kgsUserStruct;
import kgs.io.ReadUsersXMLFile;
import kgs.io.WriteUsersXMLFile;

/** Class kgsIOUser
 *  <p> This class will manage the User Login Data
 *
 *  @version 1.1 10/05/2007
 *  @author  John R. Victorine
 */

public class kgsIOUser
{
  public static final String USER_XML = "IQSTRAT_DB.xml";

  /** Method getHomeDir()
   * <p> This method will retrieve the User's Home Directory
   * @return sDirectory = The User Home Directory
   */

  public static String getHomeDir()
  {
    String sDir = "";    // User Home Directory
    File   pDir = null;  // User Home Directory File Object

    try
    {
      pDir = new File( System.getProperty( "user.home" ) );
      sDir = new String( pDir.getCanonicalPath() );
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("kgsIOUser.getHomeDir()\n "+e.toString());
      JOptionPane.showMessageDialog(
        (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }

    return (sDir);
  }

  /** Method getUser()
   * <p> This method will read the User information xml data
   * @param  iMethod = The Method used in retrieving the XML
   * @param  sPath   = The url or File Path to use
   * @return stUser  = The User Data Structure
   */

  public static kgsUserStruct getUser(int iMethod, String sPath)
  {
    kgsUserStruct stUser = null; // User Data Structure

    ReadUsersXMLFile pUser = new ReadUsersXMLFile(iMethod);
    stUser = pUser.Process(sPath);
//    stUser.print();

    return (stUser);
  }

  /** Method login()
   * <p> This method will log into the KGS for validation of User.
   * @param  sEmail    = the user email address
   * @param  sPassword = the user password
   * @return stUser    = The User Data Structure
   */

  public static kgsUserStruct login(String sEmail, String sPassword)
  {
    String        sPath  = cmn.cmnStruct.KGS_USER +
                           "sEmail=" + sEmail +
                           "&sPassword=" + sPassword;
    kgsUserStruct stUser = getUser(kgs.io.ReadUsersXMLFile.URL, sPath);

    return (stUser);
  }

  /** Method getUserByKey()
   * <p> This method will retrieve the User information By User's Primary Key.
   * @param  sKEY   = the user Primary KEY
   * @return stUser = The User Data Structure
   */

  public static kgsUserStruct getUserByKey(String sKEY)
  {
    String        sPath  = cmn.cmnStruct.KGS_USER + "sKEY=" + sKEY;
    kgsUserStruct stUser = getUser(kgs.io.ReadUsersXMLFile.URL, sPath);

    return (stUser);
  }

  /** Method exists()
   * <p> This method will check to see if the User Login XML File exists on the
   *     User's PC.
   * @return bValue = true the file exists and false the file does not
   */

  public static boolean exists()
  {
    boolean bValue = false;

    try
    {
      File p = new File( getHomeDir() );

      if (p.exists())
      {
        try
        {
          File pNew = new File(p, USER_XML);
          if (pNew.exists())
          {
            bValue = true;
          }
        }
        catch (Exception e)
        {
          e.printStackTrace();
          String sError = new String("iqstratIOUser().exists-2\n "+e.toString());
          JOptionPane.showMessageDialog(
              (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
        }
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
      String sError = new String("iqstratIOUser().exists\n " +  e.toString());
      JOptionPane.showMessageDialog(
          (Component) null, sError, "ERROR", JOptionPane.ERROR_MESSAGE);
    }

    return (bValue);
  }

  /** Method read()
   * <p> This method will read the IQSTRAT Login XML File that is on the User's
   *     PC for the Email and Password so the user does not have to enter the
   *     text every time they want to use the IQSTRAT Web Site.
   * @return stUser = The User Data Structure
   */

  public static kgsUserStruct read()
  {
    kgsUserStruct stUser = null; // User Data Structure

    String sDir  = getHomeDir();        // Retrieve the Home Directory Path
    String sPath = sDir+"\\"+USER_XML;  // Build Path to Login XML

    if (exists())
      stUser = getUser(kgs.io.ReadUsersXMLFile.FILE, sPath);

    return (stUser);
  }

  /** Method write()
   * <p> This method will write the User XML File to the User's PC.
   * @param stUser = The User Data Structure
   */

  public static void write(kgsUserStruct stUser)
  {
    String sDir = getHomeDir();  // Retrieve the Home Directory Path

    if (!stUser.sKEY.equals("0"))
    {
      WriteUsersXMLFile pXML = new WriteUsersXMLFile(sDir, USER_XML, stUser);
    }
  }
}