/*
 * @WriteUsersXMLFile.java Version 1.0 10/02/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package kgs.io;

import java.io.*;
import java.awt.*;

import util.utilFileIO;
import kgs.kgsUserStruct;

/** Class WriteUsersXMLFile
 *  <p> This class will create a XML File.
 *
 *  @version 1.1 10/02/2007
 *  @author  John R. Victorine
 */

public class WriteUsersXMLFile
{
   private int    iError = util.utilFileIO.NOERROR;
   private String sError = new String("");;
   private String DTD = new String(
     "<?xml version=\"1.0\"?>\n " +
     "<!DOCTYPE user [\n " +
     "<!ELEMENT user (data*)>\n " +
     "<!ATTLIST user records CDATA #REQUIRED>\n " +
     "<!ELEMENT data  EMPTY>\n " +
     "<!ATTLIST data key      CDATA #REQUIRED\n " +
     "               name     CDATA #IMPLIED\n " +
     "               company  CDATA #IMPLIED\n " +
     "               email    CDATA #IMPLIED\n " +
     "               account  CDATA #IMPLIED\n " +
     "               password CDATA #IMPLIED\n " +
     "               created  CDATA #IMPLIED\n " +
     "               error    CDATA #IMPLIED>]>\n ");

  /** Constructor WriteUsersXMLFile()
   *  <p> This is the constructor for this class
   *  @param sPath     = The Directory Path for the XML File
   *  @param sFilename = The Filename of the XML File.
   *  @param stData    = The User Information Data List Structure
   */

  public WriteUsersXMLFile(String sPath,
                           String sFilename,
                           kgsUserStruct stData)
  {
    String     sXML = new String(DTD);
    utilFileIO pIO  = new utilFileIO();

    pIO.Open(util.utilFileIO.DIRECTORY,
             util.utilFileIO.WRITE,
             sPath,
             sFilename);

    // Build the XML Block

    if (stData != null)
    {
      sXML = new String(sXML + "<user records=\"1\">");
      sXML = new String(sXML + "  <data key=\""      + stData.sKEY      +"\""+
                                      " name=\""     + stData.sName     +"\""+
                                      " company=\""  + stData.sCompany  +"\""+
                                      " email=\""    + stData.sEmail    +"\""+
                                      " account=\""  + stData.sAccount  +"\""+
                                      " password=\"" + stData.sPassword +"\""+
                                      " created=\""  + stData.sDate     +"\"/> ");

      sXML = new String(sXML + "</user>");
    }

    // Write the XML Block to the File

    pIO.Write(sXML);
    iError = pIO.getErrorID();
    sError = pIO.getError();

    // Close the File

    if (iError == util.utilFileIO.NOERROR)
      pIO.Close();
  }

  /* --------------------------------------------------------------- *
   * ------------------- ERROR HANDLING METHODS -------------------- *
   * --------------------------------------------------------------- */

  /** METHOD GetErrorID()
   *  <p> This method will return the error number.
   * @return iError = The Error Identifier
   */

  public int GetErrorID() { return (iError); }

  /** METHOD GetError()
   *  <p> This method will return the error string.
   * @return sError = The Error Text
   */

  public String GetError() { return (sError); }
}