/*
 * @kgsWellListTable.java Version 1.1 05/15/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package kgs.gui;

import java.awt.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.table.*;

import gui.guiTable;

import iqstrat.iqstratHeadersListStruct;
import iqstrat.iqstratHeadersStruct;

/** Class kgsWellListTable
 *  <p> This Class will display the Formation Tops.
 *
 *  @version 1.1 05/15/2008
 *  @author  John R. Victorine
 */

public class kgsWellListTable
{
  private int      iRows     = 0;
  private int      iColumns  = 11;
  private String   sColumn[] = {"LTCI",
                                "API-Number",
                                "Well Name",
                                "Operator",
                                "Field",
                                "Status",
                                "Latitude",
                                "Longitude",
                                "Town",
                                "Range",
                                "Sec"};
  private int     iColLength[] = { 4,  // "LTCI"
                                  12,  // "API Number
                                  26,  // "Well Name
                                  20,  // "Operator
                                  20,  // "Field
                                  10,  // "Status
                                   8,  // "Latitude
                                  10,  // "Longitude
                                   6,  // "Township
                                   6,  // "Range
                                   4}; // "Section
  private Object   oData[][] = null;
  private guiTable pTable    = null;

  private iqstratHeadersListStruct st      = null;
  private int                      iChange = 0;

  /** Constructor kgsWellListTable()
   *  <p> This is the Constructor for this class.
   */

  public kgsWellListTable()
  {
    pTable = new guiTable(0, iColumns, sColumn);
    resetColumnWidths();
    pTable.showHorScroll(true);
  }

  /** Constructor kgsWellListTable()
   *  <p> This is the Constructor for this class.
   * @param st     = The Headers List Data Structure
   */

  public kgsWellListTable(iqstratHeadersListStruct st)
  {
    this.st = st;

    populateList();

    if (iRows > 0)
      pTable = new guiTable(0, iRows, iColumns, sColumn, oData);
    else
      pTable = new guiTable(0, iColumns, sColumn);

    resetColumnWidths();
    pTable.showHorScroll(true);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /** Method resetColumnWidths()
   *  <p> This method will reset the column widths to a specific size.
   */

  private void resetColumnWidths()
  {
    for (int i=0; i<iColumns; i++)
    {
      pTable.resizeColumn(i, iColLength[i]);
    }
  }

  /** Method close()
   * <p> This method will set global variables to null in order to force
   *     Java to deallocate memory
   */

  public void close()
  {
    sColumn    = null;
    iColLength = null;
    oData      = null;
    pTable     = null;

    iqstratHeadersListStruct st = null;
  }

  /* ===================================================================== *
   * -------------------------- SET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method populateList()
   *  <p> This method will populate the Region List data.
   */

  private void populateList()
  {
    int i      = 0;
    int iCount = 0;
    String sTemp = "";

    iChange = 0;
    iRows   = 1;

    oData = new String[1][iColumns];
    for (i=0; i<iColumns; i++)
    {
      oData[0][i] = new String("");
    }

    if (st != null)
    {
      if (st.iCount > 0)
      {
        iChange = 1;
        iCount  = 0;
        oData   = new Object[st.iCount][iColumns];

//      st = iqstrat.iqstratHeadersUtility.bubbleSort(st);

        for (i=0; i<st.iCount; i++)
        {
          sTemp = new String("");
          if (st.stItem[i].iLAS > 0)
            sTemp = new String(sTemp+"L");
          else
            sTemp = new String(sTemp+"_");

          if (st.stItem[i].iTops > 0)
            sTemp = new String(sTemp+"T");
          else
            sTemp = new String(sTemp+"_");

          if (st.stItem[i].iCore > 0)
            sTemp = new String(sTemp+"C");
          else
            sTemp = new String(sTemp+"_");

          if (st.stItem[i].images > 0)
            sTemp = new String(sTemp+"I");
          else
            sTemp = new String(sTemp+"_");

          oData[iCount][0] = new String(sTemp);
          oData[iCount][1] = new String(st.stItem[i].sAPI);
          oData[iCount][2] = new String(st.stItem[i].sName);
          oData[iCount][3] = new String(st.stItem[i].sOperator);
          oData[iCount][4] = new String(st.stItem[i].sField);
          oData[iCount][5] = new String(st.stItem[i].status);
          oData[iCount][6] = new Double(st.stItem[i].dLatitude);
          oData[iCount][7] = new Double(st.stItem[i].dLongitude);
          oData[iCount][8] = new String("" + st.stItem[i].iTownship +
                                             st.stItem[i].sTownship);
          oData[iCount][9] = new String("" + st.stItem[i].iRange +
                                             st.stItem[i].sRange);
          oData[iCount][10] = new String("" + st.stItem[i].iSection);

          iCount++;
        }

        iRows = iCount;
      }
    }
  }

  /** Method repopulateList()
   *  <p> This method will reload the Region List after adding, deleting from
   *      the formation name list.
   * @param st     = The Regions List Data Structure
   */

  public void repopulateList(iqstratHeadersListStruct st)
  {
    this.st = st;

    populateList();

    pTable.reload(iRows, oData);

    if (iChange == 0)
      iRows = 0;

    if (iRows > 0)
      pTable.setSelectedRow(0);
  }

  /* ===================================================================== *
   * -------------------------- GET METHODS ------------------------------ *
   * ===================================================================== */

  /** Method getTotalRows()
   *  <p> This method will return the total rows in the table.
   *  @return Total Number of Rows.
   */

  public int getTotalRows() { return (iRows); }

  /** Method getRow()
   *  <p> This method will return the selected data id in the table.
   *  @return selected data id.
   */

  public int getRow() { return (pTable.getSelectedRow()); }

  /** Method getRowData()
   *  <p> This method will return the Region Data Structure of the
   *      selected row.
   *  @return stData = Region Data Structure.
   */

  public iqstratHeadersStruct getRowData()
  {
    iqstratHeadersStruct stData = null;

    stData = st.stItem[pTable.getSelectedRow()];

    return (stData);
  }

  /** Method getAllData()
   *  <p> This method will returns the Region List Data Structure.
   *  @return st = Region List Data Structure.
   */

  public iqstratHeadersListStruct getAllData() { return (st); }

  /** Method getScrollPane()
   *  <p> This method will return the scroll pane.
   *  @return jScrollPane - Scroll Pane containing the Table.
   */

  public JScrollPane getScrollPane() { return (pTable.getScrollPane()); }
}

/*
 *  @version 1.1 05/15/2008
 *  @author  John Victorine
 */
