/*
 * @iqstratTracksStruct.java Version 1.1 09/02/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

/** Class iqstratTracksStruct
 *  <p> This Class holds the Plot Tracks Data Structure.
 *
 *  @version 1.1 09/02/2007
 *  @author  John R. Victorine
 */

public class iqstratTracksStruct
{
  public static final int PLOT_TITLES  = 100; // Plot Titles
  public static final int DEPTH_TRACK  = 50;  // Depth Track Width
  public static final int LABELSTART   = 25;  // Label Start

  public static final int XPLOT_TITLES = 210; // Plot Titles
  public static final int XLABELSTART  = 135; // Label Start

  // Color Image Track Values

  // Resistivity/Porosity Track Macros

  public static final int _RT   = 0;
  public static final int _PHIT = 1;
  public static final int _GRT  = 2;

  // -- Porosity

  public static final int _PU  = 16;
  public static final int PU[][] =
  { {204, 255, 204},
    {153, 255, 153},
    {102, 255, 102},
    { 51, 255,  51},
    {  0, 255,   0},
    {  0, 255, 153},
    { 51, 204, 153},
    {  0, 204, 255},
    { 51, 153, 255},
    {  0, 153, 255},
    {  0, 102, 204},
    { 51, 102, 204},
    {102, 102, 204},
    {102,  51, 204},
    {102,  51, 102},
    { 51,   0,  51}};

  // -- Conductivity

  public static final int _MMHOS_M  = 16;
  public static final int MMHOS_M[][] =
  { {255, 255, 204},
    {255, 255, 102},
    {255, 255,  51},
    {255, 255,   0},
    {255, 204, 102},
    {255, 204,  51},
    {255, 204,   0},
    {255, 153,  51},
    {255, 153,   0},
    {204, 102,   0},
    {204, 102,  51},
    {153,  51,   0},
    {153,  51,  51},
    {102,  51,   0},
    {102,  51,  51},
    { 51,   0,   0} };

  // Depth Scale Plot Variables

  public static final int    SCALE_1   = 0;   //   1 Feet / Inch
  public static final int    SCALE_2   = 1;   //   2 Feet / Inch
  public static final int    SCALE_5   = 2;   //   5 Feet / Inch
  public static final int    SCALE_10  = 3;   //  10 Feet / Inch
  public static final int    SCALE_20  = 4;   //  20 Feet / Inch
  public static final int    SCALE_50  = 5;   //  50 Feet / Inch
  public static final int    SCALE_100 = 6;   // 100 Feet / Inch
  public static final int    SCALE_200 = 7;   // 200 Feet / Inch

  public static final int SCALE[] = { 1, 2, 5, 10, 20, 50, 100, 200 };

  // Lithology/Texture Depth Scale Variables

  public static final int    _SCALE_HALF_FOOT = 0; // each cell is 1/2 ft deep
  public static final int    _SCALE_1_FOOT    = 1; // each cell is 1 ft deep
  public static final int    _SCALE_2_FOOT    = 2;
  public static final int    _SCALE_5_FOOT    = 3;
  public static final int    _SCALE_10_FOOT   = 4;
  public static final int    _SCALE_20_FOOT   = 5;

  public static final int    _SCALE_HALF_INCH = 6; // each cell is 1/2 in deep
  public static final int    _SCALE_1_INCH    = 7; // each cell is 1 in deep
  public static final int    _SCALE_2_INCH    = 8; // each cell is 2 in deep
  public static final int    _SCALE_QUARTER_FOOT = 9; // each cell is 1/4 ft deep
  public static final int    _SCALE_10TH_FOOT = 10; // each cell is 1/10 ft deep

  public static final double _SCALE_FACTOR[] =
      { 2.0, 1.0, 0.5, 0.2, 0.1, 0.05, 24.0, 12.0, 6.0, 4.0,  10.0};
  public static final double _SCALE[] =
    // 0.5 ft  1 ft   2 ft   5 ft   10 ft   20 ft  0.5 in   1 in    2 in
      { .5,    1.0,   2.0,   5.0,   10.0,   20.0, .04167, .08333, .16667, .25, .1 };

  // By Datum

  public static final int _BY_ELEV  = 0;
  public static final int _BY_DATUM = 1;
  public static final int _BY_LOG   = 2;

  // Source Data Types

  public static final int _SRC_LAS      = 0;
  public static final int _SRC_ROCK     = 1;
  public static final int _SRC_TOPS     = 2;
  public static final int _SRC_PFEFFER  = 3;
  public static final int _SRC_BRINE    = 4;
  public static final int _SRC_BIO      = 5;
  public static final int _SRC_SS       = 6;
  public static final int _SRC_WAVELET  = 7;

  public static final int _SRC_ID       = 0;
  public static final int _SRC_COLUMN   = 1;

  public static final int TOTAL_SOURCES = 8;
  public static final String SOURCE[][] =
    {
     // SOURCE         Description
      { "LAS",     "Digital LAS File Curve Data" },
      { "ROCK",    "Rock Data" },
      { "TOPS",    "Horizons" },
      { "PfEFFER", "PfEFFER Data Tracks" },
      { "BRINE",   "Brine Data" },
      { "BIO",     "Bio Stratigraphy" },
      { "SS",      "Synthetic Seismic" },
      { "WAVE",    "Wavelet" },
    };

  public static final int COLORS[][] =  { { 204, 255, 153 },
                                          { 255, 204, 102 },
                                          { 204, 255, 255 },
                                          { 180, 200, 100 },
                                          { 221, 195, 200 },
                                          { 255, 140,   0 },
                                          {   0, 255, 100 },
                                          {   0, 255, 100 }};

  // Stratigraphic Track Types & Track Widths

  public static final String ICON = "ICON";

  public static final int TOTAL_TYPES = 19;
  public static final String TYPE[][] =
    {
    //   TYPE         Description                  Width
      { "LAS",     "LAS Plot Track Format",        "100" },
      { "LITH",    "Lithology Plot Track Format",   "25" },
      { "ROCK",    "Rock Lithology Column Format", "100" },
      { "PHI",     "Porosity Thin Track Format",    "30" },
      { "TOPS",    "Formation Tops Format",        "240" },
      { "STRAT",   "Formation Tops Format",        "300" },
      { "SEQ",     "Sequence Strat Format",         "25" },
      { "ENV",     "Depositional Environment",     "140" },
      { "GRAIN",   "Rock Texture",                 "140" },
      { "IMAGE",   "Rock Image Track Format",       "25" },
      { "ICON",    "Icon Image Track Format",      "150" },
      { "COLOR",   "Color Track Format",            "50" },
      { "DESC",    "Description Track Format",     "200" },
      { "TEXT",    "Abbreveation Track Format",     "50" },
      { "STRK",    "Lithology Streak Track Format", "20" },
      { "FLOW",    "PfEFFER Flow Units",           "100" },
      { "SS",      "Synthetic Seismic Plot Track Format","100" },
      { "WAVE",    "Wavelet Plot Track Format",    "100" },
      { "SIZE",    "Grainsize Track Format",        "80" },
    };

  // Colorlith Track Identifiers & Rock Column Identifiers

  public static final int _COLORLITH_RU   = 0; // RHOmaa-Umaa Colorlith
  public static final int _COLORLITH_PD   = 1; // Porosity Difference Colorlith
  public static final int _COLORLITH_SG   = 2; // Spectral Gamma Ray Colorlith
  public static final int _LITHOLOGY_LAS  = 3; // Lithology by LAS
  public static final int _LITHOLOGY_ROCK = 4; // Lithology by Rock
  public static final int _COLORLITH_RN   = 5; // RHOmaa-NPHI Colorlith
  public static final int _COLORLITH_RT   = 6; // RHOmaa-DTmaa Colorlith

  // Thin Porosity Track Identifiers

  public static final int _THIN_NPHI      = 0;
  public static final int _THIN_NPHI_DPHI = 1;
  public static final int _THIN_SPHI      = 2;
  public static final int _THIN_DPHI      = 3;

  // Track Group Descriptions

  public static final int TOTAL_TRACKS_DESC = 11;
  public static final String TRACKS_DESC[][] =
  {
    { "LAS",     "Standard LAS Curve Format"  },
    { "CL",      "Color Image Track Curve Format"  },
    { "IMG",     "Rock Image"  },
    { "ROCK",    "Measured Rock Data"  },
    { "COMP",    "Computed Rock Data"  },
    { "OBS",     "Observational Rock Data"  },
    { "TOPS",    "Horizons" },
    { "PfEFFER", "PfEFFER Data" },
    { "BRINE",   "Measured Brine Data"  },
    { "SS",      "Synthetic Seismic"  },
    { "WAVE",    "Wavelet" },
  };

  // Track Selection

  public static final int _SINGLE = 0;
  public static final int _DOUBLE = 1;

  // Available Stratigraphic Plot Tracks

  public static final int _NONE                  = -1;
  // Gamma Lithology Track
  public static final int _LITHOLOGY_GR          = 0;
  // LAS Like Plot Tracks
  // -- Digital LAS File Tracks
  // .. Reference
  public static final int _LAS_REFERENCE         = 1;
  // .. Resistivity Image Track
  public static final int _RESISTIVITY_IMAGER    = 2;
  public static final int _RESISTIVITY_IMAGER_N  = 3;
  // .. Resistivity
  public static final int _LAS_INDUCTION         = 4;
  public static final int _LAS_MICRO_RESISTIVITY = 5;
  public static final int _LAS_RESISTIVITY       = 6;
  public static final int _LAS_LATERLOG          = 7;
  public static final int _LAS_NORMAL            = 8;
  public static final int _LAS_AHT               = 9;
  // .. Conductivity
  public static final int _LAS_CONDUCTIVITY      = 10;
  // .. Porosity Image Track
  public static final int _POROSITY_IMAGER       = 11;
  public static final int _POROSITY_IMAGER_N     = 12;
  // .. Porosity
  public static final int _LAS_LITHO_DENSITY_3   = 13;
  public static final int _LAS_LITHO_DENSITY     = 14;
  public static final int _LAS_SONIC             = 15;
  // .. Temperature
  public static final int _LAS_TEMP              = 16;
  // .. Permeability
  public static final int _LAS_PERM              = 17;
  // .. Colorlith Spectral Gamma Ray
  public static final int _CLRLITH_SPGR          = 18;
  public static final int _CLRLITH_HALL          = 19;
  // .. Spectral Gamma Ray
  public static final int _LAS_SPECTRAL_GR       = 20;
  public static final int _LAS_SPECTRAL_RATIO    = 21;
  // .. Computed Data
  public static final int _LAS_RHOMAA_UMAA       = 22;
  public static final int _LAS_RHOMAA_NPHI       = 23;
  public static final int _LAS_RHOMAA_DTMAA      = 24;
  // .. Unknown Log Curves
  public static final int _LAS_LINEAR            = 25;
  public static final int _LAS_LOG               = 26;
  // .. Set Counts Limits
  public static final int _LAS_SET_GR_COUNTS     = 27;
  public static final int _LAS_SET_NEUT_COUNTS   = 28;
  // .. Colorlith
  public static final int _CLRLITH_RU            = 29;
  public static final int _CLRLITH_RN            = 30;
  public static final int _CLRLITH_RT            = 31;
  // .. Rock Lithology Columns
  public static final int _ROCK_COLUMN           = 32;
  public static final int _ROCK_COLUMN_PD        = 33;
  public static final int _ROCK_COLUMN_RT        = 34;
  // .. Porosity Thin track
  public static final int _THIN_PHI              = 35;
  // .. Rock Texture by LAS Curves
  public static final int _LAS_TEXTURE           = 36;
  // Synthetic Seismic Plot Tracks
  public static final int _SS_SEISMIC            = 37;
  public static final int _SS_ACOUSTIC_Z         = 38;
  public static final int _SS_ACOUSTIC_COLOR     = 39;
  public static final int _SS_REFLECTION_COEFF   = 40;
  public static final int _SS                    = 41;
  public static final int _SS_RICKER             = 42;
  // Wavelet Plot Track
  public static final int _WAVELETS              = 43;
  // PfEFFER Plot Tracks
  public static final int _PFEFFER_RESISTIVITY   = 44;
  public static final int _PFEFFER_POROSITY      = 45;
  public static final int _PFEFFER_2ND_POROSITY  = 46;
  public static final int _PFEFFER_POROSITY_OHM  = 47;
  public static final int _PFEFFER_OTHER         = 48;
  public static final int _PFEFFER_M             = 49;
  public static final int _PFEFFER_FLOW_UNITS    = 50;
  // Plot XY Data Colorlith FilterTrack
  public static final int _CLRLITH_XY            = 51;
  // Horizon Data Plot Tracks
  // -- Sequence Stratigraphy
  public static final int _SEQUENCE_STRAT        = 52;
  // -- Stratigraphic Units
  public static final int _STRAT_UNITS_A         = 53;
  // -- Depositional Environment
  public static final int _DEP_ENVIRONMENT       = 54;
  // Brine Data Plot Tracks
  // -- Brine Measured Data Tracks
  public static final int _BRINE_STIFF           = 55;
  public static final int _BRINE_COLLINS         = 56;
  public static final int _BRINE_PIPER           = 57;
  public static final int _BRINE_LAS_CATIONS     = 58;
  public static final int _BRINE_LAS_ANIONS      = 59;
  // Rock Data Plot Tracks
  // -- Rock Image Tracks
  public static final int _ROCK_BOX              = 60;
  public static final int _ROCK_SLAB             = 61;
  public static final int _ROCK_THINSECTION      = 62;
  public static final int _ROCK_SEM              = 63;
  public static final int _ROCK_IMG_OUTCROP      = 64;
  // -- Rock Measured Data Tracks
  // .. Measured Porosity Rock Data Tracks
  public static final int _ROCK_LAS_CORE_PHI     = 65;
  public static final int _ROCK_LAS_OUTCROP      = 66;
  // .. Measured Permeability Rock Data Tracks
  public static final int _ROCK_LAS_CORE_K       = 67;
  public static final int _ROCK_LAS_PLUG_K       = 68;
  // .. Measured Saturation Rock Data Tracks
  public static final int _ROCK_LAS_SATURATION   = 69;
  // .. Measured Archie Rock Data Tracks
  public static final int _ROCK_LAS_ARCHIE       = 70;
  // .. Measured Radioactive Rock Data Track
  public static final int _ROCK_LAS_GR           = 71;
  public static final int _ROCK_LAS_SPGR         = 72;
  // .. Unknown Log Curves
  public static final int _ROCK_LAS_LINEAR       = 73;
  public static final int _ROCK_LAS_LOG          = 74;
  // -- Rock Observational Data Tracks
  // .. Rock Color
  public static final int _ROCK_COLOR            = 75;
  // .. Rock Lithology Columns
  public static final int _ROCK_MEASURED_SECTION = 76;
  public static final int _ROCK_TEXTURE          = 77;
  public static final int _ROCK_GRAIN            = 78;
  // .. Sedimentary Structure
  public static final int _SED_STRUCTURE         = 79;
  // .. Fossils
  public static final int _ROCK_FOSSILS          = 80;
  // .. Bio Stratigraphy
  public static final int _BIO_STRATIGRAPHY      = 81;
  // .. Porosity Type Tracks
  public static final int _ROCK_THIN_PHI         = 82;
  public static final int _ROCK_POROSITY         = 83;
  // .. Comments & Remark
  public static final int _REMARKS               = 84;
  // TOTAL Plot Tracks
  public static final int TOTAL_TRACKS           = 85;

  // All Plot Tracks

  public static final int ALL_TRACKS_START       = _LITHOLOGY_GR;
  public static final int ALL_TRACKS_END         = _REMARKS;

  // LAS File Data Plot Tracks

  public static final int LAS_TRACKS_START       = _LITHOLOGY_GR;
  public static final int LAS_TRACKS_END         = _STRAT_UNITS_A;

  // BRINE Data Plot Tracks

  public static final int BRINE_TRACKS_START     = _BRINE_LAS_CATIONS;
  public static final int BRINE_TRACKS_END       = _STRAT_UNITS_A;

  // Rock Data Plot Tracks

  public static final int ROCK_TRACKS_START      = _SEQUENCE_STRAT;
  public static final int ROCK_TRACKS_END        = _REMARKS;

  // Horizons Only Data Plot Tracks

  public static final int TOPS_TRACKS_START      = _SEQUENCE_STRAT;
  public static final int TOPS_TRACKS_END        = _STRAT_UNITS_A;

  // PfEFFER Only Data Plot Tracks

  public static final int PFEFFER_TRACKS_START   = _PFEFFER_RESISTIVITY;
  public static final int PFEFFER_TRACKS_END     = _PFEFFER_FLOW_UNITS;

  public static final int _GROUP       = 0;
  public static final int _SOURCE      = 1;
  public static final int _TYPE        = 2;
  public static final int _DESCRIPTION = 3;
  public static final int _STATUS      = 4;

  public static final String TRACK[][] =
  {
   // GROUP   SOURCE  TYPE    Description
    // - Gamma Lithology Track
    { "CL",  "LAS",  "LITH",  "Lithology - Gamma Ray",                    "YES"},
    // -- Digital LAS File Tracks
    // .. Reference
    { "LAS",  "LAS",  "LAS",  "LAS - Reference - GR,SP,CAL Logs",         "YES"},
    // .. Resistivity Image Track
    { "CL",   "LAS",  "LITH", "Colorlith - Resistivity Imager",           "NO" },
    { "CL",   "LAS",  "LITH", "Colorlith - Resistivity Imager Nonlinear", "NO" },
    // .. Resistivity
    { "LAS",  "LAS",  "LAS",  "LAS - Induction Resistivity Logs",         "YES"},
    { "LAS",  "LAS",  "LAS",  "LAS - Micro Resistivity Logs",             "NO" },
    { "LAS",  "LAS",  "LAS",  "LAS - Resistivity Logs",                   "NO" },
    { "LAS",  "LAS",  "LAS",  "LAS - Laterlog Resistivity Logs",          "NO" },
    { "LAS",  "LAS",  "LAS",  "LAS - Normal Resistivity Logs",            "NO" },
    { "LAS",  "LAS",  "LAS",  "LAS - AHT Resistivity Logs",               "NO" },
    // .. Conductivity
    { "LAS",  "LAS",  "LAS",  "LAS - Conductivity Logs",                  "YES"},
    // .. Porosity Image Track
    { "CL",   "LAS",  "LITH", "Colorlith - Porosity Imager",              "NO" },
    { "CL",   "LAS",  "LITH", "Colorlith - Porosity Imager Nonlinear",    "NO" },
    // .. Porosity
    { "LAS",  "LAS",  "LAS",  "LAS - Litho-Density - PE, NPHI, DPHI",     "NO" },
    { "LAS",  "LAS",  "LAS",  "LAS - Litho-Density - NPHI,RHOB,PE Logs",  "YES"},
    { "LAS",  "LAS",  "LAS",  "LAS - Sonic - SPHI,DT Logs",               "NO" },
    // .. Temperature
    { "LAS",  "LAS",  "LAS",  "LAS - Temperature Logs",                   "NO" },
    // .. Permeability
    { "LAS",  "LAS",  "LAS",  "LAS - Permeability",                       "NO" },
    // .. Colorlith Spectral Gamma Ray
    { "CL",   "LAS",  "LITH", "Colorlith - Th/U - Th/K Track",            "NO" },
    { "CL",   "LAS",  "LITH", "Colorlith - Hall K-Th-U (RGB) Track",      "NO" },
    // .. Spectral Gamma Ray
    { "LAS",  "LAS",  "LAS",  "LAS - Spectral Gamma Ray - Th,U,K Logs",   "NO" },
    { "LAS",  "LAS",  "LAS",  "LAS - Spectral Gamma Ray Ratios",          "NO" },
    // .. Computed Data
    { "LAS",  "LAS",  "LAS",  "LAS - Rhomaa-Umaa Computed Curves",        "NO" },
    { "LAS",  "LAS",  "LAS",  "LAS - Rhomaa-NPHI Curves",                 "NO" },
    { "LAS",  "LAS",  "LAS",  "LAS - Rhomaa-DTmaa Curves",                "NO" },
    // .. Unknown Log Curves
    { "LAS",  "LAS",  "LAS",  "LAS - Unknown Curves - Linear Track",      "NO" },
    { "LAS",  "LAS",  "LAS",  "LAS - Unknown Curves - Log Track",         "NO" },
    // .. Set Count Limits for Conversion
    { "LAS",  "LAS",  "LAS",  "*** Gamma Ray Counts to GR (API) ***",     "NO" },
    { "LAS",  "LAS",  "LAS",  "*** Neutron Counts to NPHI (PU) ***",      "NO" },
    // .. Colorlith
    { "CL",   "LAS",  "LITH", "Colorlith - Rhomaa-Umaa Track",            "YES"},
    { "CL",   "LAS",  "LITH", "Colorlith - Rhomaa-NPHI Track",            "NO" },
    { "CL",   "LAS",  "LITH", "Colorlith - Rhomaa-DT Track",              "NO" },
    // .. Rock Lithology Columns
    { "CL",   "LAS",  "ROCK", "Lithology - Rhomaa-Umaa Track",            "YES"},
    { "CL",   "LAS",  "ROCK", "Lithology - Rhomaa-NPHI Track",            "YES" },
    { "CL",   "LAS",  "ROCK", "Lithology - Rhomaa-DTmaa Track",           "YES" },
    // .. Porosity Thin track
    { "CL",   "LAS",  "PHI",  "Thin Porosity Track",                      "YES"},
    // .. Rock Texture by LAS Curves
    { "CL",   "LAS",  "GRAIN","Texture - by Gamma Ray",                   "YES"},
    // .. Synthetic Seismic
    { "SS",  "SS",  "SS",   "SS - Sonic - DT Logs",                      "NO" },
    { "SS",  "SS",  "SS",   "SS - Acoustic Imedance",                    "NO" },
    { "SS",  "SS",  "SS",   "SS - Acoustic Imedance By Color",           "NO" },
    { "SS",  "SS",  "SS",   "SS - Reflection Coefficient",               "NO" },
    { "SS",  "SS",  "SS",   "SS - Synthetic Seismic",                    "NO" },
    { "SS",  "SS",  "SS",   "SS - Ricker Wavelet",                       "NO" },
    //     Wavelets Image Track
    { "WAVE", "WAVE", "WAVE", "Compute Wavelet Energy Spectrum",         "YES" },
   // PfEFFER Plot Tracks
    { "PfEFFER", "PfEFFER", "LAS", "PfEFFER - Resistivity",               "NO" },
    { "PfEFFER", "PfEFFER", "LAS", "PfEFFER - Porosity",                  "NO" },
    { "PfEFFER", "PfEFFER", "LAS", "PfEFFER - 2nd Porosity",              "NO" },
    { "PfEFFER", "PfEFFER", "LAS", "PfEFFER - Ohm Connect Porosity",      "NO" },
    { "PfEFFER", "PfEFFER", "LAS", "PfEFFER - Other",                     "NO" },
    { "PfEFFER", "PfEFFER", "LAS", "PfEFFER - Cementation",               "NO" },
    { "PfEFFER", "PfEFFER", "LAS", "PfEFFER - Flow Units",                "NO" },
    // Plot XY Data Colorlith FilterTrack
    { "CL",   "LAS",  "LITH", "Colorlith - XY Filter Track",              "YES"},
    // Horizon Data Plot Tracks
    // -- Sequence Stratigraphy
    { "TOPS", "TOPS", "SEQ",  "Horizons - Sequence Stratigraphy",         "NO" },
    // -- Stratigraphic Units
    { "TOPS", "TOPS", "STRAT","Horizons - Stratigraphic Units",           "YES" },
    // -- Sequence Stratigraphy
    { "TOPS", "TOPS", "ENV",  "Horizons - Depositional Environment",      "NO" },
    // Brine Data Plot Tracks
    // -- Brine Measured Data Tracks
    { "IMG",   "BRINE", "IMAGE", "Brine - Stiff Diagram",                 "YES" },
    { "IMG",   "BRINE", "IMAGE", "Brine - Collins Bar Diagram",           "YES" },
    { "IMG",   "BRINE", "IMAGE", "Brine - Piper Diagream",                "YES" },
    { "BRINE", "BRINE", "LAS",   "Data - Cations",                        "YES" },
    { "BRINE", "BRINE", "LAS",   "Data - Anions",                         "YES" },
    // Rock Data Plot Tracks
    // -- Rock Image Tracks
    { "IMG",  "ROCK", "IMAGE","Images - Core Box",                        "YES" },
    { "IMG",  "ROCK", "IMAGE","Images - Core Slab",                       "YES" },
    { "IMG",  "ROCK", "IMAGE","Images - Core Thin Section",               "YES" },
    { "IMG",  "ROCK", "IMAGE","Images - Core SEM",                        "YES" },
    { "IMG",  "ROCK", "IMAGE","Images - Outcrop Rock Sample",             "NO" },
    // -- Rock Measured Data Tracks
    // .. Gamma Lithology Track
    // .. Measured Porosity Rock Data Tracks
    { "ROCK", "ROCK", "LAS",  "Data - Core Density & Porosity",           "YES" },
    { "ROCK", "ROCK", "LAS",  "Data - Outcrop Measured Data",             "YES" },
    // .. Measured Permeability Rock Data Tracks
    { "ROCK", "ROCK", "LAS",  "Data - Whole Core Permeability",           "YES" },
    { "ROCK", "ROCK", "LAS",  "Data - Core Plug Permeability",            "YES" },
    // .. Measured Saturation Rock Data Tracks
    { "ROCK", "ROCK", "LAS",  "Data - Saturation",                        "YES" },
    // .. Measured Archie Rock Data Tracks
    { "ROCK", "ROCK", "LAS",  "Data - Archie Constants",                  "YES" },
    // .. Measured Radioactive Rock Data Tracks
    { "ROCK", "ROCK", "LAS",  "Data - Gamma Ray",                         "YES" },
    { "ROCK", "ROCK", "LAS",  "Data - Spectral Gamma Ray",                "YES" },
    // .. Unknown Log Curves
    { "ROCK", "ROCK", "LAS",  "Data - Linear Track",                      "NO" },
    { "ROCK", "ROCK", "LAS",  "Data - Log Track",                         "NO" },
    // .. Colorlith
    // -- Rock Observational Data Tracks
    // .. Rock Color
    { "OBS",  "ROCK", "COLOR","Color - Rock RGB Values",                  "YES"},
    // .. Rock Lithology Columns
    { "OBS",  "ROCK", "ROCK", "Lithology - Measured Sections",            "NO" },
    { "OBS",  "ROCK", "GRAIN","Lithology - Texture",                      "NO" },
    { "OBS",  "ROCK", "SIZE", "Lithology - Grainsize",                    "NO" },
    // .. Sedimentary Structure
    { "OBS",  "ROCK", "ICON", "Sedimentary Structures",                   "YES"},
    // .. Fossils
    { "OBS",  "ROCK", "ICON", "Fossils",                                  "YES"},
    // .. Bio Stratigraphy Fossils
    { "OBS",  "ROCK", "ICON", "Bio Stratigraphy Fossil Track",            "NO"},
    // .. Porosity Type Tracks
    { "OBS",  "ROCK", "PHI",  "Porosity Track",                           "YES"},
    { "OBS",  "ROCK", "PHI",  "Porosity Type",                            "YES"},
    // .. Comments & Remarks
    { "OBS",  "ROCK", "DESC", "Description",                              "YES"},
  };

  public static final int _GR   = las.lasStandardTools._GR;
  public static final int _CGR  = las.lasStandardTools._CGR;
  public static final int _SP   = las.lasStandardTools._SP;
  public static final int _CAL  = las.lasStandardTools._CAL;

  public static final int _PE   = las.lasStandardTools._PE;
  public static final int _RHOB = las.lasStandardTools._RHOB;
  public static final int _DPHI = las.lasStandardTools._DPHI;
  public static final int _DRHO = las.lasStandardTools._DRHO;
  public static final int _NPHI = las.lasStandardTools._NPHI;

  public static final int _DT   = las.lasStandardTools._DT;
  public static final int _SPHI = las.lasStandardTools._SPHI;

  public static final int _COND = las.lasStandardTools._COND;
  public static final int _CILD = las.lasStandardTools._CILD;
  public static final int _CILM = las.lasStandardTools._CILM;

  public static final int _RES   = las.lasStandardTools._RES;
  public static final int _RDEP  = las.lasStandardTools._RDEP;
  public static final int _RMED  = las.lasStandardTools._RMED;
  public static final int _RSHAL = las.lasStandardTools._RSHAL;

  public static final int _ILD   = las.lasStandardTools._ILD;
  public static final int _ILM   = las.lasStandardTools._ILM;
  public static final int _SFLU  = las.lasStandardTools._SFLU;

  public static final int _LL    = las.lasStandardTools._LL;
  public static final int _MLL   = las.lasStandardTools._MLL;
  public static final int _LL8   = las.lasStandardTools._LL8;

  public static final int _LN    = las.lasStandardTools._LN;
  public static final int _SN    = las.lasStandardTools._SN;

  public static final int _MNOR  = las.lasStandardTools._MNOR;
  public static final int _MSFL  = las.lasStandardTools._MSFL;
  public static final int _MINV  = las.lasStandardTools._MINV;

  public static final int _AHT10 = las.lasStandardTools._AHT10;
  public static final int _AHT20 = las.lasStandardTools._AHT20;
  public static final int _AHT30 = las.lasStandardTools._AHT30;
  public static final int _AHT60 = las.lasStandardTools._AHT60;
  public static final int _AHT90 = las.lasStandardTools._AHT90;

  public static final int _TH    = las.lasStandardTools._TH;
  public static final int _U     = las.lasStandardTools._U;
  public static final int _K     = las.lasStandardTools._K;

  public static final int _GRN   = las.lasStandardTools._GRN;
  public static final int _NEUT  = las.lasStandardTools._NEUT;

  public static final int _PERM  = las.lasStandardTools._PERM;

  public static final int _TEMP     = las.lasStandardTools._TEMP;
  public static final int _TEMPDIFF = las.lasStandardTools._TEMPDIFF;

  public static final int _LIN_1    = las.lasStandardTools._LIN_1;
  public static final int _LIN_2    = las.lasStandardTools._LIN_2;
  public static final int _LIN_3    = las.lasStandardTools._LIN_3;
  public static final int _LIN_4    = las.lasStandardTools._LIN_4;

  public static final int _LOG_1    = las.lasStandardTools._LOG_1;
  public static final int _LOG_2    = las.lasStandardTools._LOG_2;
  public static final int _LOG_3    = las.lasStandardTools._LOG_3;
  public static final int _LOG_4    = las.lasStandardTools._LOG_4;

  public static final int _RHOMAA  = las.lasStandardTools._RHOMAA;
  public static final int _UMAA    = las.lasStandardTools._UMAA;
  public static final int _PHIDIFF = las.lasStandardTools._PHIDIFF;
  public static final int _DTMAA   = las.lasStandardTools._DTMAA;

  public static final int _THU     = las.lasStandardTools._THU;
  public static final int _THK     = las.lasStandardTools._THK;

  public static final int _RT_LAS   = las.lasStandardTools._RT;
  public static final int _PHIT_LAS = las.lasStandardTools._PHIT;
  public static final int _GRT_LAS  = las.lasStandardTools._GRT;

  public static final int LAS_START       = _LAS_REFERENCE;
  public static final int LAS_TRACK_TOTAL = _LAS_SET_NEUT_COUNTS;

  public static final String LAS_TRACK_DESC[] = {
      "Reference",
      "",
      "",
      "Dual Induction",
      "Micro Resistivity",
      "Resistivity",
      "Laterlog",
      "Normal",
      "AHT Resistivity",
      "Conductivity",
      "",
      "",
      "Neutron/Density",
      "Litho-Density",
      "Sonic",
      "Temperature",
      "Permeability",
      "",
      "",
      "Spectral GR",
      "Spectral GR Ratio",
      "Rhomaa-Umaa",
      "Rhomaa-NPHI",
      "Rhomaa-DTmaa",
      "Linear Track",
      "Semilog Track",
      "MODIFY GR",
      "MODIFY NPHI"
  };

  public static final int LAS_TRACK[][] =
  {
    {_GR,    _SP,       _CGR,    _CAL,   -1},
    {-1,     -1,        -1,      -1,     -1},
    {-1,     -1,        -1,      -1,     -1},
    {_ILD,   _ILM,      _LL8,    _SFLU,  -1},
    {_MNOR,  _MSFL,     _MINV,   -1,     -1},
    {_RES,   _RDEP,     _RMED,   _RSHAL, -1},
    {_LL,    _MLL,      _LL8,    -1,     -1},
    {_LN,    _SN,       -1,      -1,     -1},
    {_AHT10, _AHT30,    _AHT60,  _AHT90, -1},
    {_COND,  _CILD,     _CILM,   -1,     -1},
    {-1,     -1,        -1,      -1,     -1},
    {-1,     -1,        -1,      -1,     -1},
    {_PE,    _NPHI,     _DPHI,   -1,     -1},
    {_PE,    _NPHI,     _RHOB,   _DPHI,  -1},
    {_SPHI,  _DT,       -1,      -1,     -1},
    {_TEMP,  _TEMPDIFF, -1,      -1,     -1},
    {_PERM,  -1,        -1,      -1,     -1},
    {-1,     -1,        -1,      -1,     -1},
    {-1,     -1,        -1,      -1,     -1},
    {_U,     _K,        _TH,     -1,     -1},
    {_THU,   _THK,      -1,      -1,     -1},
    {_RHOMAA,_UMAA,     -1,      -1,     -1},
    {_RHOMAA,_NPHI,     _PHIDIFF,-1,     -1},
    {_RHOMAA,_DTMAA,    -1,      -1,     -1},
    {_LIN_1, _LIN_2,    _LIN_3,  _LIN_4, -1},
    {_LOG_1, _LOG_2,    _LOG_3,  _LOG_4, -1},
    {_GR,    _GRN,      -1,      -1,     -1},
    {_NPHI,  _NEUT,     -1,      -1,     -1},
  };

  public static final int SS_START        = _SS_SEISMIC;
  public static final int SS_TRACK_TOTAL  = _SS;

  public static final int _DTa    = ss.ssStandardTools._DT;
  public static final int _AI_V   = ss.ssStandardTools._AI_V;
  public static final int _VRHOB  = ss.ssStandardTools._VRHOB;
  public static final int _VRHOma = ss.ssStandardTools._VRHOma;
  public static final int _Rc     = ss.ssStandardTools._Rc;
  public static final int _SSa    = ss.ssStandardTools._SS;
  public static final int _RK     = ss.ssStandardTools._RK;

  public static final String SS_TRACK_DESC[] = {
      "Sonic",
      "Acoustic Impedance",
      "Acoustic Impedance",
      "Reflection Coeff",
      "Synthetic Seismic",
      "Ricker Wavelet",
  };

  public static final int SS_TRACK[][] =
  {
    {_DTa,   -1,        -1,      -1,    -1},
    {_AI_V,  _VRHOB,    _VRHOma, -1,    -1},
    {_VRHOB, -1,        -1,      -1,    -1},
    {_Rc,    -1,        -1,      -1,    -1},
    {_SSa,   -1,        -1,      -1,    -1},
    {_RK,    -1,        -1,      -1,    -1},
  };

  public static final int _P_DEPTH = pfeffer.pfefferStandardTools._DEPTH;
  public static final int _P_THK   = pfeffer.pfefferStandardTools._THK;
  public static final int _P_RT    = pfeffer.pfefferStandardTools._RT;
  public static final int _P_PHIT  = pfeffer.pfefferStandardTools._PHIT;
  public static final int _P_VSH   = pfeffer.pfefferStandardTools._VSH;

  public static final int _P_PHI1  = pfeffer.pfefferStandardTools._PHI1;
  public static final int _P_PHI2  = pfeffer.pfefferStandardTools._PHI2;

  public static final int _P_RWA   = pfeffer.pfefferStandardTools._RWA;
  public static final int _P_RO    = pfeffer.pfefferStandardTools._RO;
  public static final int _P_M_    = pfeffer.pfefferStandardTools._M_;
  public static final int _P_MA    = pfeffer.pfefferStandardTools._MA;
  public static final int _P_SW    = pfeffer.pfefferStandardTools._SW;
  public static final int _P_BVW   = pfeffer.pfefferStandardTools._BVW;
  public static final int _P_PAY   = pfeffer.pfefferStandardTools._PAY;

  public static final int _P_PHIR  = pfeffer.pfefferStandardTools._PHIR;

  public static final int _P_PHIE  = pfeffer.pfefferStandardTools._PHIE;
  public static final int _P_CBW   = pfeffer.pfefferStandardTools._CBW;
  public static final int _P_BVH   = pfeffer.pfefferStandardTools._BVH;

  public static final int PFEFFER_START       = _PFEFFER_RESISTIVITY;
  public static final int PFEFFER_TRACK_TOTAL = _PFEFFER_OTHER;

  public static final String PFEFFER_DESC[] = {
      "Resistivity",
      "Porosity",
      "2nd Porosity",
      "Connected PHI",
      "Other",
      "Cementation"};

  public static final int PFEFFER_TRACK[][] =
  {
    {_P_RT,   _P_RWA,   _P_RO,   -1,     -1},
    {_P_PHIT, _P_BVW,   -1,      -1,     -1},
    {_P_PHIT, _P_PHI1,  _P_BVW,  -1,     -1},
    {_P_PHIT, _P_PHIR,  _P_BVW,  -1,     -1},
    {_P_SW,   _P_VSH,   _P_PAY,  -1,     -1},
    {_P_MA,   _P_M_,    -1,      -1,     -1}};

  public static final String BRINE_TRACK_DESC[] =
  {
    "Cations",
    "Anions"
  };

  public static final int BRINE_START       = _BRINE_LAS_CATIONS;
  public static final int BRINE_TRACK_TOTAL = _BRINE_LAS_ANIONS;

  public static final int _TOP      = rock.rockStandardTools._TOP;
  public static final int _BASE     = rock.rockStandardTools._BASE;
  public static final int _CORR     = rock.rockStandardTools._CORR;

  public static final int _STU      = rock.rockStandardTools._STU;
  public static final int _STN      = rock.rockStandardTools._STN;
  public static final int _ENV      = rock.rockStandardTools._ENV;
  public static final int _LITHO    = rock.rockStandardTools._LITHO;

  public static final int _PCORE    = rock.rockStandardTools._PCORE;
  public static final int _PPLUG    = rock.rockStandardTools._PPLUG;
  public static final int _P800     = rock.rockStandardTools._P800;
  public static final int _PINSI    = rock.rockStandardTools._PINSI;
  public static final int _PEFF     = rock.rockStandardTools._PEFF;

  public static final int _KMAX     = rock.rockStandardTools._KMAX;
  public static final int _K90      = rock.rockStandardTools._K90;
  public static final int _KVRT     = rock.rockStandardTools._KVRT;
  public static final int _KPLG     = rock.rockStandardTools._KPLG;
  public static final int _KKL      = rock.rockStandardTools._KKL;
  public static final int _KINSI    = rock.rockStandardTools._KINSI;
  public static final int _KKLIN    = rock.rockStandardTools._KKLIN;
  public static final int _KPVRT    = rock.rockStandardTools._KPVRT;

  public static final int _SOIL     = rock.rockStandardTools._SOIL;
  public static final int _SW       = rock.rockStandardTools._SW;

  public static final int _GMCC     = rock.rockStandardTools._GMCC;
  public static final int _RHOD     = rock.rockStandardTools._RHOD;
  public static final int _RHOW     = rock.rockStandardTools._RHOW;

  public static final int _MAMB     = rock.rockStandardTools._MAMB;
  public static final int _MINSI    = rock.rockStandardTools._MINSI;
  public static final int _NAMB     = rock.rockStandardTools._NAMB;
  public static final int _NINSI    = rock.rockStandardTools._NINSI;

  public static final int _LTHCD    = rock.rockStandardTools._LTHCD;
  public static final int _FRACTURE = rock.rockStandardTools._FRACTURE;

  public static final int _GR_R     = rock.rockStandardTools._GR;
  public static final int _CGR_R    = rock.rockStandardTools._CGR;
  public static final int _TH_R     = rock.rockStandardTools._TH;
  public static final int _U_R      = rock.rockStandardTools._U;
  public static final int _K_R      = rock.rockStandardTools._K;

  public static final int _LIN_1o   = rock.rockStandardTools._LIN_1;
  public static final int _LIN_2o   = rock.rockStandardTools._LIN_2;
  public static final int _LIN_3o   = rock.rockStandardTools._LIN_3;
  public static final int _LIN_4o   = rock.rockStandardTools._LIN_4;

  public static final int _LOG_1o   = rock.rockStandardTools._LOG_1;
  public static final int _LOG_2o   = rock.rockStandardTools._LOG_2;
  public static final int _LOG_3o   = rock.rockStandardTools._LOG_3;
  public static final int _LOG_4o   = rock.rockStandardTools._LOG_4;

  public static final String ROCK_TRACK_DESC[] =
  {
      "Porosity",
      "Density & Porosity",
      "Core Permeability",
      "Plug Permeability",
      "Saturation",
      "Archie Constants",
      "Gamma Ray",
      "Spectral GR",
      "Linear Track",
      "Semilog Track",
  };

  public static final int ROCK_START       = _ROCK_LAS_CORE_PHI;
  public static final int ROCK_TRACK_TOTAL = _ROCK_LAS_SPGR;
  public static final int ROCK_TRACK[][] =
  {
    {_GMCC,   _PCORE,  _PPLUG,  _P800,   _PINSI},
    {_PEFF,   _RHOD,   _RHOW,   -1,       -1},
    {_KMAX,   _K90,    _KVRT,   -1,       -1},
    {_KPLG,   _KKL,    _KINSI,  _KKLIN,  _KPVRT},
    {_SOIL,   _SW,     -1,      -1,       -1},
    {_MAMB,   _MINSI,  _NAMB,   _NINSI,   -1},
    {_GR_R,   _CGR_R,  -1,      -1,       -1},
    {_U_R,    _K_R,    _TH_R,   -1,       -1},
    {_LIN_1o, _LIN_2o, _LIN_3o, _LIN_4o,  -1},
    {_LOG_1o, _LOG_2o, _LOG_3o, _LOG_4o,  -1},
  };

  public static final double GAMMA_MAX  = 150.0;
  public static final double GAMMA_MIN  =   0.0;

  public static final double UMAA_MAX   = 13.8;
  public static final double UMAA_MIN   =  4.3;

  public static final double RHOMAA_MAX = 2.87;
  public static final double RHOMAA_MIN = 2.6;

  public static final double DTMAA_MAX  = 65.0;
  public static final double DTMAA_MIN  = 35.0;

  public static final double PHI_MAX    =  0.5;//0.3;
  public static final double PHI_MIN    =  0.0;

  public static final double DPHI_MAX   =  .08;
  public static final double DPHI_MIN   = -.08;

  public static final double THU_MAX    = 24.5;
  public static final double THU_MIN    =  0.57;

  public static final double THK_MAX    = 41.14;
  public static final double THK_MIN    =  1.02;

  public static final double U_MAX      = 30.0; // 0 to 40
  public static final double U_MIN      =  0.0;

  public static final double TH_MAX     = 20.0; // 0 to 30
  public static final double TH_MIN     =  0.0;

  public static final double K_MAX      = 5.0;  // 0 to 5
  public static final double K_MIN      = 0.0;

  public static final double MMHO_MIN   =    0.0;
  public static final double MMHO_MAX   = 2000.0;

  public static final double PHIT_MIN   = 0.0;
  public static final double PHIT_MAX   = 0.3;
}

/*
 *  @version 1.1 09/02/2007
 *  @author  John Victorine
 */

