/*
 * @iqstratStruct.java Version 1.1 09/01/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

import java.net.*;
import java.awt.*;
import java.applet.*;
//import java.awt.image.*;

import cmn.cmnStruct;

import horizon.strat.stratListStruct;
import horizon.bio.bioStratListStruct;

import lith.lithology.lithologySymbolsListStruct;

import mask.maskSymbolsListStruct;

import parse.parseMineralsListStruct;
import parse.parseTextureListStruct;
import parse.parseSedStructListStruct;
import parse.parseColorListStruct;
import parse.parseFossilListStruct;
import parse.parsePHIListStruct;
import parse.parseRockColumnSymbolsListStruct;
import parse.parseGrainsTextureListStruct;

//import parse.parseDepEnvListStruct;
import horizon.env.envListStruct;

import rock.color.rockColorChartListStruct;

/** Class iqstratStruct
 *  <p> This Class holds the IQSTRAT Viewer Global Data.
 *
 *  @version 1.1 09/01/2007
 *  @author  John R. Victorine
 */

public class iqstratStruct
{
  // Global Data Structure

  public cmnStruct stCMN = new cmnStruct();

  // Color Lith Web Page

  public static final String COLORLITH =
      "http://abyss.kgs.ku.edu/Gemini/colorlith/LithoDensityColorScale.html";

  // Global Variables

  // LAS 3.0 File Read Filter

  public boolean bLAS[]    = null;

  // Plot Type

  public String sPLOT = "2D";  // Default Plot Type

  // Save Directory and Name

  public String sDirectory = "";
  public String sName      = "";

  // Depth Range & Scale

  public double depthStart = 0.0; // Starting Depth of Plot
  public double depthEnd   = 0.0; // Ending Depth of Plot
  public double depthStep  = 0.0; // Step Depth if LAS File Data Structure is NULL
  public int    iScale     = 0;   // Profile Plot Scale Factor

  // Total Wells Selected

  public int    iWells     = 0;

  // Type of Data to collect

  public static final int  _WELL_DATA = 0; // Well Data, i.e. LAS Files, etc
  public static final int  _OUTCROP   = 1; // Outcrop Data

  public int iDataType = _WELL_DATA;       // Type of Data to process

  // Scale Factor for building Plot Cells for Lithology & Texture

  public int iUnit = iqstrat.iqstratTracksStruct._SCALE_HALF_FOOT;

  // Stratigraphic Units

  public stratListStruct            stICS   = null; // ICS Stratigraphic Units
  public stratListStruct            stKGS   = null; // KGS Stratigraphic Units

  public bioStratListStruct         stBio   = null; // Bio Stratigraphic Units
  public bioStratListStruct         stKSBio = null; // Kansas Bio Stratigraphic Units

  // Plot Symbols

  public lithologySymbolsListStruct stSymbols     = null; // Lithology
  public maskSymbolsListStruct      stPorosity    = null; // Porosity Type
  public maskSymbolsListStruct      stFossils     = null; // Fossil
  public maskSymbolsListStruct      stSedStruct   = null; // Sed Structure

  // Thesaurus Terms

  public envListStruct            stDepEnv         = null; // Depositional Environment

  public parseMineralsListStruct  stMinerals       = null; // Parse Minerals

  public parseTextureListStruct   stParseTexture   = null; // Parse Texture
  public parseFossilListStruct    stParseFossils   = null; // Parse Fossils
  public parseSedStructListStruct stParseSedStruct = null; // Parse Sed Struct
  public parseColorListStruct     stParseColors    = null; // Parse Colors
  public parsePHIListStruct       stParsePorosity  = null; // Parse Porosity Types

  public parseRockColumnSymbolsListStruct stParseRock  = null; // Parse Rock Column Data
  public parseGrainsTextureListStruct     stParseGrain = null; // Parse Grain Texture Data

  // Rock Color Charts

  public rockColorChartListStruct stRockColor      = null; // Rock Color Chart
  public rockColorChartListStruct stSoilColor      = null; // Soil Color Chart
}