/*
 * @iqstratStatusStruct.java Version 1.1 10/14/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

/** Class iqstratStatusStruct
 *  <p> This Class holds the data needed to plot the data location on a map
 *
 *  @version 1.1 10/14/2007
 *  @author  John R. Victorine
 */

public class iqstratStatusStruct
{
  public static final int  LOC             = 0;
  public static final int  INTENT          = 1;
  public static final int  DA              = 2;
  public static final int  SUSPEND         = 3;
  public static final int  PA              = 4;
  public static final int  EOR             = 5;
  public static final int  EOR_PA          = 6;
  public static final int  OIL             = 7;
  public static final int  DRY_OIL         = 8;
  public static final int  OIL_PA          = 9;
  public static final int  GAS             = 10;
  public static final int  DRY_GAS         = 11;
  public static final int  SUSPEND_GAS     = 12;
  public static final int  GAS_PA          = 13;
  public static final int  SUSPEND_OIL     = 14;
  public static final int  OG              = 15;
  public static final int  DRY_OIL_GAS     = 16;
  public static final int  OG_PA           = 17;
  public static final int  OTHER           = 18;
  public static final int  SUSPEND_OIL_GAS = 19;
  public static final int  OTHER_PA        = 20;
  public static final int  INJ             = 21;
  public static final int  INJ_PA          = 22;
  public static final int  SWD             = 23;
  public static final int  SWD_PA          = 24;
  public static final int  CBM             = 25;
  public static final int  CBM_PA          = 26;
  public static final int  OUTCROP         = 27;

  public static int    TOTAL      = 28;
  public static String STATUS[][] =
    {{ "LOC",       "Location" },
     { "INTENT",    "Intent" },
     { "D&A",       "Dry & Abandoned" },
     { "SUS",       "Suspended" },
     { "P&A",       "Plugged & Abandoned" },
     { "EOR",       "Enhanced Oil Recovery" },
     { "EOR-P&A",   "Enhanced Oil Recovery - Plugged & Abandoned" },
     { "OIL",       "Oil" },
     { "D&A-O",     "Dry & Abandoned - Oil Show" },
     { "SUS-O",     "Suspended - Oil" },
     { "OIL-P&A",   "Oil - Plugged & Abandoned" },
     { "GAS",       "Gas" },
     { "D&A-G",     "Dry & Abandoned - Gas Show" },
     { "SUS-G",     "Suspended - Gas" },
     { "GAS-P&A",   "Gas - Plugged & Abandoned" },
     { "O&G",       "Oil & Gas" },
     { "D&A-OG",    "Dry & Abandoned - Oil & Gas Show" },
     { "SUS-OG",    "Suspended - Oil & Gas" },
     { "O&G-P&A",   "Oil & Gas - Plugged & Abandoned" },
     { "OTHER",     "Other" },
     { "OTHER-P&A", "Other - Plugged & Abandoned" },
     { "INJ",       "Injection" },
     { "INJ-P&A",   "Injection - Plugged & Abandoned" },
     { "SWD",       "Salt Water Disposal" },
     { "SWD-P&A",   "Salt Water Disposal - Plugged & Abandoned" },
     { "CBM",       "Coal Bed Methane" },
     { "CBM-P&A",   "Coal Bed Methane - Plugged & Abandoned" },
     { "OUTCROP",   "Measured Section"}};
}
