/*
 * @iqstratShaleStruct.java Version 1.0 10/05/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

/** CLASS iqstratShaleStruct
 *  <p> This Structure holds the Headers Information for a single Well.
 *
 *  @version 1.1 10/05/2007
 *  @author  John R. Victorine
 */

public class iqstratShaleStruct
{
  // Global Static variables

  public static final double GAMMA_MIN =   0.0;
  public static final double SHALY     =  60.0;
  public static final double SHALE     =  70.0;
  public static final double SHALE_HOT = 100.0;
  public static final double GAMMA_MAX = 150.0;

  public String sKEY       = "0";

  public double depthStart = 0.0;    // Starting Depth
  public double depthEnd   = 0.0;    // Ending Depth

  public double dGammaMin  = GAMMA_MIN;  // Minimum Gamma Ray Value
  public double dShaly     = SHALY;      // Start of Shaly Formation
  public double dShale     = SHALE;      // Start of Shale Formation
  public double dHotShale  = SHALE_HOT;  // Start of Hot Shale Formation
  public double dGammaMax  = GAMMA_MAX;  // Maximum  Gamma Ray Value

  /** Method delete()
   * <p> This method will try to force Java to deallocate memory
   */

  public void delete() { sKEY = null; }
}