/*
 * @iqstratShaleStandardTools.java Version 1.1 04/16/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

/** Class iqstratShaleStandardTools
 *  <p> This Class holds the standard tool information to map the Fossils
 *      LAS File curves to standard names.
 */

public class iqstratShaleStandardTools
{
  public static final int _SHFT  = 0;  // Top Depth
  public static final int _SHFB  = 1;  // Bottom Depth
  public static final int _SHMIN = 2;  // Gamma Ray Minimum Value (Default)
  public static final int _SHLY  = 3;  // Gamma Ray Shaly Value (Default)
  public static final int _SH    = 4;  // Gamma Ray Shale Value (Default)
  public static final int _SHHOT = 5;  // Gamma Ray Hot Shale Value (Default)
  public static final int _SHMAX = 6;  // Gamma Ray Maximum Value (Default)
  public static final int TOTAL  = 7;  // Total

  public static final int _C_ID   = 0;
  public static final int _C_MNEM = 1;
  public static final int _C_NAME = 2;
  public static final int _C_UNIT = 3;
  public static final int _C_FORM = 4;

  public static final String CURVES[][] =
  {
    // ID     MNEMONIC  CURVE NAME                 UNIT  FORMAT
    { "1100", "SHFT",  "Top Depth",                 "F",   "F" },
    { "1200", "SHFB",  "Bottom Depth",              "F",   "F" },
    { "2000", "SHMIN", "Gamma Ray Minimum Value",   "API", "F" },
    { "2100", "SHLY",  "Gamma Ray Shaly Value",     "API", "F" },
    { "2200", "SH",    "Gamma Ray Shale Value",     "API", "F" },
    { "2300", "SHHOT", "Gamma Ray Hot Shale Value", "API", "F" },
    { "2400", "SHMAX", "Gamma Ray Maximum Value",   "API", "F" },
  };

  /** Method isCurve()
   * <p> This method will determine if the curve is part of the standard
   *     stratigraphic units curves from the LAS File.
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return bValue  = true it is a valid curve, false it is not
   */

  public static boolean isCurve( int iColumn, String str )
  {
    boolean bValue = false;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method getRow()
   * <p> This method will return the row number of the Stratigraphic Unit Curve
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return iRow = row number
   */

  public static int getRow( int iColumn, String str )
  {
    int iRow = -1;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        iRow = i;
      }
    }

    return (iRow);
  }
}