/*
 * @iqstratShaleListStruct.java Version 1.1 10/28/2003
 *
 * Copyright (c) 2003 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

import iqstrat.iqstratShaleStruct;

/** CLASS iqstratShaleListStruct
 *  <p> This Structure holds a list of Headers Information Structures.
 *
 *  @version 1.1 10/28/2003
 *  @author  John R. Victorine
 */

public class iqstratShaleListStruct
{
  // Stratigraphic Headers Data Information

  public String sKID       = "0";  // Primary Key of the Well
  public String sKEY       = "";   // Primary Key created on user's PC
  public int    iType      = iqstrat.iqstratHeadersStruct.WELL; // Type of Data
  public String sAPI       = "";   // API-Number OR UWI
  public String sName      = "";   // Well Name or Outcrop Name
  public String status     = iqstrat.iqstratStatusStruct.STATUS[0][0]; // Status
  public double dLatitude  = 0.0;  // Latitude of Location
  public double dLongitude = 0.0;  // Longitude of Location
  public double depth      = 0.0;  // Total Depth of Well or Height of Outcrop
  public double dGL        = 0.0;  // Ground Level

  public String sKGS       = "YES"; // KGS Saved Data Indicator

  public int                  iCount = 0;    // Total Number of Records
  public iqstratShaleStruct stItem[] = null; // Array of Headers Structures

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    sKID   = null; // Primary Key of the Well
    sKEY   = null; // Primary Key created on user's PC
    sAPI   = null; // API-Number OR UWI
    sName  = null; // Well Name or Outcrop Name
    status = null; // Status

    sKGS   = null; // KGS Saved Data Indicator

    if (iCount > 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (stItem[i] != null)
          stItem[i].delete();
      }
    }

    iCount = 0;
    stItem = null;
  }
}
