/*
 * @iqstratRemarkStruct.java Version 1.1 09/25/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

/** Class iqstratRemarkStruct
 *  <p> This Class holds the Remarks Depth Data.
 *
 *  @version 1.1 09/25/2007
 *  @author  John R. Victorine
 */

public class iqstratRemarkStruct
{
  public String sKEY        = "0";  // Identifier
  public double depthStart  = 0.0;  // Starting Depth
  public double depthEnd    = 0.0;  // Ending Depth
  public double dThickness  = 0.0;  // Thickness
  public String sNote       = "";   // Brief Note
  public String sText       = "";   // Remarks at that depth

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sKEY  = null;
    sNote = null;
    sText = null;
  }
}