/*
 * @iqstratRemarkStandardTools.java Version 1.1 04/05/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

/** Class iqstratRemarkStandardTools
 *  <p> This Class holds the standard tool information to map the Remarks
 *      LAS File curves to standard names.
 */

public class iqstratRemarkStandardTools
{
  public static final int _GEOTOP   = 0;  // Top Depth     {F}
  public static final int _GEOBASE  = 1;  // Bottom Depth  {F}
  public static final int _GEOBED   = 2;  // Bed Thickness {F}
  public static final int _GEODES   = 3;  // Description
  public static final int TOTAL     = 4;  // Total

  public static final int _C_ID   = 0;
  public static final int _C_MNEM = 1;
  public static final int _C_NAME = 2;
  public static final int _C_UNIT = 3;

  public static final String CURVES[][] =
  {
    // ID     MNEMONIC  CURVE NAME                                 UNIT
    { "1100", "GEOTOP",  "Remarks/Comments/Notes Top Depth",       "F" },
    { "1200", "GEOBASE", "Remarks/Comments/Notes Bottom Depth",    "F" },
    { "1300", "GEOBED",  "Bed Thickness",                          "F" },
    { "1400", "GEODES",  "DESCRIPTION",                            ""  },
  };


  /** Method isCurve()
   * <p> This method will determine if the curve is part of the standard
   *     stratigraphic units curves from the LAS File.
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return bValue  = true it is a valid curve, false it is not
   */

  public static boolean isCurve( int iColumn, String str )
  {
    boolean bValue = false;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method getRow()
   * <p> This method will return the row number of the Stratigraphic Unit Curve
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return iRow = row number
   */

  public static int getRow( int iColumn, String str )
  {
    int iRow = -1;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        iRow = i;
      }
    }

    return (iRow);
  }
}