/*
 * @iqstratRemarkListStruct.java Version 1.1 09/25/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

import iqstrat.iqstratRemarkStruct;

/** Class iqstratRemarkListStruct
 *  <p> This Class holds the Remarks Depth Data.
 *
 *  @version 1.1 09/25/2007
 *  @author  John R. Victorine
 */

public class iqstratRemarkListStruct
{
  public int    iSource    = las3.las3Constants._SOURCE_NONE;

  // Stratigraphic Headers Data Information

  public String sKID       = "0";  // Primary Key of the Well
  public String sKEY       = "";   // Primary Key created on user's PC
  public int    iType      = iqstrat.iqstratHeadersStruct.WELL; // Type of Data
  public String sAPI       = "";   // API-Number OR UWI
  public String sName      = "";   // Well Name or Outcrop Name
  public String status     = iqstrat.iqstratStatusStruct.STATUS[0][0]; // Status
  public double dLatitude  = 0.0;  // Latitude of Location
  public double dLongitude = 0.0;  // Longitude of Location
  public double depth      = 0.0;  // Total Depth of Well or Height of Outcrop
  public double dGL        = 0.0;  // Ground Level

  public int                 iCount   = 0;     // Total Number of Records
  public iqstratRemarkStruct stItem[] = null;  // Remarks List

  // LAS 3 Control Parameter

  public String sKGS       = "YES"; // KGS Saved Data Indicator
  public double depthStart = 0.0;   // Starting Depth
  public double depthEnd   = 0.0;   // Ending Depth
  public String source     = "";    // Source of Data
  public String sRef       = "";    // Depth Reference

  /** Method delete()
   * <p> This method will set the arrays to null in order to get Java to
   *     deallocate memory for the object.
   */

  public void delete()
  {
    sKID   = null; // Primary Key of the Well
    sKEY   = null; // Primary Key created on user's PC
    sAPI   = null; // API-Number OR UWI
    sName  = null; // Well Name or Outcrop Name
    status = null; // Status

    source = null; // Source of Data
    sRef   = null; // Depth Reference

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }
  }
}
