/*
 * @iqstratHeadersStruct.java Version 1.0 10/05/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

/** CLASS iqstratHeadersStruct
 *  <p> This Structure holds the Headers Information for a single Well.
 *
 *  @version 1.1 10/05/2007
 *  @author  John R. Victorine
 */

public class iqstratHeadersStruct
{
  public static final int WELL    = 0;  // Oil & Gas Well Data
  public static final int OUTCROP = 1;  // Outcrop or Stream cut Data

  public static final String HEADER_TYPE[] = {"WELL", "OUTCROP"};

  // Identifier for access to data

  public static final int USER_ONLY   = 0;
  public static final int GROUP_READ  = 1;
  public static final int GROUP_WRITE = 2;

  // Identification Information

  public String sKID          = "0";  // DB Primary Key of the Header Record
  public String sWELLKID      = "0";  // KGS Table Primary Key of the Well
  public String sKEY          = "";   // Primary Key created on user's PC
  public int    iType         = WELL; // Type of Data
  public String sAPI          = "";   // API-Number
  public String sUWI          = "";   // UWI
  public String sName         = "";   // Well Name or Outcrop Name
  public String status        = iqstrat.iqstratStatusStruct.STATUS[0][0]; // Status
  public String sError        = "";

  // other well information

  public String service       = "";  // Service Company
  public String sLicense      = "";  // License

  public String sOperator     = "";  // Operator
  public String sOperator_kid = "0"; // Operator Primary Key
  public String sField        = "";  // Field Name
  public String sField_kid    = "0"; // Field Primary Key

  // Location Information

  public String sCountry      = "";   // Country
  public String sProvince     = "";   // Province

  public String state         = "";   // State Name
  public int    iState        = -1;   // State Code
  public String sCounty       = "";   // County Name
  public int    iCounty       = -1;   // County Code

  public String sLocation     = new String(""); // location of outcrop or stream cut
  public String sLocation1    = new String(""); // location 1
  public String sLocation2    = new String(""); // location 2

  public int    iTownship     = 0;    // Township
  public String sTownship     = "";   // Township Direction
  public int    iRange        = 0;    // Range
  public String sRange        = "";   // Range Direction
  public int    iSection      = 0;    // Section

  // XY Position Information

  public double dLatitude     = 0.0;   // Latitude of Location
  public double dLongitude    = 0.0;   // Longitude of Location
  public double dZone         = 0.0;   // UTM Zone
  public double dUTMx         = 0.0;   // UTM X-Position
  public double dUTMy         = 0.0;   // UTM Y-Position

  public String sGDAT         = "";    // Geodetic Datum
  public String sHZCS         = "";    // Horizontal Co-ordinate System

  // Z Position - Depth, Elevation

  public double depth         = 0.0;   // Total Depth of Well or Height of Outcrop
  public double dGL           = 0.0;   // Ground Level
  public double dDF           = 0.0;   // Derrick Floor
  public double dKB           = 0.0;   // Kelly Bushing
  public double dRT           = 0.0;   // Rotary Table

//  public double dTDD       = 0.0;   // Drillers Depth
//  public double dTLD       = 0.0;   // Loggers Depth

  // LAS 3 Variables

//  public String sPDAT      = "";    // Permanent Data
//  public double dAPD       = 0.0;   // Above Permanent Data
//  public String sDREF      = "";    // Depth Reference (KB,DF,CB)
//  public double dElevation = 0.0;   // "Elevation of Depth Reference"

  // Miscellaneous Fields

  public String sUpdate       = "";        // update by
  public String source        = "";        // source of data
  public int    iAccess       = USER_ONLY; // Access to data
  public String sDate         = "";        // update date
  public String sComments     = "";        // general comments

  // Available Data (Only used for KGS Data)

  public int    iLAS          = 0; // Number of LAS Files
  public int    iTops         = 0; // Number of Tops
  public int    iCore         = 0; // Number of Core Data
  public int    images        = 0; // Number of images
  public int    iPerf         = 0; // Number of Perforations
  public int    iDST          = 0; // Number of DST Records
  public int    iPfeffer      = 0; // Number of Pfeffer Records
  public int    iGeo          = 0; // Number of Geo Report Records

  public int    iOHM          = 0; // Resistivity Log Data Exists
  public int    iLitho        = 0; // Litho-Density Log Data Exists
  public int    iNPHI         = 0; // Neutron Porosity Log Data Exists
  public int    iRHOB         = 0; // Bulk Density Log Data Exists
  public int    iPE           = 0; // Photoelectric Factor Log Data Exists
  public int    iSonic        = 0; // Sonic Log Data Exists
  public int    iGR           = 0; // Gamma Ray Log Data Exists
  public int    iSPGR         = 0; // Spectral Gamma Ray Log Data Exists

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    // Identification Information

    sKID          = null;   // Primary Key
    sWELLKID      = null;   // KGS Well Headers Table Primary Key
    sKEY          = null;   // Primary Key created by user
    sAPI          = null;   // API-Number
    sUWI          = null;   // UWI
    sName         = null;   // Well Name or Outcrop Name
    status        = null;   // Status of well or Outcrop Type
    sError        = null;   // Error String

    // other well information

    service       = null;  // Service Company
    sLicense      = null;  // License

    sOperator     = null;  // Operator
    sOperator_kid = null;  // Operator Primary Key
    sField        = null;  // Field Name
    sField_kid    = null;  // Field Primary Key

    // Location Information

    sCountry      = null;  // Country
    sProvince     = null;  // Province

    state         = null;  // State Name
    sCounty       = null;  // County Name
    sLocation     = null;  // location of outcrop or stream cut
    sLocation1    = null;  // location 1
    sLocation2    = null;  // location 2
    sTownship     = null;  // township direction
    sRange        = null;  //  range direction

    // XY Position Information

    sGDAT         = null;  // Geodetic Datum
    sHZCS         = null;  // Horizontal Co-ordinate System

    // Z Position - Depth, Elevation

//    sPDAT      = null;   // Permanent Data
//    sDREF      = null;   // Depth Reference (KB,DF,CB)

    // Miscellaneous Fields

    sDate         = null;  // Date Logged
    sUpdate       = null;  // update by
    source        = null;  // Source of Data
    sComments     = null;  // general comments
  }
}
