/*
 * @iqstratHeadersListStruct.java Version 1.1 10/05/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

import iqstrat.iqstratHeadersStruct;

/** CLASS iqstratHeadersListStruct
 *  <p> This Structure holds a list of Headers Information Structures.
 *
 *  @version 1.1 10/05/2007
 *  @author  John R. Victorine
 */

public class iqstratHeadersListStruct
{
  public int                  iCount   = 0;    // Total Number of Records
  public iqstratHeadersStruct stItem[] = null; // Array of Headers Structures

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    if (iCount > 0)
    {
      for (int i=0; i<iCount; i++)
      {
        if (stItem[i] != null)
          stItem[i].delete();
      }
    }

    iCount = 0;
    stItem = null;
  }
}
