/*
 * @iqstratFilesStruct.java Version 1.0 12/12/2007
 *
 * Copyright (c) 2007 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

/** CLASS iqstratFilesStruct
 *  <p> This Structure holds the File Information for a single File.
 *
 *  @version 1.1 12/12/2007
 *  @author  John R. Victorine
 */

public class iqstratFilesStruct
{
  public String sKEY      = "0";     // Primary Key of File Record
  public String sUser     = "0";     // Primary Key of User
  public String sHeader   = "0";     // Primary Key for User Headers Data

  public String sType     = "";      // Type of Data, i.e. LAS, LITHOLOGY, etc.
  public String sFile     = "";      // Type of File, i.e. XML, CSV, etc.

  public String sURL      = "";      // Base URL Path to File
  public String sPath     = "";      // Directory Path to File
  public String sFilename = "";      // Filename of File

  /** Method delete()
   * <p> This method will set the string variable to null and initialize all the
   *     other variables.
   */

  public void delete()
  {
    sKEY      = null;     // Primary Key of File Record
    sUser     = null;     // Primary Key of User
    sHeader   = null;     // Primary Key for User Headers Data

    sType     = null;      // Type of Data, i.e. LAS, LITHOLOGY, etc.
    sFile     = null;      // Type of File, i.e. XML, CSV, etc.

    sURL      = null;      // Base URL Path to File
    sPath     = null;      // Directory Path to File
    sFilename = null;      // Filename of File
  }
}
