/*
 * @iqstratControlStruct.java Version 1.0 02/04/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

import iqstrat.iqstratHeadersStruct;

/** CLASS iqstratControlStruct
 *  <p> This Structure holds the cross section control dialog settings.
 *
 *  @version 1.1 02/04/2009
 *  @author  John R. Victorine
 */

public class iqstratControlStruct
{
  // LAS 3 Control Parameter

  public String sKGS       = "YES"; // KGS Saved Data Indicator

  // Default Depth Range Settings

  public static final int    _NONE = -1;
  public static final int    _LAS  =  0;
  public static final int    _TOPS =  1;
  public static final int    _ROCK =  2;

  // Depth Range Data

  public double depthStart = 0.0;  // Starting Depth of Plot (at Elevation)
  public double depthEnd   = 0.0;  // Ending Depth of Plot (at Elevation)
  public int    iScale     = iqstrat.iqstratTracksStruct.SCALE_100;

  // Well Plot Data Tracks

  public static final int _DEFAULT_ORDER = 0;
  public static final int _MODIFY_ORDER  = 1;

  public int   iPanel     = _DEFAULT_ORDER;

  public static final int _C_ALL          = 0;
  public static final int _C_LAS          = 1;
  public static final int _C_CORE         = 2;
  public static final int _C_HORIZON      = 3;
  public static final int _C_USER_DEFINED = 4;
  public static final int _C_PFEFFER      = 5;
  public static final int _C_TOTAL        = 6;

  public int   iConfig    = _C_ALL;

  public int   iCount     = 0;     // Number of Selected Tracks for Read Only
  public int   iTracks[]  = null;  // Selected Tracks

  // Well Information

  public iqstratHeadersStruct stHeader = null;

  // Specicfic Track Control Variables

  public static final int _NO  = 0;
  public static final int _YES = 1;

  // -- Porosity Thin Track

  public int    iThin    = _NO;
  public int    iTHINPHI = iqstrat.iqstratTracksStruct._THIN_NPHI;

  // -- Porosity Image Track

  public int    iPHI     = _NO;
  public double dPHIMin  = 0.0;
  public double dPHIMax  = 0.3;
  public int    iPHITool = las.lasStandardTools._NPHI;

  // -- Resistivity Image Track

  public int    iOHM     = _NO;
  public double dOHMMin  = 0.0;
  public double dOHMMax  = 500.0;
  public int    iOHMTool = las.lasStandardTools._ILD;

  // Data Conversion Variables

  // -- Gamma Ray Counts to Gamma Ray API

  public double dGRNMin    = 0.0;   // Minimum Gamma Ray Counts Value
  public double dGRNMax    = 100.0; // Maximum Gamma Ray Counts Value

  public double dGRCMin    = 0.0;   // Minimum Computation Value
  public double dGRCMax    = 150.0; // Maximum Computation Value

  // -- Neutron Counts to Neutron Porosity

  public double dNEUTMin   = 0.0;   // Minimum Neutron Counts Value
  public double dNEUTMax   = 100.0; // Maximum Neutron Counts Value

  public double dNPHICMin  = 0.01;  // Minimum Computation Value
  public double dNPHICMax  = 0.4;   // Maximum Computation Value

  /** Method delete()
   * <p> This method will set data to null to force Java to deallocate memory
   */

  public void delete()
  {
    // LAS 3 Control Parameter

    sKGS    = null; // KGS Saved Data Indicator

    // Well Plot Data Tracks

    iTracks = null; // Selected Tracks

    // Well Information

    if (stHeader != null)
      stHeader.delete();
    stHeader = null;
  }
}