/*
 * @iqstratControlStandardTools.java Version 1.1 02/12/2010
 *
 * Copyright (c) 2010 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

/** Class iqstratControlStandardTools
 *  <p> This Class holds the standard tool information to map the Stratigraphic
 *      LAS File curves to standard names.
 */

public class iqstratControlStandardTools
{
  public static final int _IQ_SRC   = 0; // Data Source (LAS, TOPS, ROCK)
  public static final int _IQ_TYPE  = 1; // Type of Track Data
  public static final int _IQ_DESC  = 2; // Track Description
  public static final int TOTAL     = 3; // Total

  public static final int _C_ID     = 0;
  public static final int _C_MNEM   = 1;
  public static final int _C_NAME   = 2;
  public static final int _C_FORMAT = 3;

  public static final String CURVES[][] =
  {
    // ID     MNEMONIC  CURVE NAME                         FORMAT
    { "1000", "IQ_SRC",   "Data Source (LAS, TOPS, ROCK)",   "S" },
    { "1100", "IQ_TYPE",  "Type of Track Data",              "S" },
    { "1200", "IQ_DESC",  "Track Description",               "S" },
  };

  /** Method isCurve()
   * <p> This method will determine if the curve is part of the standard
   *     stratigraphic units curves from the LAS File.
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return bValue  = true it is a valid curve, false it is not
   */

  public static boolean isCurve( int iColumn, String str )
  {
    boolean bValue = false;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        bValue = true;
      }
    }

    return (bValue);
  }

  /** Method getRow()
   * <p> This method will return the row number of the Stratigraphic Unit Curve
   * @param  iColumn = The column number
   * @param  str     = the string being compared.
   * @return iRow = row number
   */

  public static int getRow( int iColumn, String str )
  {
    int iRow = -1;

    if (iColumn==1) str = new String( str.toUpperCase() );

    for (int i=0; i<TOTAL; i++)
    {
      if (str.equals(CURVES[i][iColumn]))
      {
        iRow = i;
      }
    }

    return (iRow);
  }
}