/*
 * @iqstratControlPlotData.java Version 1.1 12/10/2008
 *
 * Copyright (c) 2008 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

import iqstrat.iqstratRemarkListStruct;
import iqstrat.gui.iqstratNotesCSVFrame;
//import iqstrat.gui.iqstratPlotFrame;

import las.lasFileDataStruct;
//import las.gui.lasDataEntryFrame;

import lith.lithology.lithologySymbolsListStruct;
import lith.lithology.lithologyListStruct;
import lith.texture.textureListStruct;

import rock.rockFileDataStruct;
import rock.rockDataListStruct;
import rock.fossil.fossilListStruct;
import rock.sedimentary.sedimentaryListStruct;
import rock.color.rockColorListStruct;
//import rock.gui.rockDataEntryFrame;

/** Class iqstratControlPlotData
 *  <p> This Class will provide support for the iqstratControlPlotFrame.
 *
 *  @version 1.1 12/10/2008
 *  @author  John R. Victorine
 */

public class iqstratControlPlotData
{
  /** Method computeLithologyFromLAS()
   * <p> This method will compute the Lithology from measured LAS File data.
   *  @param  stLASFileData   = LAS File Data
   *  @param  stSymbols       = Lithology Symbols Data List Structure
   *  @return stLASLithology  = Lithology List Data Structure
   */

  public static lithologyListStruct computeLithologyFromLAS(
      lasFileDataStruct          stLASFileData,
      lithologySymbolsListStruct stSymbols )
  {
    lithologyListStruct stLASLithology = null;
    String              sKEY           = "0";

    if (stLASFileData != null)
    {
      stLASLithology = lith.lithology.lithologyUtility.buildNew(
          iqstrat.iqstratTracksStruct._SCALE_HALF_FOOT,
          stLASFileData.depthStart,
          stLASFileData.depthEnd);

      sKEY = new String(cmn.cmnString.UniqueName());
      for (int i=0; i<stLASLithology.iCount; i++)
      {
        stLASLithology.stItem[i].sKEY = new String(sKEY + "_" + i);
      }

      stLASLithology = lith.lithology.lithologyUtility.computeLithology(
                           stLASFileData, stSymbols, stLASLithology);
    }

    return (stLASLithology);
  }

  /** Method computeLithologyFromLAS()
   * <p> This method will compute the Lithology from measured LAS File data.
   *  @param  iColorlith      = Colorlith identifier
   *  @param  stLASFileData   = LAS File Data
   *  @param  stSymbols       = Lithology Symbols Data List Structure
   *  @return stLASLithology  = Lithology List Data Structure
   */

  public static lithologyListStruct computeLithologyFromLAS(
      int                        iColorlith,
      lasFileDataStruct          stLASFileData,
      lithologySymbolsListStruct stSymbols )
  {
    lithologyListStruct stLASLithology = null;
    String              sKEY           = "0";
//    rockFileDataStruct  stROCK         = null;

    if (stLASFileData != null)
    {
      stLASLithology = lith.lithology.lithologyUtility.buildNew(
          iqstrat.iqstratTracksStruct._SCALE_HALF_FOOT,
          stLASFileData.depthStart,
          stLASFileData.depthEnd);

      sKEY = new String(cmn.cmnString.UniqueName());
      for (int i=0; i<stLASLithology.iCount; i++)
      {
        stLASLithology.stItem[i].sKEY = new String(sKEY + "_" + i);
      }

//      stLASLithology = lith.lithology.lithologyUtility.computeLithology(
//                           stLASFileData, stROCK, stSymbols, stLASLithology);
      stLASLithology = lith.lithology.lithologyUtility.computeLithology(
                           iColorlith, stLASFileData, stSymbols, stLASLithology);
    }

    return (stLASLithology);
  }

  /** Method computeLithologyFromCoreData()
   * <p> This method will compute the Lithology from measured core data.
   *  @param  stCore          = Measured Rock Data
   *  @param  stSymbols       = Lithology Symbols Data List Structure
   *  @return stRockLithology = Rock Lithology Data List Data Structure
   */

  public static lithologyListStruct computeLithologyFromCoreData(
      rockFileDataStruct         stCore,
      lithologySymbolsListStruct stSymbols )
  {
    lithologyListStruct stRockLithology = null;
//    lasFileDataStruct   stLASFileData   = null;
    double              dataStart       = 0.0;
    double              dataEnd         = 0.0;

    if (stCore != null)
    {
      dataStart = Math.floor( stCore.depthStart );
      dataEnd   = Math.ceil( stCore.depthEnd );

      stRockLithology = lith.lithology.lithologyUtility.buildNew(
          iqstrat.iqstratTracksStruct._SCALE_HALF_FOOT, dataStart, dataEnd);

//      stRockLithology = lith.lithology.lithologyUtility.computeLithology(
//                           stLASFileData, stCore, stSymbols, stRockLithology);
      stRockLithology = lith.lithology.lithologyUtility.computeLithology(
                           stCore, stSymbols, stRockLithology);
    }

    return (stRockLithology);
  }

  /* ================================================================== *
   * -------- Parse Comments/Remarks/Nots ASCII File Actions ---------- *
   * ================================================================== */

  /** Method getPlotLithology()
   * <p> This method will return the texture Plot data structure
   * @param  stRockLithology = Rock Lithology Data List Data Structure
   * @param  stPlotLithology = Rock Lithology plot data structure
   * @return stPlotLithology = Rock Lithology plot data structure
   */

  public static lithologyListStruct getPlotLithology(
      lithologyListStruct  stRockLithology,
      lithologyListStruct  stPlotLithology )
  {
    if (stPlotLithology != null)
      stPlotLithology.delete();
    stPlotLithology = null;

    if (stRockLithology != null)
    {
      stPlotLithology = lith.lithology.lithologyUtility.buildNew(
                            stRockLithology.iUnit,
                            stRockLithology.depthStart,
                            stRockLithology.depthEnd );

       for (int i=0; i<stRockLithology.iCount; i++)
       {
         stPlotLithology =  lith.lithology.lithologyUtility.addRecord(
            lith.lithology.lithologyUtility.copy(stRockLithology.stItem[i]),
            stPlotLithology );
       }
     }

     return (stPlotLithology);
  }

  /** Method getPlotTexture()
   * <p> This method will return the texture Plot data structure
   * @param  stTexture     = texture Data List Data Structure
   * @param  stPlotTexture = texture plot data structure
   * @return stPlotTexture = texture plot data structure
   */

  public static textureListStruct getPlotTexture(
      textureListStruct  stTexture,
      textureListStruct  stPlotTexture )
  {
    if (stPlotTexture != null)
      stPlotTexture.delete();
    stPlotTexture = null;

    if (stTexture != null)
    {
      stPlotTexture = lith.texture.textureUtility.buildNew(
          stTexture.iUnit, stTexture.depthStart, stTexture.depthEnd );

      for (int i=0; i<stTexture.iCount; i++)
      {
        stPlotTexture =
            lith.texture.textureUtility.addRecord(
              lith.texture.textureUtility.copy( stTexture.stItem[i] ),
              stPlotTexture );
      }
    }

    return (stPlotTexture);
  }
}


/*
 *  @version 1.1 12/10/2008
 *  @author  John Victorine
 */
