/*
 * @iqstratControlListStruct.java Version 1.0 02/04/2009
 *
 * Copyright (c) 2009 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat;

import iqstrat.iqstratControlStruct;

/** CLASS iqstratControlListStruct
 *  <p> This Structure holds the cross section control dialog settings.
 *
 *  @version 1.1 02/04/2009
 *  @author  John R. Victorine
 */

public class iqstratControlListStruct
{
  // Project Identifier

  public String sKID = "0"; // Project KID - Created on KGS DB
  public String sKEY = "0"; // Project KEY - Created from Data & Time

  // Plot titles

  public String sTitle1 = ""; // 1st Plot Title
  public String sTitle2 = ""; // 2nd Plot Title

  // Cross Section Plot Depth Range

  public double depthStart = 0.0;  // Starting Depth of the Rock Data
  public double depthEnd   = 0.0;  // Ending Depth of the Rock Data

  // Cross Section Well Control Data List

  public int                  iCount    = 0;    // Total Number of Records
  public iqstratControlStruct stItem[]  = null; // Array of Control Data Struct

  /** Method delete()
   * <p> This method will force set the Objects to null and force Java to
   *     free unwanted memory
   */

  public void delete()
  {
    // Project Identifier

    sKID    = null; // Project KID - Created on KGS DB
    sKEY    = null; // Project KEY - Created from Data & Time

    // Plot titles

    sTitle1 = null;
    sTitle2 = null;

    for (int i=0; i<iCount; i++)
    {
      if (stItem[i] != null)
        stItem[i].delete();
      stItem[i] = null;
    }

    iCount = 0;
  }
}