/*
 * @iqstratIO_Files.java Version 1.0 08/30/2011
 *
 * Copyright (c) 2012 Kansas Geological Survey
 * 1930 Constant Avenue, Lawrence, Kansas, 66047, U.S.A.
 * All Rights Reserved.
 */

package iqstrat.io;

import java.io.*;
import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

import iqstrat.iqstratStruct;
import iqstrat.iqstratHeadersStruct;

import util.utilFileIO;
import util.utilImageIO;

/** Class iqstratIO_Files
 *  <p> This class will manage the plot output for the profile plot
 *
 *  @version 1.1 08/30/2011
 *  @author  John R. Victorine
 */

public class iqstratIO_Files
{
  /** Method createImage( iqstratStruct stStruct, BufferedImage image )
   * <p> this method will create an image from the Plot image
   *  @param stStruct = The Global IQSTRAT Data Structure
   *  @param image    = Profile Plot Buffered Image
   */

  public static void createImage( iqstratStruct stStruct, BufferedImage image )
  {
    String sOut  = "";
    String sPath = stStruct.sDirectory;

    sOut = sPath  + "/" + stStruct.sName + ".png";

    utilImageIO pImage = new utilImageIO( image );
    pImage.save( sOut );

    image = null;
    sOut  = null;
  }

  /** Method createHTML( iqstratHeadersStruct stHeader )
   * <p> this method will create an html file from the Plot image
   *  @param stHeader  = The Header Data Structure
   */

  public static void createHTML( iqstratStruct stStruct )
  {
    int           iError = util.utilFileIO.NOERROR;
    String        sOut   = stStruct.sName + ".html";
    String        sPath  = stStruct.sDirectory;
    String        sXML   = "";
    utilFileIO    pIO    = null;

    // Create HTML Document

    sXML = new String(sXML + "<html>\n");
    sXML = new String(sXML + "  <head>\n");
    sXML = new String(sXML + "    <title>GEMINI - Web Applet Image Plot</title>\n");
    sXML = new String(sXML + "  </head>\n");

    sXML = new String(sXML + "  <body>\n");
    sXML = new String(sXML + "    <a href=\"http://www.kgs.ku.edu/PRS/Ozark/TYPE_LOG/PDF.html\"> " +
                             "Create a PDF Document of this PNG Image\n");
    sXML = new String(sXML + "    <p>\n");
//    sXML = new String(sXML + "    <img src=\"" + sPath  + "\\" + stStruct.sName + ".png\">\n");
    sXML = new String(sXML + "    <img src=\"" + stStruct.sName + ".png\">\n");
    sXML = new String(sXML + "  </body>\n");
    sXML = new String(sXML + "</html>\n");

    // Write HTML Document to Temporary File

    pIO  = new utilFileIO();
    pIO.Open(util.utilFileIO.DIRECTORY, util.utilFileIO.WRITE, sPath, sOut);
    pIO.Write(sXML);

    if (iError == util.utilFileIO.NOERROR)
      pIO.Close();

    pIO.delete();
    pIO = null;

    util.BrowserControl.displayURL(sPath + "\\" + sOut);

    sOut  = null;
    sPath = null;
    sXML  = null;
  }

  /** Method createDRA()
   * <p> This method will create a Depth Registration ASCII Format file
   *     of the Generated PNG Image
   *  @param stStruct  = The Global IQSTRAT Data Structure
   *  @param stHeader  = The Header Data Structure
   *  @param iWidth    = Width of Plot
   *  @param iHeight   = Height of Plot
   *  @param dStart    = Starting Depth
   *  @param dEnd      = Ending Depth
   */

  public static void createDRA( iqstratStruct        stStruct,
                                iqstratHeadersStruct stHeader,
                                int                  iWidth,
                                int                  iHeight,
                                double               dStart,
                                double               dEnd )
  {
    String     sText  = "";
    String     sUWI   = "";
    String     sName  = "";
    int        iH     = iqstrat.iqstratTracksStruct.PLOT_TITLES;
    String     sOut   = "";
    String     sPath  = stStruct.sDirectory;
    int        iError = util.utilFileIO.NOERROR;
    utilFileIO pIO    = null;

    sOut = stStruct.sName + ".dra";

    // Build File

    sUWI = new String( "NONE" );
    if (stHeader.sAPI.length() > 0)
      sUWI = new String( stHeader.sAPI );
    else if (stHeader.sKID.length() > 0)
      sUWI = new String( stHeader.sKID );
    else if (stHeader.sWELLKID.length() > 0)
      sUWI = new String( stHeader.sWELLKID );

    if (stHeader.sName.length() > 0)
      sName = new String( stHeader.sName );

    sText = new String( sText + "FILE,1.0,F,KGS_PROFILE\n" );
    sText = new String( sText + "WELL,\"" + sUWI + "\"," );
    if (sName.length() > 0)
      sText = new String( sText + "\"" + sName + "\",," );
    else
      sText = new String( sText + ",," );
    sText = new String( sText + "\n" );
    sText = new String( sText + "LOG,\"" + stStruct.sName +
                              ".png\",PROFILE,," +
                              dStart + ",0," + iH     + "," +
                              dEnd   + ","   + iWidth + "," + iHeight + "\n" );
    sText = new String( sText + "CURV," + "0,0," + iWidth + "," + iHeight);

    // Write HTML Document to Temporary File

    pIO  = new utilFileIO();
    pIO.Open(util.utilFileIO.DIRECTORY, util.utilFileIO.WRITE, sPath, sOut);
    pIO.Write(sText);

    if (iError == util.utilFileIO.NOERROR)
      pIO.Close();
  }
}
